/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.search.ui.providers;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.services.labelprovider.service.IFilteredLabelProvider;
import org.eclipse.papyrus.infra.services.labelprovider.service.impl.LabelProviderServiceImpl;
import org.eclipse.papyrus.uml.search.ui.Activator;
import org.eclipse.papyrus.uml.search.ui.Messages;
import org.eclipse.papyrus.views.search.results.AttributeMatch;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class AttributeMatchLabelProvider
implements IFilteredLabelProvider {
    public Image getImage(Object element) {
        if (element instanceof AttributeMatch) {
            LabelProviderServiceImpl service = new LabelProviderServiceImpl();
            try {
                service.startService();
                return service.getLabelProvider().getImage(((AttributeMatch)element).getMetaAttribute());
            }
            catch (ServiceException e) {
                Activator.log.warn(String.valueOf(Messages.AttributeMatchLabelProvider_0) + ((AttributeMatch)element).getMetaAttribute());
            }
        }
        return null;
    }

    private String printResult(String sectionThatMatch, String value, int offset, int lenght, String attributeName) {
        return "\"" + sectionThatMatch + "\"" + Messages.AttributeMatchLabelProvider_3 + "\"" + value + "\" [" + offset + "," + lenght + "] (" + attributeName + Messages.AttributeMatchLabelProvider_8 + ")";
    }

    public String getText(Object element) {
        AttributeMatch attributeMatch;
        if (element instanceof AttributeMatch && (attributeMatch = (AttributeMatch)element).getSource() instanceof EObject) {
            Property source;
            Class containingClass;
            EObject target = (EObject)attributeMatch.getSource();
            if (attributeMatch.getMetaAttribute() instanceof EAttribute) {
                EAttribute source2 = (EAttribute)attributeMatch.getMetaAttribute();
                if (target.eGet((EStructuralFeature)source2) instanceof String) {
                    String value = (String)target.eGet((EStructuralFeature)source2);
                    return this.printResult(value.substring(attributeMatch.getOffset(), attributeMatch.getLength()), value, attributeMatch.getOffset(), attributeMatch.getLength(), source2.getName());
                }
                String value = String.valueOf(target.eGet((EStructuralFeature)source2));
                return this.printResult(value.substring(attributeMatch.getOffset(), attributeMatch.getLength()), value, attributeMatch.getOffset(), attributeMatch.getLength(), source2.getName());
            }
            if (attributeMatch.getMetaAttribute() instanceof Property && (containingClass = (source = (Property)attributeMatch.getMetaAttribute()).getClass_()) instanceof Stereotype && target instanceof Element) {
                Object tagValue = ((Element)target).getValue((Stereotype)containingClass, ((Property)attributeMatch.getMetaAttribute()).getName());
                if (tagValue instanceof String) {
                    String value = (String)tagValue;
                    return this.printResult(value.substring(attributeMatch.getOffset(), attributeMatch.getLength()), value, attributeMatch.getOffset(), attributeMatch.getLength(), source.getName());
                }
                String value = String.valueOf(tagValue);
                return this.printResult(value.substring(attributeMatch.getOffset(), attributeMatch.getLength()), value, attributeMatch.getOffset(), attributeMatch.getLength(), source.getName());
            }
        }
        return "";
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public boolean accept(Object element) {
        return element instanceof AttributeMatch;
    }
}

