/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.search.ui.query;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.domain.evaluation.DomainModelManager;
import org.eclipse.ocl.examples.domain.evaluation.EvaluationHaltedException;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.pivot.Environment;
import org.eclipse.ocl.examples.pivot.EnvironmentFactory;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.context.ParserContext;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitorImpl;
import org.eclipse.ocl.examples.pivot.evaluation.PivotEvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.utilities.BaseResource;
import org.eclipse.ocl.examples.pivot.utilities.PivotEnvironment;
import org.eclipse.ocl.examples.pivot.utilities.PivotEnvironmentFactory;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.console.messages.ConsoleMessages;
import org.eclipse.ocl.examples.xtext.essentialocl.ui.model.BaseDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.uml.search.ui.Activator;
import org.eclipse.papyrus.uml.search.ui.Messages;
import org.eclipse.papyrus.uml.search.ui.query.AbstractPapyrusQuery;
import org.eclipse.papyrus.uml.search.ui.results.PapyrusSearchResult;
import org.eclipse.papyrus.views.search.results.AbstractResultEntry;
import org.eclipse.papyrus.views.search.results.ModelElementMatch;
import org.eclipse.papyrus.views.search.scope.ScopeEntry;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class PapyrusOCLQuery
extends AbstractPapyrusQuery {
    private EObject contextObject;
    private PapyrusSearchResult results;
    private ScopeEntry scopeEntry;
    private BaseDocument queryEditorDocument;
    private ParserContext parserContext;
    private MetaModelManager metaModelManager;
    private DomainModelManager modelManager;
    protected Set<AbstractResultEntry> fResults = null;

    public PapyrusOCLQuery(BaseDocument queryEditorDocument, ParserContext parserContext, MetaModelManager metaModelManager, DomainModelManager modelManager, EObject contextObject, ScopeEntry scopeEntry) {
        this.queryEditorDocument = queryEditorDocument;
        this.contextObject = contextObject;
        this.scopeEntry = scopeEntry;
        this.parserContext = parserContext;
        this.metaModelManager = metaModelManager;
        this.modelManager = modelManager;
        ArrayList<ScopeEntry> scopeEntries = new ArrayList<ScopeEntry>();
        scopeEntries.add(scopeEntry);
        this.results = new PapyrusSearchResult(this);
        this.fResults = new HashSet<AbstractResultEntry>();
    }

    protected boolean evaluate(final String expression) {
        if (expression == null || expression.trim().length() <= 0) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.PapyrusOCLQuery_0, (String)Messages.PapyrusOCLQuery_1);
            return false;
        }
        boolean result = true;
        try {
            BaseDocument doc = this.queryEditorDocument;
            BaseDocument editorDocument = this.queryEditorDocument;
            Object value = null;
            try {
                value = editorDocument.readOnly((IUnitOfWork)new IUnitOfWork<Object, XtextResource>(){

                    public Object exec(XtextResource state) throws Exception {
                        if (!$assertionsDisabled && state == null) {
                            throw new AssertionError();
                        }
                        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                        EvaluationRunnable runnable = new EvaluationRunnable((BaseResource)state, expression);
                        runnable.run((IProgressMonitor)new NullProgressMonitor());
                        return runnable.getValue();
                    }
                });
            }
            catch (Exception e) {
                Activator.log.error((Throwable)e);
            }
            if (value instanceof InvalidValueException) {
                InvalidValueException exception = (InvalidValueException)((Object)value);
                Throwable cause = exception.getCause();
                if (cause != null) {
                    // empty if block
                }
            } else if (value != null) {
                CollectionValue collectionValue = ValuesUtil.isCollectionValue((Object)value);
                if (collectionValue != null) {
                    for (Object elementValue : collectionValue.iterable()) {
                        if (!(elementValue instanceof EObject)) continue;
                        ModelElementMatch match = new ModelElementMatch(elementValue, this.scopeEntry);
                        this.fResults.add((AbstractResultEntry)match);
                    }
                } else if (value instanceof EObject) {
                    ModelElementMatch match = new ModelElementMatch(value, this.scopeEntry);
                    this.fResults.add((AbstractResultEntry)match);
                }
            }
        }
        catch (Exception e) {
            result = false;
            Activator.log.error((Throwable)e);
        }
        return result;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        this.results.removeAll();
        this.fResults.clear();
        this.evaluate(this.queryEditorDocument.get().trim());
        monitor.done();
        return Status.OK_STATUS;
    }

    public String getLabel() {
        return Messages.PapyrusQuery_6;
    }

    public boolean canRerun() {
        return false;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        for (AbstractResultEntry match : this.fResults) {
            this.results.addMatch((Match)match);
        }
        return this.results;
    }

    public String getSearchQueryText() {
        if (this.queryEditorDocument.get().length() > 25) {
            return this.queryEditorDocument.get().subSequence(0, 25) + "...";
        }
        return this.queryEditorDocument.get();
    }

    protected static class CancelableEvaluationVisitor
    extends EvaluationVisitorImpl {
        @NonNull
        private final IProgressMonitor monitor;

        protected CancelableEvaluationVisitor(@NonNull IProgressMonitor monitor, @NonNull Environment env, @NonNull EvaluationEnvironment evalEnv, @NonNull DomainModelManager modelManager) {
            super(env, evalEnv, modelManager);
            this.monitor = monitor;
        }

        @NonNull
        public EvaluationVisitor createNestedEvaluator() {
            EnvironmentFactory factory = this.environment.getFactory();
            EvaluationEnvironment nestedEvalEnv = factory.createEvaluationEnvironment(this.evaluationEnvironment);
            CancelableEvaluationVisitor nestedVisitor = new CancelableEvaluationVisitor(this.monitor, this.environment, nestedEvalEnv, this.modelManager);
            nestedVisitor.setLogger(this.getLogger());
            return nestedVisitor;
        }
    }

    private class EvaluationRunnable
    implements IRunnableWithProgress {
        @NonNull
        private final BaseResource resource;
        @NonNull
        private final String expression;
        private Object value = null;

        public EvaluationRunnable(@NonNull BaseResource resource, String expression) {
            this.resource = resource;
            this.expression = expression;
        }

        public Object getValue() {
            return this.value;
        }

        public void run(IProgressMonitor monitor) {
            ExpressionInOCL expressionInOCL;
            monitor.beginTask(NLS.bind((String)ConsoleMessages.Progress_Title, (Object)this.expression), 10);
            monitor.subTask(ConsoleMessages.Progress_Synchronising);
            monitor.worked(1);
            try {
                PivotUtil.checkResourceErrors((String)"", (Resource)this.resource);
                expressionInOCL = PapyrusOCLQuery.this.parserContext.getExpression(this.resource);
            }
            catch (ParserException e) {
                this.value = new InvalidValueException((Exception)((Object)e), ConsoleMessages.Result_ParsingFailure);
                return;
            }
            if (expressionInOCL != null) {
                monitor.subTask(ConsoleMessages.Progress_Extent);
                PivotEnvironmentFactory envFactory = new PivotEnvironmentFactory(null, PapyrusOCLQuery.this.metaModelManager);
                PivotEnvironment environment = envFactory.createEnvironment();
                PivotEvaluationEnvironment evaluationEnvironment = envFactory.createEvaluationEnvironment();
                Object contextValue = PapyrusOCLQuery.this.metaModelManager.getIdResolver().boxedValueOf((Object)PapyrusOCLQuery.this.contextObject);
                evaluationEnvironment.add((DomainTypedElement)DomainUtil.nonNullModel((Object)expressionInOCL.getContextVariable()), contextValue);
                DomainModelManager domainModelManager = evaluationEnvironment.createModelManager((Object)PapyrusOCLQuery.this.contextObject);
                PapyrusOCLQuery.this.modelManager = domainModelManager;
                DomainModelManager modelManager2 = domainModelManager;
                monitor.worked(2);
                monitor.subTask(ConsoleMessages.Progress_Evaluating);
                try {
                    CancelableEvaluationVisitor evaluationVisitor = new CancelableEvaluationVisitor(monitor, (Environment)environment, (EvaluationEnvironment)evaluationEnvironment, modelManager2);
                    this.value = evaluationVisitor.visitExpressionInOCL(expressionInOCL);
                }
                catch (InvalidValueException e) {
                    this.value = e;
                }
                catch (EvaluationHaltedException e) {
                    this.value = new InvalidValueException(ConsoleMessages.Result_EvaluationTerminated, new Object[0]);
                }
                catch (Exception e) {
                    this.value = new InvalidValueException(e, ConsoleMessages.Result_EvaluationFailure);
                }
            }
            monitor.worked(4);
        }
    }
}

