/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.stereotypecollector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.emf.utils.BusinessModelResolver;
import org.eclipse.papyrus.infra.onefile.model.IPapyrusFile;
import org.eclipse.papyrus.uml.search.ui.Activator;
import org.eclipse.papyrus.uml.stereotypecollector.IStereotypeCollector;
import org.eclipse.papyrus.uml.stereotypecollector.Messages;
import org.eclipse.papyrus.uml.stereotypecollector.UMLResourceVisitor;
import org.eclipse.papyrus.views.search.utils.ModelUtils;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.Stereotype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StereotypeCollector
implements IStereotypeCollector {
    private static StereotypeCollector instance = null;

    private StereotypeCollector() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final StereotypeCollector getInstance() {
        if (instance != null) return instance;
        Class<StereotypeCollector> clazz = StereotypeCollector.class;
        synchronized (StereotypeCollector.class) {
            if (instance != null) return instance;
            instance = new StereotypeCollector();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public Collection<Stereotype> computeAvailableStereotypes(ISearchPageContainer container) {
        HashSet<Stereotype> preResult = new HashSet<Stereotype>();
        HashSet<Profile> profiles = new HashSet<Profile>();
        HashSet<IResource> umlResources = new HashSet<IResource>();
        if (container == null) {
            umlResources.addAll(this.createWorkspaceScope());
        } else {
            switch (container.getSelectedScope()) {
                case 0: {
                    umlResources.addAll(this.createWorkspaceScope());
                    break;
                }
                case 1: {
                    ISelection selection = container.getSelection();
                    if (!selection.isEmpty()) {
                        if (selection instanceof IStructuredSelection) {
                            umlResources.addAll(this.createSelectionScope((IStructuredSelection)selection));
                            break;
                        }
                        umlResources.addAll(this.createWorkspaceScope());
                        break;
                    }
                    umlResources.addAll(this.createWorkspaceScope());
                    break;
                }
                case 3: {
                    String[] projects = container.getSelectedProjectNames();
                    umlResources.addAll(this.createProjectsScope(projects));
                    break;
                }
                case 2: {
                    IWorkingSet[] workingSets = container.getSelectedWorkingSets();
                    umlResources.addAll(this.createWorkingSetsScope(workingSets));
                    break;
                }
            }
        }
        for (IResource umlRes : umlResources) {
            URI uri = URI.createPlatformResourceURI((String)umlRes.getFullPath().toString(), (boolean)true);
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource resource = resourceSet.getResource(uri, true);
            TreeIterator UMLResourceContentIterator = resource.getAllContents();
            while (UMLResourceContentIterator.hasNext()) {
                EObject umlElement = (EObject)UMLResourceContentIterator.next();
                if (!(umlElement instanceof ProfileApplication)) continue;
                boolean found = false;
                Profile profileToProcess = ((ProfileApplication)umlElement).getAppliedProfile();
                for (Profile alreadyAddedProfile : profiles) {
                    if (!EcoreUtil.equals((EObject)alreadyAddedProfile, (EObject)profileToProcess)) continue;
                    found = true;
                }
                if (found) continue;
                profiles.add(profileToProcess);
            }
        }
        for (Profile profile : profiles) {
            TreeIterator profileContentIterator = profile.eAllContents();
            while (profileContentIterator.hasNext()) {
                EObject profileContent = (EObject)profileContentIterator.next();
                if (!(profileContent instanceof Stereotype)) continue;
                boolean found = false;
                Stereotype stereotypeToProcess = (Stereotype)profileContent;
                for (Stereotype alreadyAddedStereotype : preResult) {
                    if (!EcoreUtil.equals((EObject)alreadyAddedStereotype, (EObject)stereotypeToProcess)) continue;
                    found = true;
                }
                if (found) continue;
                preResult.add(stereotypeToProcess);
            }
        }
        HashSet<Stereotype> result = new HashSet<Stereotype>();
        for (Stereotype stereo : preResult) {
            result.add(stereo);
            for (Classifier parent : stereo.getGenerals()) {
                if (!(parent instanceof Stereotype)) continue;
                result.add((Stereotype)parent);
                boolean found = false;
                Stereotype stereotypeToProcess = (Stereotype)parent;
                for (Stereotype alreadyAddedStereotype : result) {
                    if (!EcoreUtil.equals((EObject)alreadyAddedStereotype, (EObject)stereotypeToProcess)) continue;
                    found = true;
                }
                if (found) continue;
                result.add(stereotypeToProcess);
            }
        }
        return result;
    }

    protected List<IResource> createSelectionScope(IStructuredSelection selection) {
        ArrayList<IResource> results = new ArrayList<IResource>();
        for (Object object : selection) {
            if (object instanceof IPapyrusFile) {
                IResource[] associatedResources;
                IResource[] iResourceArray = associatedResources = ((IPapyrusFile)object).getAssociatedResources();
                int n = associatedResources.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource iResource = iResourceArray[n2];
                    results.addAll(this.findUMLModels(iResource));
                    ++n2;
                }
                continue;
            }
            if (object instanceof IResource) {
                results.addAll(this.findUMLModels((IResource)object));
                continue;
            }
            Object element = BusinessModelResolver.getInstance().getBusinessModel(object);
            if (element instanceof EObject) {
                Resource eResource = ((EObject)element).eResource();
                IFile resource = ModelUtils.getIFile((Resource)eResource);
                if (resource != null) {
                    results.add((IResource)resource);
                    continue;
                }
                results.addAll(this.createWorkspaceScope());
                continue;
            }
            results.addAll(this.createWorkspaceScope());
        }
        return results;
    }

    protected List<IResource> createProjectsScope(String[] projects) {
        ArrayList<IResource> results = new ArrayList<IResource>();
        String[] stringArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            String projectName = stringArray[n2];
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project.isOpen()) {
                results.addAll(this.findUMLModels((IResource)project));
            }
            ++n2;
        }
        return results;
    }

    protected List<IResource> createWorkingSetsScope(IWorkingSet[] workingSets) {
        ArrayList<IResource> results = new ArrayList<IResource>();
        if (workingSets != null && workingSets.length > 0) {
            IWorkingSet[] iWorkingSetArray = workingSets;
            int n = workingSets.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkingSet iWorkingSet = iWorkingSetArray[n2];
                IAdaptable[] iAdaptableArray = iWorkingSet.getElements();
                int n3 = iAdaptableArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IAdaptable element = iAdaptableArray[n4];
                    Object resource = element.getAdapter(IResource.class);
                    if (resource instanceof IResource) {
                        results.addAll(this.findUMLModels((IResource)resource));
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return results;
    }

    protected Collection<IResource> findUMLModels(IResource res) {
        UMLResourceVisitor visitor = new UMLResourceVisitor();
        try {
            res.accept((IResourceProxyVisitor)visitor, 2);
        }
        catch (CoreException e) {
            Activator.log.warn(String.valueOf(Messages.StereotypeCollector_0) + res);
        }
        return visitor.getParticipants();
    }

    protected Collection<IResource> createWorkspaceScope() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        return this.findUMLModels((IResource)root);
    }
}

