/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.handlers;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.tools.util.WorkbenchPartHelper;
import org.eclipse.papyrus.uml.service.types.filter.ICommandFilter;
import org.eclipse.papyrus.uml.service.types.handlers.AbstractCommandHandler;
import org.eclipse.papyrus.uml.service.types.utils.ICommandContext;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractCreateCommandHandler
extends AbstractCommandHandler {
    protected Command createCommand;
    protected CreateElementRequest createRequest;

    protected abstract IElementType getElementTypeToCreate();

    protected Command buildCommand() {
        ICommandContext commandContext = this.getCommandContext();
        if (commandContext == null) {
            return UnexecutableCommand.INSTANCE;
        }
        EObject container = commandContext.getContainer();
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)container);
        if (provider == null) {
            return UnexecutableCommand.INSTANCE;
        }
        ICommand createGMFCommand = provider.getEditCommand((IEditCommandRequest)this.createRequest);
        if (createGMFCommand != null) {
            GMFtoEMFCommandWrapper emfCommand = new GMFtoEMFCommandWrapper(createGMFCommand);
            return emfCommand;
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected CreateElementRequest buildRequest() {
        ICommandContext commandContext = this.getCommandContext();
        if (commandContext != null) {
            EObject container = commandContext.getContainer();
            EReference reference = commandContext.getReference();
            boolean nullReference = reference == null;
            return nullReference ? new CreateElementRequest(this.getEditingDomain(), container, this.getElementTypeToCreate()) : new CreateElementRequest(this.getEditingDomain(), container, this.getElementTypeToCreate(), reference);
        }
        return null;
    }

    protected Command getCommand() {
        this.createRequest = this.buildRequest();
        this.createCommand = this.buildCommand();
        return this.createCommand;
    }

    protected IWorkbenchPart getActiveWorkbenchPart() {
        return WorkbenchPartHelper.getCurrentActiveWorkbenchPart();
    }

    public void setEnabled(Object evaluationContext) {
        IElementType newElementType = this.getElementTypeToCreate();
        boolean isEnabled = this.getCommandFilter().getVisibleCommands().contains(newElementType);
        if (isEnabled) {
            Command command = this.getCommand();
            isEnabled = command.canExecute();
        }
        this.setBaseEnabled(isEnabled);
    }

    public abstract ICommandFilter getCommandFilter();
}

