/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.table.common.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.facet.infra.facet.FacetSet;
import org.eclipse.emf.facet.infra.facet.core.FacetSetCatalog;
import org.eclipse.papyrus.infra.table.instance.papyrustableinstance.PapyrusTableInstance;
import org.eclipse.papyrus.uml.profilefacet.generation.factory.ProfileFacetGenericFactory;
import org.eclipse.papyrus.uml.profilefacet.metamodel.profilefacet.ProfileFacetSet;
import org.eclipse.papyrus.uml.profilefacet.utils.AdditionalContentsUtils;
import org.eclipse.papyrus.uml.table.common.provider.AbstractAdditionalContentsProvider;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileFacetSetProvider
extends AbstractAdditionalContentsProvider {
    @Override
    public void setPapyrusTable(PapyrusTableInstance table) {
        super.setPapyrusTable(table);
    }

    @Override
    public Collection<FacetSet> getAdditionalFeatures() {
        HashSet appliedStereotypes = new HashSet();
        for (EObject current : this.tableContents) {
            if (!(current instanceof Element)) continue;
            appliedStereotypes.addAll(((Element)current).getAppliedStereotypes());
        }
        HashSet<Profile> usedProfile = new HashSet<Profile>();
        for (Stereotype current : appliedStereotypes) {
            usedProfile.add((Profile)PackageUtil.getRootPackage((Element)current));
        }
        EPackage additionalContentsFacetSet = AdditionalContentsUtils.getAdditionalContentsEPackage((PapyrusTableInstance)this.pTable);
        HashMap<String, ProfileFacetSet> mapProfileQNameFacetSet = new HashMap<String, ProfileFacetSet>();
        if (additionalContentsFacetSet != null) {
            TreeIterator iter = additionalContentsFacetSet.eAllContents();
            while (iter.hasNext()) {
                EObject eObject = (EObject)iter.next();
                if (!(eObject instanceof ProfileFacetSet)) continue;
                mapProfileQNameFacetSet.put(((ProfileFacetSet)eObject).getProfileQualifiedName(), (ProfileFacetSet)eObject);
            }
        }
        ArrayList<FacetSet> additionalFacetSet = new ArrayList<FacetSet>();
        for (Profile profile : usedProfile) {
            String profileQN = profile.getQualifiedName();
            XMIResource res = (XMIResource)profile.eResource();
            String profile_XMI_ID = res.getID((EObject)profile);
            if (mapProfileQNameFacetSet.containsKey(profileQN)) continue;
            ProfileFacetSet registeredFacetSet = this.findRegisteredProfileFacetSet(profileQN, profile_XMI_ID);
            if (registeredFacetSet != null) {
                additionalFacetSet.add((FacetSet)registeredFacetSet);
                continue;
            }
            ProfileFacetGenericFactory factory = new ProfileFacetGenericFactory();
            ProfileFacetSet set = factory.createProfileFacetSet((Package)profile);
            if (set == null) continue;
            additionalFacetSet.add((FacetSet)set);
        }
        return additionalFacetSet;
    }

    protected ProfileFacetSet findRegisteredProfileFacetSet(String rootProfileQualifiedName, String rootProfileXMI_ID) {
        URI uri;
        ResourceSet set;
        Resource res;
        if (rootProfileQualifiedName != null && rootProfileXMI_ID != null) {
            HashSet availableFacetSets = new HashSet();
            availableFacetSets.addAll(FacetSetCatalog.getSingleton().getAllFacetSets());
            for (FacetSet current : availableFacetSets) {
                ProfileFacetSet set2;
                if (!(current instanceof ProfileFacetSet) || !rootProfileQualifiedName.equals((set2 = (ProfileFacetSet)current).getProfileQualifiedName()) || !rootProfileXMI_ID.equals(set2.getRepresentedElement_XMI_ID())) continue;
                return set2;
            }
        }
        if (rootProfileQualifiedName.equals("SysML") && (res = (set = this.pTable.eResource().getResourceSet()).getResource(uri = URI.createPlatformPluginURI((String)"org.eclipse.papyrus.sysml.facets/resources/sysml_profilefacet.facetSet", (boolean)true), true)) != null && !res.getContents().isEmpty() && res.getContents().get(0) instanceof ProfileFacetSet) {
            EcoreUtil.resolveAll((Resource)res);
            return (ProfileFacetSet)res.getContents().get(0);
        }
        return null;
    }
}

