/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.table.widget.celleditors.composite;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.facet.widgets.celleditors.AbstractCellEditorComposite;
import org.eclipse.emf.facet.widgets.celleditors.internal.Messages;
import org.eclipse.emf.facet.widgets.internal.CustomizableLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.uml.profilefacet.metamodel.profilefacet.StereotypePropertyElement;
import org.eclipse.papyrus.uml.profilefacet.utils.StereotypePropertyUtils;
import org.eclipse.papyrus.uml.table.widget.celleditors.utils.NoReferencedElement;
import org.eclipse.papyrus.uml.table.widget.celleditors.utils.StereotypePropertyFacetElementUtils;
import org.eclipse.papyrus.uml.tools.providers.UMLContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnaryReferencePapyrusCellEditorComposite
extends AbstractCellEditorComposite<EObject> {
    private static final int GRID_DATA_HEIGHT = 50;
    private final Button button;
    private final Combo combo;
    private final Control parentControl;
    private final EObject source;
    private final Map<String, EObject> fElements = new TreeMap<String, EObject>();
    private final EStructuralFeature feature;

    public UnaryReferencePapyrusCellEditorComposite(final Composite parent, List<EObject> eObjects, EObject source1, EStructuralFeature feature1) {
        super(parent);
        assert (source1 instanceof Element);
        this.source = StereotypePropertyFacetElementUtils.getRealSource(source1, feature1);
        this.feature = StereotypePropertyFacetElementUtils.getRealFeature(source1, feature1);
        Stereotype ste = null;
        if (feature1 instanceof StereotypePropertyElement) {
            ste = StereotypePropertyUtils.getAppliedStereotype((Element)((Element)source1), (StereotypePropertyElement)((StereotypePropertyElement)feature1));
        }
        this.parentControl = parent;
        UMLLabelProvider labelProvider = new UMLLabelProvider();
        CustomizableLabelProvider customizableLabelProvider = new CustomizableLabelProvider();
        UMLContentProvider provider = ste != null ? new UMLContentProvider(this.source, this.feature, ste, this.source.eResource().getResourceSet()) : new UMLContentProvider(source1, feature1, null, this.source.eResource().getResourceSet());
        EObject noReferencedElement = null;
        for (EObject eObject : eObjects) {
            String label;
            if (eObject instanceof NoReferencedElement) {
                label = eObject.toString();
                noReferencedElement = eObject;
            } else {
                label = customizableLabelProvider.getText((Object)eObject);
            }
            if (this.fElements.get(label) != null) {
                int suffix = 2;
                while (this.fElements.get(String.valueOf(label) + " (" + suffix + ")") != null) {
                    ++suffix;
                }
                this.fElements.put(String.valueOf(label) + " (" + suffix + ")", eObject);
                continue;
            }
            this.fElements.put(label, eObject);
        }
        GridLayout compositeLayout = new GridLayout(2, false);
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        compositeLayout.horizontalSpacing = 0;
        this.setLayout((Layout)compositeLayout);
        this.combo = new Combo((Composite)this, 4);
        FontData[] fontData = Display.getDefault().getSystemFont().getFontData();
        fontData[0].setHeight(fontData[0].getHeight());
        Font font = new Font((Device)Display.getDefault(), fontData);
        this.combo.setFont(font);
        for (String label : this.fElements.keySet()) {
            this.combo.add(label);
        }
        if (noReferencedElement != null) {
            this.combo.remove(noReferencedElement.toString());
            this.combo.add(noReferencedElement.toString(), 0);
        }
        GridData comboGridData = new GridData(4, 4, true, true);
        this.combo.setLayoutData((Object)comboGridData);
        UnaryReferencePapyrusCellEditorComposite.addCompletionHandler(this.combo, this.fElements.keySet());
        Object currentValue = this.source.eGet(this.feature);
        if (currentValue == null) {
            int index;
            if (noReferencedElement != null && (index = this.combo.indexOf(noReferencedElement.toString())) > -1) {
                this.combo.select(index);
            }
        } else {
            String txt = customizableLabelProvider.getText(currentValue);
            int index = this.combo.indexOf(txt);
            if (index > -1) {
                this.combo.select(index);
            }
        }
        this.combo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 13 && event.stateMask == 0 || event.keyCode == 0x1000050 && event.stateMask == 0) {
                    if (UnaryReferencePapyrusCellEditorComposite.this.isValid()) {
                        UnaryReferencePapyrusCellEditorComposite.this.commit();
                    } else {
                        MessageDialog.openWarning((Shell)parent.getShell(), (String)Messages.UnaryReferenceCellEditorComposite_0, (String)Messages.UnaryReferenceCellEditorComposite_1);
                    }
                } else if (event.keyCode == 27 && event.stateMask == 0) {
                    UnaryReferencePapyrusCellEditorComposite.this.close();
                }
            }
        });
        this.button = new Button((Composite)this, 8);
        this.button.setText("...");
        GridData buttonGridData = new GridData(4, 4, false, true);
        buttonGridData.heightHint = 50;
        this.button.setLayoutData((Object)buttonGridData);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter((ILabelProvider)labelProvider, provider){
            private final /* synthetic */ ILabelProvider val$labelProvider;
            private final /* synthetic */ UMLContentProvider val$provider;
            {
                this.val$labelProvider = iLabelProvider;
                this.val$provider = uMLContentProvider;
            }

            public void widgetSelected(SelectionEvent e) {
                TreeSelectorDialog dialog = new TreeSelectorDialog(Display.getCurrent().getActiveShell()){

                    public void okPressed() {
                        Object[] selectedElements = new Object[this.getResult().length];
                        Object[] result = this.getResult();
                        int i = 0;
                        while (i < result.length) {
                            Object adapted;
                            selectedElements[i] = adapted = val$provider.getAdaptedValue(result[i]);
                            ++i;
                        }
                        String selectedElementLabel = null;
                        if (selectedElements.length > 0) {
                            Set<Map.Entry<String, EObject>> entrySet = UnaryReferencePapyrusCellEditorComposite.this.getfElements().entrySet();
                            for (Map.Entry<String, EObject> entry : entrySet) {
                                if (entry.getValue() != selectedElements[0]) continue;
                                selectedElementLabel = entry.getKey();
                                break;
                            }
                        }
                        UnaryReferencePapyrusCellEditorComposite.this.getCombo().setText(selectedElementLabel);
                        UnaryReferencePapyrusCellEditorComposite.this.commit();
                        super.okPressed();
                        super.close();
                    }
                };
                dialog.setLabelProvider(this.val$labelProvider);
                dialog.setContentProvider((ITreeContentProvider)this.val$provider);
                if (UnaryReferencePapyrusCellEditorComposite.this.source != null) {
                    dialog.setInitialElementSelections(Collections.singletonList(UnaryReferencePapyrusCellEditorComposite.this.source.eGet(UnaryReferencePapyrusCellEditorComposite.this.feature)));
                }
                dialog.setTitle(UnaryReferencePapyrusCellEditorComposite.this.feature.getEType().getName());
                dialog.open();
            }
        });
        final Listener clickListener = new Listener(){

            public void handleEvent(Event event) {
                Control control;
                if (event.widget instanceof Control && (control = (Control)event.widget).getShell() == UnaryReferencePapyrusCellEditorComposite.this.getParentControl().getShell() && event.widget != UnaryReferencePapyrusCellEditorComposite.this.getButton() && event.widget != UnaryReferencePapyrusCellEditorComposite.this.getCombo() && UnaryReferencePapyrusCellEditorComposite.this.isValid()) {
                    UnaryReferencePapyrusCellEditorComposite.this.commit();
                }
            }
        };
        Display.getDefault().addFilter(3, clickListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Display.getDefault().removeFilter(3, clickListener);
            }
        });
        this.combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UnaryReferencePapyrusCellEditorComposite.this.fireChanged();
            }
        });
        this.combo.forceFocus();
    }

    protected boolean isValid() {
        return this.fElements.get(this.combo.getText()) != null;
    }

    private static void addCompletionHandler(Combo comboBox, Collection<String> completions) {
        String[] completionsArray = completions.toArray(new String[completions.size()]);
        SimpleContentProposalProvider contentProposalProvider = new SimpleContentProposalProvider(completionsArray);
        contentProposalProvider.setFiltering(true);
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)comboBox, (IControlContentAdapter)new ComboContentAdapter(), (IContentProposalProvider)contentProposalProvider, null, null);
        adapter.setProposalAcceptanceStyle(2);
    }

    public EObject getValue() {
        return this.fElements.get(this.combo.getText());
    }

    protected void commit() {
        this.fireCommit();
    }

    protected Button getButton() {
        return this.button;
    }

    protected Combo getCombo() {
        return this.combo;
    }

    protected Control getParentControl() {
        return this.parentControl;
    }

    protected Map<String, EObject> getfElements() {
        return this.fElements;
    }

    public void setValue(EObject value) {
    }
}

