/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.textedit.constraintwithessentialocl.xtext;

import com.google.inject.Injector;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.utilities.BaseResource;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.extensionpoints.editors.ui.IPopupEditorHelper;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.xtext.glue.PopupEditorConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.xtext.glue.edit.part.DefaultXtextSemanticValidator;
import org.eclipse.papyrus.infra.gmfdiag.xtext.glue.edit.part.IXTextSemanticValidator;
import org.eclipse.papyrus.infra.gmfdiag.xtext.glue.edit.part.IXtextEMFReconciler;
import org.eclipse.papyrus.infra.gmfdiag.xtext.glue.edit.part.PopupXtextEditorHelper;
import org.eclipse.papyrus.infra.gmfdiag.xtext.glue.partialEditing.SourceViewerHandle;
import org.eclipse.papyrus.uml.textedit.constraintwithessentialocl.xtext.EssentialOCLPartialModelEditor;
import org.eclipse.papyrus.uml.textedit.constraintwithessentialocl.xtext.EssentialOCLPopupPlugin;
import org.eclipse.papyrus.uml.textedit.constraintwithessentialocl.xtext.IXtextEMFReconcilerWithContext;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.xtext.resource.XtextResource;

public class EssentialOCLPopupEditorConfiguration
extends PopupEditorConfiguration {
    protected PopupXtextEditorHelper editorHelper = null;

    public IPopupEditorHelper createPopupEditorHelper(Object editPart) {
        this.editorHelper = null;
        if (!(editPart instanceof IGraphicalEditPart)) {
            return null;
        }
        IGraphicalEditPart graphicalEditPart = (IGraphicalEditPart)editPart;
        EObject element = EMFHelper.getEObject((Object)graphicalEditPart);
        if (!(element instanceof Constraint)) {
            return null;
        }
        Injector xtextInjector = EssentialOCLPopupPlugin.getInstance().getInjector("org.eclipse.ocl.examples.xtext.essentialocl.EssentialOCL");
        Reconciler modelReconciler = new Reconciler();
        String textToEdit = this.getTextToEdit(element);
        String fileExtension = "essentialocl";
        DefaultXtextSemanticValidator semanticValidator = new DefaultXtextSemanticValidator();
        SourceViewerHandle.bindPartialModelEditorClass(EssentialOCLPartialModelEditor.class);
        this.editorHelper = (PopupXtextEditorHelper)super.createPopupEditorHelper(graphicalEditPart, xtextInjector, (IXtextEMFReconciler)modelReconciler, textToEdit, fileExtension, (IXTextSemanticValidator)semanticValidator);
        return this.editorHelper;
    }

    public String getTextToEdit(Object editedObject) {
        Constraint umlConstraint = (Constraint)editedObject;
        String value = "";
        if (umlConstraint.getSpecification() != null) {
            if (umlConstraint.getSpecification() instanceof LiteralString) {
                if (((LiteralString)umlConstraint.getSpecification()).getValue() != null) {
                    value = String.valueOf(value) + ((LiteralString)umlConstraint.getSpecification()).getValue();
                }
            } else if (umlConstraint.getSpecification() instanceof OpaqueExpression) {
                int indexOfOCLBody = -1;
                OpaqueExpression opaqueExpression = (OpaqueExpression)umlConstraint.getSpecification();
                int i = 0;
                while (i < opaqueExpression.getLanguages().size() && indexOfOCLBody == -1) {
                    if (((String)opaqueExpression.getLanguages().get(i)).equals("OCL")) {
                        value = String.valueOf(value) + (String)opaqueExpression.getBodies().get(i);
                        indexOfOCLBody = i;
                    }
                    ++i;
                }
            }
        }
        return value;
    }

    public class Reconciler
    implements IXtextEMFReconcilerWithContext {
        public void configureResource(XtextResource resource, EObject umlObject) {
            if (resource instanceof BaseResource && umlObject instanceof Constraint) {
                Constraint constraint = (Constraint)umlObject;
                if (constraint.getContext() == null) {
                    return;
                }
                try {
                    if (!PivotUtil.setParserContext((BaseResource)((BaseResource)resource), (EObject)umlObject, (Object[])new Object[0])) {
                        Activator.log.error("Unknown context type", (Throwable)new ExecutionException("Unknown context type for " + umlObject));
                    }
                }
                catch (ParserException e) {
                    Activator.log.error("Failed to create context", (Throwable)new ExecutionException("Failed to create context for " + umlObject, (Throwable)e));
                }
            }
        }

        public void reconcile(EObject modelObject, EObject xtextObject) {
            if (!(modelObject instanceof Constraint)) {
                return;
            }
            String newTextualRepresentation = EssentialOCLPopupEditorConfiguration.this.editorHelper.getSourceViewerHandle().getDocument().get();
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)modelObject);
            UpdateConstraintCommand updateCommand = new UpdateConstraintCommand(editingDomain, (Constraint)modelObject, newTextualRepresentation);
            editingDomain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)updateCommand));
        }
    }

    protected class UpdateConstraintCommand
    extends AbstractTransactionalCommand {
        protected final Constraint constraint;
        protected final String newTextualRepresentation;

        public UpdateConstraintCommand(TransactionalEditingDomain editingDomain, Constraint constraint, String newTextualRepresentation) {
            super(editingDomain, "Constraint Update", UpdateConstraintCommand.getWorkspaceFiles((EObject)constraint));
            this.constraint = constraint;
            this.newTextualRepresentation = newTextualRepresentation;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor arg0, IAdaptable arg1) throws ExecutionException {
            OpaqueExpression opaqueExpression = null;
            int indexOfOCLBody = -1;
            if (this.constraint.getSpecification() == null || !(this.constraint.getSpecification() instanceof OpaqueExpression)) {
                opaqueExpression = UMLFactory.eINSTANCE.createOpaqueExpression();
            } else {
                opaqueExpression = (OpaqueExpression)this.constraint.getSpecification();
                int i = 0;
                while (i < opaqueExpression.getLanguages().size() && indexOfOCLBody == -1) {
                    if (((String)opaqueExpression.getLanguages().get(i)).equals("OCL")) {
                        indexOfOCLBody = i;
                    }
                    ++i;
                }
            }
            if (indexOfOCLBody == -1) {
                opaqueExpression.getLanguages().add((Object)"OCL");
                opaqueExpression.getBodies().add((Object)this.newTextualRepresentation);
            } else {
                opaqueExpression.getBodies().remove(indexOfOCLBody);
                opaqueExpression.getBodies().add(indexOfOCLBody, (Object)this.newTextualRepresentation);
            }
            this.constraint.setSpecification((ValueSpecification)opaqueExpression);
            return CommandResult.newOKCommandResult((Object)this.constraint);
        }
    }
}

