/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.textedit.stereotypeproperty.xtext;

import java.util.ArrayList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.infra.widgets.providers.HierarchicToFlatContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IHierarchicContentProvider;
import org.eclipse.papyrus.uml.alf.alf.BOOLEAN_LITERAL;
import org.eclipse.papyrus.uml.alf.alf.INTEGER_LITERAL;
import org.eclipse.papyrus.uml.alf.alf.NameExpression;
import org.eclipse.papyrus.uml.alf.alf.STRING_LITERAL;
import org.eclipse.papyrus.uml.alf.alf.UnqualifiedName;
import org.eclipse.papyrus.uml.profile.structure.AppliedStereotypeProperty;
import org.eclipse.papyrus.uml.tools.providers.UMLContentProvider;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppliedStereotypePropertyEditorUtil {
    private static final String COMA = ",";
    private static final String QUOTE = "\"";
    private static final String VALUE_NULL = "= null";
    private static final String EQUAL = "=";
    private static final String BRAKET_END = "}";
    private static final String HOOK_END = "]";
    private static final String BRACKET_BEGIN = "{";
    private static final String HOOK_BEGIN = "[";

    public static String getLabel(AppliedStereotypeProperty appliedStereotypeProperty) {
        Property property = appliedStereotypeProperty.getStereotypeProperty();
        Stereotype stereotype = appliedStereotypeProperty.getStereotype();
        Element umlElement = appliedStereotypeProperty.getBaseElement();
        String result = StereotypeUtil.displayPropertyValueToEdit((Stereotype)stereotype, (Property)property, (Element)umlElement, (String)"");
        result = result.replace(HOOK_BEGIN, BRACKET_BEGIN);
        if (!(result = result.replace(HOOK_END, BRAKET_END)).contains(EQUAL)) {
            result = String.valueOf(result) + VALUE_NULL;
        }
        if (result.contains(VALUE_NULL)) {
            return result;
        }
        if ("Integer".equals(property.getType().getName())) {
            result = result.replace(QUOTE, "");
        }
        if ("Boolean".equals(property.getType().getName())) {
            result = result.replace(QUOTE, "");
        }
        return result;
    }

    public static String getQualifiedName(NameExpression nameExpression) {
        String nameSpace = "";
        for (UnqualifiedName unqualifiedName : nameExpression.getPath().getNamespace()) {
            nameSpace = String.valueOf(nameSpace) + unqualifiedName.getName() + "::";
        }
        nameSpace = String.valueOf(nameSpace) + nameExpression.getId();
        return nameSpace;
    }

    public static Object[] getPossibleElements(AppliedStereotypeProperty appliedStereotypeProperty) {
        EStructuralFeature foundStructuralFeature = null;
        for (EStructuralFeature eStructuralFeature : appliedStereotypeProperty.getStereotypeApplication().eClass().getEAllStructuralFeatures()) {
            if (!eStructuralFeature.getName().equals(appliedStereotypeProperty.getStereotypeProperty().getName())) continue;
            foundStructuralFeature = eStructuralFeature;
        }
        UMLContentProvider umlContentProvider = new UMLContentProvider(appliedStereotypeProperty.getStereotypeApplication(), foundStructuralFeature, appliedStereotypeProperty.getStereotype());
        HierarchicToFlatContentProvider treeToFlatContentProvider = new HierarchicToFlatContentProvider((IHierarchicContentProvider)umlContentProvider);
        return treeToFlatContentProvider.getElements();
    }

    public static EObject getApplicationStereotypeFor(NameExpression nameExpression, Object[] result) {
        String qn = AppliedStereotypePropertyEditorUtil.getQualifiedName(nameExpression);
        EObject foundStereotypeApplication = null;
        int i = 0;
        while (i < result.length) {
            if (result[i] instanceof EObject && UMLUtil.getBaseElement((EObject)((EObject)result[i])) != null && ((NamedElement)UMLUtil.getBaseElement((EObject)((EObject)result[i]))).getQualifiedName().equals(qn)) {
                foundStereotypeApplication = (EObject)result[i];
            }
            ++i;
        }
        return foundStereotypeApplication;
    }

    public static EObject getNamedElementFor(NameExpression nameExpression, Object[] result) {
        String qn = AppliedStereotypePropertyEditorUtil.getQualifiedName(nameExpression);
        NamedElement foundStereotypeApplication = null;
        int i = 0;
        while (i < result.length) {
            if (result[i] instanceof NamedElement && ((NamedElement)result[i]).getQualifiedName().equals(qn)) {
                foundStereotypeApplication = (NamedElement)result[i];
            }
            ++i;
        }
        return foundStereotypeApplication;
    }

    public static ArrayList<INTEGER_LITERAL> get_INTEGER(EObject xtextObject) {
        ArrayList<INTEGER_LITERAL> result = new ArrayList<INTEGER_LITERAL>();
        TreeIterator iterator = xtextObject.eAllContents();
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            if (!(eObject instanceof INTEGER_LITERAL)) continue;
            result.add((INTEGER_LITERAL)eObject);
        }
        return result;
    }

    public static ArrayList<BOOLEAN_LITERAL> get_BOOLEAN(EObject xtextObject) {
        ArrayList<BOOLEAN_LITERAL> result = new ArrayList<BOOLEAN_LITERAL>();
        TreeIterator iterator = xtextObject.eAllContents();
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            if (!(eObject instanceof BOOLEAN_LITERAL)) continue;
            result.add((BOOLEAN_LITERAL)eObject);
        }
        return result;
    }

    public static ArrayList<STRING_LITERAL> get_STRING(EObject xtextObject) {
        ArrayList<STRING_LITERAL> result = new ArrayList<STRING_LITERAL>();
        TreeIterator iterator = xtextObject.eAllContents();
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            if (!(eObject instanceof STRING_LITERAL)) continue;
            result.add((STRING_LITERAL)eObject);
        }
        return result;
    }
}

