/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.databinding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.tools.databinding.AggregatedObservable;
import org.eclipse.papyrus.uml.tools.databinding.AggregatedPapyrusObservableValue;
import org.eclipse.papyrus.uml.tools.databinding.CommandBasedObservableValue;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;

public class NavigationObservableValue
extends AbstractObservableValue
implements IChangeListener,
CommandBasedObservableValue,
AggregatedObservable {
    private Property memberEnd;
    private EditingDomain domain;
    private final IObservableList ownerObservableList;
    private boolean currentValue;

    public NavigationObservableValue(EObject source, EditingDomain domain) {
        this.memberEnd = (Property)source;
        this.domain = domain;
        this.ownerObservableList = EMFProperties.list((EStructuralFeature)UMLPackage.eINSTANCE.getAssociation_OwnedEnd()).observe((Object)this.memberEnd.getAssociation());
        this.ownerObservableList.addChangeListener((IChangeListener)this);
    }

    public void handleChange(ChangeEvent event) {
        this.fireValueChange(Diffs.createValueDiff((Object)this.currentValue, (Object)this.doGetValue()));
    }

    public Object getValueType() {
        return Boolean.class;
    }

    protected Boolean doGetValue() {
        return this.memberEnd.isNavigable();
    }

    protected void doSetValue(Object value) {
        Command command = this.getCommand(value);
        this.domain.getCommandStack().execute(command);
    }

    public synchronized void dispose() {
        super.dispose();
        this.ownerObservableList.removeChangeListener((IChangeListener)this);
        this.ownerObservableList.dispose();
    }

    public Command getCommand(Object value) {
        if (value instanceof Boolean) {
            boolean isNavigable = (Boolean)value;
            if (this.memberEnd.isNavigable() == isNavigable) {
                return UnexecutableCommand.INSTANCE;
            }
            Association association = this.memberEnd.getAssociation();
            ArrayList<Property> navigableEnds = new ArrayList<Property>();
            navigableEnds.addAll((Collection<Property>)association.getNavigableOwnedEnds());
            LinkedList<SetRequest> setRequests = new LinkedList<SetRequest>();
            if (isNavigable) {
                navigableEnds.add(this.memberEnd);
            } else {
                if (this.memberEnd.getOwningAssociation() == null && this.memberEnd.getOwner() instanceof Classifier) {
                    LinkedList<Property> ownedEnds = new LinkedList<Property>();
                    ownedEnds.addAll((Collection<Property>)association.getOwnedEnds());
                    ownedEnds.add(this.memberEnd);
                    setRequests.add(new SetRequest((EObject)association, (EStructuralFeature)UMLPackage.eINSTANCE.getAssociation_OwnedEnd(), ownedEnds));
                }
                if (navigableEnds.contains(this.memberEnd)) {
                    navigableEnds.remove(this.memberEnd);
                }
            }
            EReference navigableFeature = UMLPackage.eINSTANCE.getAssociation_NavigableOwnedEnd();
            setRequests.add(new SetRequest((EObject)association, (EStructuralFeature)navigableFeature, navigableEnds));
            CompoundCommand command = null;
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)association);
            if (provider != null) {
                command = new CompoundCommand();
                for (SetRequest request : setRequests) {
                    ICommand createGMFCommand = provider.getEditCommand((IEditCommandRequest)request);
                    command.append((Command)new GMFtoEMFCommandWrapper(createGMFCommand));
                }
            }
            this.currentValue = isNavigable;
            return command;
        }
        return UnexecutableCommand.INSTANCE;
    }

    public AggregatedObservable aggregate(IObservable observable) {
        try {
            return new AggregatedPapyrusObservableValue(this.domain, this, observable);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public boolean hasDifferentValues() {
        return false;
    }
}

