/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.xtext.integration;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.uml.extensionpoints.profile.RegisteredProfile;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;

public class InvalidStringUtil {
    public static String ACTION_LANGUAGE_PROFILE_NAME = "ActionLanguage";
    protected static Profile actionLanguageProfile;
    protected static Stereotype textualRepresentationStereotype;

    public static String getTextualRepresentation(Element element) {
        Comment textualRepresentationComment = InvalidStringUtil.getTextualRepresentationComment(element);
        if (textualRepresentationComment == null) {
            return null;
        }
        return textualRepresentationComment.getBody();
    }

    public static Comment getTextualRepresentationComment(Element element) {
        Comment textualRepresentationComment = null;
        for (Comment comment : element.getOwnedComments()) {
            if (comment.getBody() == null || !InvalidStringUtil.isATextualRepresentationComment(comment)) continue;
            textualRepresentationComment = comment;
        }
        return textualRepresentationComment;
    }

    public static boolean isATextualRepresentationComment(Comment comment) {
        if (textualRepresentationStereotype != null) {
            return comment.getAppliedStereotypes().contains((Object)textualRepresentationStereotype);
        }
        EList applicableStereotypes = comment.getApplicableStereotypes();
        int i = 0;
        while (i < applicableStereotypes.size() && textualRepresentationStereotype == null) {
            if (((Stereotype)applicableStereotypes.get(i)).getName().equals("TextualRepresentation")) {
                textualRepresentationStereotype = (Stereotype)applicableStereotypes.get(i);
            }
            ++i;
        }
        return textualRepresentationStereotype != null;
    }

    public static boolean isActionLanguageProfileApplied(Element element) {
        if (actionLanguageProfile == null) {
            RegisteredProfile registeredActionLanguageProfile = RegisteredProfile.getRegisteredProfile((String)ACTION_LANGUAGE_PROFILE_NAME);
            URI modelUri = registeredActionLanguageProfile.uri;
            Model root = element.getModel();
            Resource modelResource = root.eResource().getResourceSet().getResource(modelUri, true);
            if (modelResource.getContents().get(0) instanceof Profile) {
                actionLanguageProfile = (Profile)modelResource.getContents().get(0);
            }
        }
        EList appliedProfiles = element.getModel().getAppliedProfiles();
        return appliedProfiles.contains(actionLanguageProfile);
    }

    public static Comment createTextualRepresentationComment(Element element, String languageId) {
        Comment textualRepresentationComment = element.createOwnedComment();
        if (!InvalidStringUtil.isActionLanguageProfileApplied(element)) {
            PackageUtil.applyProfile((Package)element.getModel(), (Profile)actionLanguageProfile, (boolean)true);
        }
        InvalidStringUtil.clean();
        InvalidStringUtil.isATextualRepresentationComment(textualRepresentationComment);
        textualRepresentationComment.applyStereotype(textualRepresentationStereotype);
        textualRepresentationComment.setValue(textualRepresentationStereotype, "language", (Object)languageId);
        return textualRepresentationComment;
    }

    public static void clean() {
        actionLanguageProfile = null;
        textualRepresentationStereotype = null;
    }
}

