/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.dialog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;
import org.eclipse.emf.facet.infra.browser.custom.core.CustomizationsCatalog;
import org.eclipse.emf.facet.infra.browser.uicore.internal.util.ImageProvider;
import org.eclipse.emf.facet.infra.common.core.internal.utils.ModelUtils;
import org.eclipse.emf.facet.infra.facet.FacetSet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.infra.tools.util.ListHelper;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.editors.MultipleValueSelectorDialog;
import org.eclipse.papyrus.infra.widgets.providers.FilteredContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.StaticContentProvider;
import org.eclipse.papyrus.infra.widgets.selectors.ReferenceSelector;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapyrusLoadBrowserCustomizationDialog
extends MultipleValueSelectorDialog {
    protected final Collection<EPackage> ePackages;
    public static final int RESTORE_ID = 1025;

    public PapyrusLoadBrowserCustomizationDialog(Shell parentShell, List<MetamodelView> initialSelection, Collection<EPackage> ePackages) {
        this(parentShell, PapyrusLoadBrowserCustomizationDialog.getElementSelector(ePackages), initialSelection, ePackages);
    }

    protected PapyrusLoadBrowserCustomizationDialog(Shell parentShell, IElementSelector selector, List<MetamodelView> initialSelection, Collection<EPackage> ePackages) {
        super(parentShell, selector);
        this.ePackages = ePackages;
        this.setInitialElementSelections(initialSelection);
        this.setOrdered(true);
        this.setLabelProvider(PapyrusLoadBrowserCustomizationDialog.createLabelProvider());
        this.setTitle("Select browser customizations");
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setImage(ImageProvider.getInstance().getUiCustomIcon());
    }

    protected static IElementSelector getElementSelector(final Collection<EPackage> ePackages) {
        ReferenceSelector selector = new ReferenceSelector(true){

            public void createControls(Composite parent) {
                super.createControls(parent);
                PapyrusLoadBrowserCustomizationDialog.installCompatibleCustomizationViewerFilter((StructuredViewer)this.treeViewer, ePackages);
            }
        };
        List registryAllCustomizations = CustomizationsCatalog.getInstance().getRegistryCustomizations();
        StaticContentProvider semanticProvider = new StaticContentProvider(registryAllCustomizations.toArray());
        FilteredContentProvider filteredProvider = new FilteredContentProvider((IStructuredContentProvider)semanticProvider);
        selector.setContentProvider((IStaticContentProvider)filteredProvider);
        selector.setLabelProvider(PapyrusLoadBrowserCustomizationDialog.createLabelProvider());
        return selector;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, "Restore defaults", false);
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            this.restorePressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    public void create() {
        super.create();
        PapyrusLoadBrowserCustomizationDialog.installCompatibleCustomizationViewerFilter(this.selectedElementsViewer, this.ePackages);
        this.getShell().pack();
    }

    protected static void installCompatibleCustomizationViewerFilter(StructuredViewer viewer, Collection<EPackage> ePackages) {
        List currentFilters = ListHelper.asList((Object[])viewer.getFilters());
        currentFilters.add(PapyrusLoadBrowserCustomizationDialog.createCompatibleCustomizationViewerFilter(ePackages));
        viewer.setFilters(currentFilters.toArray(new ViewerFilter[currentFilters.size()]));
    }

    protected static ViewerFilter createCompatibleCustomizationViewerFilter(Collection<EPackage> ePackages) {
        final HashSet<String> ePackageURIs = new HashSet<String>();
        for (EPackage ePackage : ePackages) {
            ePackageURIs.add(ePackage.getNsURI());
            Set referencedPackages = ModelUtils.computeReferencedPackages((EPackage)ePackage);
            for (EPackage referencedEPackage : referencedPackages) {
                ePackageURIs.add(referencedEPackage.getNsURI());
            }
        }
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof MetamodelView) {
                    MetamodelView customization = (MetamodelView)element;
                    String nsURI = customization.getMetamodelURI();
                    if (ePackageURIs.contains(nsURI)) {
                        return true;
                    }
                    EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(nsURI);
                    while (ePackage != null) {
                        if (ePackageURIs.contains(ePackage.getNsURI())) {
                            return true;
                        }
                        if (ePackage instanceof FacetSet) {
                            FacetSet facetSet = (FacetSet)ePackage;
                            ePackage = facetSet.getExtendedPackage();
                            continue;
                        }
                        ePackage = ePackage.getESuperPackage();
                    }
                    return false;
                }
                return true;
            }
        };
    }

    protected void restorePressed() {
        List defaultCustomizations = CustomizationsCatalog.getInstance().getRegistryDefaultCustomizations();
        Object[] filteredCustomizations = defaultCustomizations.toArray();
        this.removeAllAction();
        this.addElements(filteredCustomizations);
        this.selector.setSelectedElements(this.allElements.toArray());
    }

    public List<MetamodelView> getSelectedCustomizations() {
        Object[] result = super.getResult();
        ArrayList<MetamodelView> customizations = new ArrayList<MetamodelView>();
        Object[] objectArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof MetamodelView) {
                customizations.add((MetamodelView)element);
            }
            ++n2;
        }
        return customizations;
    }

    protected static ILabelProvider createLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                MetamodelView metamodelView = (MetamodelView)element;
                return metamodelView.getName();
            }

            public Image getImage(Object element) {
                return ImageProvider.getInstance().getUiCustomIcon();
            }
        };
    }
}

