/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.creation;

import java.util.Collection;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.views.properties.contexts.View;
import org.eclipse.papyrus.views.properties.creation.EditionDialog;
import org.eclipse.papyrus.views.properties.messages.Messages;
import org.eclipse.papyrus.views.properties.runtime.ConfigurationManager;
import org.eclipse.papyrus.views.properties.runtime.ViewConstraintEngine;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyEditorFactory
implements ReferenceValueFactory {
    public Object createObject(Control widget) {
        return null;
    }

    protected Object createObject(Control widget, Object source) {
        if (source == null) {
            return null;
        }
        StructuredSelection selection = new StructuredSelection(source);
        ViewConstraintEngine constraintEngine = ConfigurationManager.getInstance().getConstraintEngine();
        Set<View> views = constraintEngine.getViews((ISelection)selection);
        if (!views.isEmpty()) {
            EditionDialog dialog = new EditionDialog(widget.getShell(), true);
            dialog.setViews(views);
            dialog.setInput(source);
            dialog.setTitle(this.getCreationDialogTitle());
            int result = dialog.open();
            if (result != 0) {
                return null;
            }
        }
        return source;
    }

    public Collection<Object> validateObjects(Collection<Object> objectsToValidate) {
        return objectsToValidate;
    }

    public boolean canEdit() {
        return true;
    }

    public Object edit(Control widget, Object source) {
        StructuredSelection selection = new StructuredSelection(source);
        ViewConstraintEngine constraintEngine = ConfigurationManager.getInstance().getConstraintEngine();
        Set<View> views = constraintEngine.getViews((ISelection)selection);
        if (!views.isEmpty()) {
            EditionDialog dialog = new EditionDialog(widget.getShell());
            dialog.setTitle(this.getEditionDialogTitle(source));
            dialog.setViews(views);
            dialog.setInput(source);
            dialog.open();
        }
        return source;
    }

    public boolean canCreateObject() {
        return false;
    }

    public String getCreationDialogTitle() {
        return Messages.PropertyEditorFactory_CreateANewElement;
    }

    public String getEditionDialogTitle(Object objectToEdit) {
        return "Edit an element";
    }
}

