/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.runtime;

import java.net.URL;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.views.properties.Activator;
import org.eclipse.papyrus.views.properties.catalog.PropertiesURIHandler;
import org.eclipse.papyrus.views.properties.contexts.Context;
import org.eclipse.papyrus.views.properties.contexts.Section;
import org.eclipse.papyrus.views.properties.contexts.Tab;
import org.eclipse.papyrus.views.properties.contexts.View;
import org.eclipse.papyrus.views.properties.modelelement.DataSource;
import org.eclipse.papyrus.views.properties.runtime.ConfigurationManager;
import org.eclipse.papyrus.views.properties.runtime.DisplayEngine;
import org.eclipse.papyrus.views.properties.util.EMFURLStreamHandler;
import org.eclipse.papyrus.views.properties.xwt.XWTTabDescriptor;
import org.eclipse.papyrus.xwt.DefaultLoadingContext;
import org.eclipse.papyrus.xwt.ILoadingContext;
import org.eclipse.papyrus.xwt.XWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDisplayEngine
implements DisplayEngine {
    private ILoadingContext loadingContext = new DefaultLoadingContext(this.getClass().getClassLoader());
    private Set<String> displayedSections = new HashSet<String>();
    private Set<Control> controls = new HashSet<Control>();
    private boolean allowDuplicate;

    public DefaultDisplayEngine() {
        this(false);
    }

    public DefaultDisplayEngine(boolean allowDuplicate) {
        this.allowDuplicate = allowDuplicate;
    }

    @Override
    public List<ITabDescriptor> getTabDescriptors(Set<View> views) {
        LinkedHashMap<String, XWTTabDescriptor> result = new LinkedHashMap<String, XWTTabDescriptor>();
        HashSet<String> selectedSections = new HashSet<String>();
        for (View view : views) {
            for (Section section : view.getSections()) {
                XWTTabDescriptor descriptor;
                if (selectedSections.contains(section.getName())) continue;
                Tab tab = section.getTab();
                if (tab == null) {
                    Activator.log.warn("Null tab for " + section);
                    continue;
                }
                if (result.containsKey(tab.getId())) {
                    descriptor = (XWTTabDescriptor)((Object)result.get(tab.getId()));
                } else {
                    descriptor = new XWTTabDescriptor(tab);
                    result.put(tab.getId(), descriptor);
                }
                descriptor.addSection(section, view, this);
                selectedSections.add(section.getName());
            }
        }
        this.disposeControls();
        return new LinkedList<ITabDescriptor>(result.values());
    }

    protected void disposeControls() {
        for (Control control : this.controls) {
            control.dispose();
        }
        this.displayedSections.clear();
        this.controls.clear();
    }

    @Override
    public void dispose() {
        this.disposeControls();
    }

    @Override
    public Control createSection(Composite parent, Section section, DataSource source) {
        if (source == null) {
            return null;
        }
        if (!this.allowDuplicate && this.displayedSections.contains(section.getName())) {
            return null;
        }
        Control control = this.createSection(parent, section, this.loadXWTFile(section), source);
        this.displayedSections.add(section.getName());
        if (control != null) {
            this.controls.add(control);
        }
        return control;
    }

    @Override
    public void refreshSection(Composite parent, Section section, DataSource source) {
        Control control;
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        control = this.createSection(parent, section, this.loadXWTFile(section), source);
        this.displayedSections.add(section.getName());
        if (control != null) {
            this.controls.add(control);
        }
    }

    @Override
    public Control createSection(Composite parent, Section section, URI sectionFile, DataSource source) {
        if (sectionFile == null && (sectionFile = this.loadXWTFile(section)) == null) {
            return null;
        }
        ILoadingContext xwtContext = XWT.getLoadingContext();
        XWT.setLoadingContext((ILoadingContext)this.loadingContext);
        Control control = null;
        try {
            ResourceSet rset = section.eResource().getResourceSet();
            URL url = new URL(null, sectionFile.toString(), new EMFURLStreamHandler(rset.getURIConverter()));
            control = (Control)XWT.load((Object)parent, (URL)url, (Object)source);
            if (control != null) {
                control.setLayoutData((Object)new GridData(4, 4, true, true));
                this.controls.add(control);
            }
        }
        catch (Exception ex) {
            Activator.log.error("Error while loading " + section.getSectionFile(), (Throwable)ex);
            this.disposeControls();
            Label label = new Label(parent, 0);
            label.setText("An error occured in the property view. The file " + section.getSectionFile() + " could not be loaded");
        }
        this.layout(parent);
        XWT.setLoadingContext((ILoadingContext)xwtContext);
        return control;
    }

    private URI loadXWTFile(Section section) {
        EObject tab = section.eContainer();
        Context context = (Context)tab.eContainer();
        if (context.eResource() == null) {
            context = ConfigurationManager.getInstance().getContext(context.getName());
            Activator.log.warn("No resource for Context : " + context + " ; refreshing the model");
        }
        URI sectionURI = URI.createURI((String)section.getSectionFile());
        URI baseURI = context.eResource().getURI();
        if ("ppe".equals(baseURI.scheme())) {
            PropertiesURIHandler handler = new PropertiesURIHandler();
            baseURI = handler.getConvertedURI(baseURI);
        }
        sectionURI = sectionURI.resolve(baseURI);
        return sectionURI;
    }

    private void layout(Composite parent) {
        parent.getParent().getParent().layout();
        parent.getParent().layout();
        parent.layout();
    }

    @Override
    public void removeSection(Composite parent) {
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        this.layout(parent);
    }
}

