/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.widgets;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.papyrus.infra.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.infra.widgets.editors.AbstractListEditor;
import org.eclipse.papyrus.infra.widgets.editors.AbstractValueEditor;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.papyrus.views.properties.Activator;
import org.eclipse.papyrus.views.properties.contexts.Context;
import org.eclipse.papyrus.views.properties.contexts.Property;
import org.eclipse.papyrus.views.properties.modelelement.DataSource;
import org.eclipse.papyrus.views.properties.runtime.ConfigurationManager;
import org.eclipse.papyrus.views.properties.util.PropertiesUtil;
import org.eclipse.papyrus.views.properties.widgets.CustomizablePropertyEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractPropertyEditor
implements IChangeListener,
CustomizablePropertyEditor {
    protected String propertyPath;
    protected DataSource input;
    protected boolean readOnly = false;
    protected boolean isEditable = true;
    protected AbstractListEditor listEditor;
    protected AbstractValueEditor valueEditor;
    protected IObservableList observableList;
    protected IObservableValue observableValue;
    protected boolean showLabel = true;
    protected String customLabel;
    public static int descriptionMaxCharPerLine = 200;

    protected AbstractPropertyEditor() {
    }

    protected AbstractPropertyEditor(AbstractListEditor editor) {
        this.setEditor(editor);
    }

    protected AbstractPropertyEditor(AbstractValueEditor editor) {
        this.setEditor(editor);
    }

    protected void setEditor(AbstractListEditor editor) {
        this.listEditor = editor;
        this.addDisposeListener((AbstractEditor)editor);
    }

    protected void setEditor(AbstractValueEditor editor) {
        this.valueEditor = editor;
        this.addDisposeListener((AbstractEditor)editor);
    }

    private void addDisposeListener(AbstractEditor editor) {
        editor.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (AbstractPropertyEditor.this.input != null) {
                    AbstractPropertyEditor.this.input.removeChangeListener(AbstractPropertyEditor.this);
                }
            }
        });
    }

    protected void checkInput() {
        if (this.propertyPath != null && this.input != null) {
            this.isEditable = this.input.isEditable(this.propertyPath);
            try {
                this.doBinding();
            }
            catch (Exception ex) {
                Activator.log.error((Throwable)ex);
            }
            if (this.getInputObservable() instanceof ICommitListener && this.getEditor() != null) {
                this.getEditor().addCommitListener((ICommitListener)this.getInputObservable());
            }
            this.updateLabel();
            this.updateDescription();
        }
    }

    protected void doBinding() {
        IObservableValue inputObservableValue;
        if (this.listEditor != null) {
            IObservableList inputObservableList = this.getInputObservableList();
            if (inputObservableList != null) {
                this.listEditor.setModelObservable(inputObservableList);
            }
        } else if (this.valueEditor != null && (inputObservableValue = this.getInputObservableValue()) != null) {
            this.valueEditor.setModelObservable(inputObservableValue);
        }
        boolean isReadOnly = this.getReadOnly();
        this.applyReadOnly(isReadOnly);
        if (this.input.forceRefresh(this.propertyPath)) {
            this.input.addChangeListener(this);
        }
    }

    protected void applyReadOnly(boolean readOnly) {
        AbstractEditor editor = this.getEditor();
        if (editor != null) {
            editor.setReadOnly(readOnly);
        }
    }

    public final void handleChange(ChangeEvent event) {
        AbstractEditor editor = this.getEditor();
        if (editor != null) {
            editor.refreshValue();
        }
    }

    public void setProperty(String path) {
        this.propertyPath = path;
        this.checkInput();
        this.updateLabel();
        this.updateDescription();
    }

    public void updateLabel() {
        String label = this.getLabel();
        this.updateLabel(label);
    }

    public void updateLabel(String label) {
        if (this.showLabel) {
            if (this.valueEditor != null) {
                this.valueEditor.setLabel(label);
            } else if (this.listEditor != null) {
                this.listEditor.setLabel(label);
            }
        }
    }

    public String getProperty() {
        return this.propertyPath;
    }

    public void setInput(DataSource input) {
        this.input = input;
        this.checkInput();
    }

    public DataSource getInput() {
        return this.input;
    }

    protected String getLabel() {
        if (this.customLabel != null) {
            return this.customLabel;
        }
        Property property = this.getModelProperty();
        if (property == null || property.getLabel() == null || property.getLabel().trim().equals("")) {
            return PropertiesUtil.getLabel(this.getLocalPropertyPath());
        }
        return property.getLabel();
    }

    protected void updateDescription() {
        String description = "";
        Property property = this.getModelProperty();
        if (property != null) {
            description = property.getDescription();
        }
        if (description == null || description.trim().equals("")) {
            description = this.getLocalPropertyPath();
        } else {
            description = PropertiesUtil.resizeString(description, descriptionMaxCharPerLine);
            description = String.valueOf(this.getLocalPropertyPath()) + ": " + description;
        }
        this.updateDescription(description);
    }

    protected void updateDescription(String description) {
        if (this.valueEditor != null) {
            this.valueEditor.setToolTipText(description);
        } else if (this.listEditor != null) {
            this.listEditor.setToolTipText(description);
        }
    }

    protected Property getModelProperty() {
        if (this.propertyPath == null) {
            return null;
        }
        Context context = this.getContext();
        return ConfigurationManager.getInstance().getProperty(this.propertyPath, context);
    }

    private Context getContext() {
        if (this.input == null) {
            return null;
        }
        return this.input.getView().getContext();
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        if (this.getEditor() != null) {
            this.getEditor().setReadOnly(this.getReadOnly());
        }
    }

    public AbstractEditor getEditor() {
        return this.valueEditor == null ? this.listEditor : this.valueEditor;
    }

    public boolean getReadOnly() {
        boolean result = this.readOnly || !this.isEditable || this.getInputObservable() == null;
        return result;
    }

    protected IObservableList getInputObservableList() {
        if (this.observableList == null) {
            try {
                this.observableList = (IObservableList)this.input.getObservable(this.propertyPath);
            }
            catch (Exception ex) {
                Activator.log.error("Cannot find a valid IObservableList for " + this.propertyPath, (Throwable)ex);
            }
        }
        return this.observableList;
    }

    protected IObservableValue getInputObservableValue() {
        if (this.observableValue == null) {
            try {
                this.observableValue = (IObservableValue)this.input.getObservable(this.propertyPath);
            }
            catch (Exception ex) {
                Activator.log.error("Cannot find a valid IObservableValue for " + this.propertyPath, (Throwable)ex);
            }
        }
        return this.observableValue;
    }

    protected IObservable getInputObservable() {
        if (this.input == null || this.propertyPath == null) {
            return null;
        }
        if (this.listEditor != null) {
            return this.getInputObservableList();
        }
        if (this.valueEditor != null) {
            return this.getInputObservableValue();
        }
        return null;
    }

    protected String getLocalPropertyPath() {
        return this.propertyPath.substring(this.propertyPath.lastIndexOf(":") + 1);
    }

    public void setLayoutData(Object data) {
        if (this.getEditor() != null) {
            this.getEditor().setLayoutData(data);
        }
    }

    public Object getLayoutData() {
        return this.getEditor() == null ? null : this.getEditor().getLayoutData();
    }

    public void setShowLabel(boolean showLabel) {
        AbstractEditor editor = this.getEditor();
        this.showLabel = showLabel;
        if (editor != null) {
            editor.setDisplayLabel(showLabel);
        }
    }

    public boolean getShowLabel() {
        return this.showLabel;
    }

    public void setCustomLabel(String customLabel) {
        this.customLabel = customLabel;
        this.updateLabel();
    }

    public String getCustomLabel() {
        return this.customLabel;
    }

    public Control getControl() {
        if (this.valueEditor == null) {
            return this.listEditor;
        }
        return this.valueEditor;
    }
}

