/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.xwt;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.papyrus.views.properties.Activator;
import org.eclipse.papyrus.views.properties.contexts.View;
import org.eclipse.papyrus.views.properties.runtime.ConfigurationManager;
import org.eclipse.papyrus.views.properties.runtime.DefaultDisplayEngine;
import org.eclipse.papyrus.views.properties.runtime.DisplayEngine;
import org.eclipse.papyrus.views.properties.runtime.ViewConstraintEngine;
import org.eclipse.papyrus.views.properties.xwt.XWTTabDescriptor;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyRegistry;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyRegistryFactory;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptorProvider;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWTTabDescriptorProvider
implements ITabDescriptorProvider {
    private ITabDescriptor[] cachedResult;
    private ISelection previousSelection;
    private IWorkbenchPart previousPart;
    private final Map<IWorkbenchPart, DisplayEngine> displays = new HashMap<IWorkbenchPart, DisplayEngine>();

    private DisplayEngine getDisplay(IWorkbenchPart part) {
        if (!this.displays.containsKey(part)) {
            this.displays.put(part, new DefaultDisplayEngine());
            part.getSite().getPage().addPartListener(new IPartListener(){

                public void partClosed(IWorkbenchPart part) {
                    part.getSite().getPage().removePartListener((IPartListener)this);
                    DisplayEngine display = (DisplayEngine)XWTTabDescriptorProvider.this.displays.get(part);
                    if (display != null) {
                        display.dispose();
                        XWTTabDescriptorProvider.this.displays.remove(part);
                    }
                    XWTTabDescriptorProvider.this.previousPart = null;
                    XWTTabDescriptorProvider.this.previousSelection = null;
                }

                public void partActivated(IWorkbenchPart part) {
                }

                public void partBroughtToTop(IWorkbenchPart part) {
                }

                public void partDeactivated(IWorkbenchPart part) {
                }

                public void partOpened(IWorkbenchPart part) {
                }
            });
        }
        return this.displays.get(part);
    }

    public ITabDescriptor[] getTabDescriptors(IWorkbenchPart part, ISelection selection) {
        if (selection != this.previousSelection || part != this.previousPart) {
            ITabbedPropertySheetPageContributor contributor;
            this.previousSelection = selection;
            this.previousPart = part;
            ViewConstraintEngine constraintEngine = ConfigurationManager.getInstance().getConstraintEngine();
            LinkedList<ITabDescriptor> descriptors = new LinkedList<ITabDescriptor>();
            Set<View> views = constraintEngine.getViews(selection);
            if (!views.isEmpty()) {
                descriptors.addAll(this.getDisplay(part).getTabDescriptors(views));
            }
            if ((contributor = part instanceof ITabbedPropertySheetPageContributor ? (ITabbedPropertySheetPageContributor)part : (ITabbedPropertySheetPageContributor)part.getAdapter(ITabbedPropertySheetPageContributor.class)) != null) {
                TabbedPropertyRegistry registry = TabbedPropertyRegistryFactory.getInstance().createRegistry(contributor);
                try {
                    Method method = TabbedPropertyRegistry.class.getDeclaredMethod("getAllTabDescriptors", new Class[0]);
                    method.setAccessible(true);
                    ITabDescriptor[] registeredTabDesriptors = (ITabDescriptor[])method.invoke((Object)registry, new Object[0]);
                    if (registeredTabDesriptors != null) {
                        ITabDescriptor[] iTabDescriptorArray = registeredTabDesriptors;
                        int n = registeredTabDesriptors.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ITabDescriptor descriptor = iTabDescriptorArray[n2];
                            if (descriptor.getSectionDescriptors().size() > 0) {
                                descriptors.add(descriptor);
                            }
                            ++n2;
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    Activator.log.error((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    Activator.log.error((Throwable)e);
                }
                catch (InvocationTargetException e) {
                    Activator.log.error((Throwable)e);
                }
                catch (SecurityException e) {
                    Activator.log.error((Throwable)e);
                }
                catch (NoSuchMethodException e) {
                    Activator.log.error((Throwable)e);
                }
            }
            this.orderTabDescriptors(descriptors);
            this.cachedResult = descriptors.toArray(new ITabDescriptor[descriptors.size()]);
            TabbedPropertyRegistryFactory.getInstance().disposeRegistry((ITabbedPropertySheetPageContributor)part);
        }
        return this.cachedResult;
    }

    protected void orderTabDescriptors(final List<ITabDescriptor> descriptors) {
        Collections.sort(descriptors, new Comparator<ITabDescriptor>(){

            @Override
            public int compare(ITabDescriptor tabDescriptor1, ITabDescriptor tabDescriptor2) {
                int priority2;
                int priority1 = this.getPriority(tabDescriptor1);
                if (priority1 < (priority2 = this.getPriority(tabDescriptor2))) {
                    return -1;
                }
                if (priority1 > priority2) {
                    return 1;
                }
                priority1 = this.getXWTTabPriority(tabDescriptor1);
                if (priority1 < (priority2 = this.getXWTTabPriority(tabDescriptor2))) {
                    return -1;
                }
                if (priority1 > priority2) {
                    return 1;
                }
                String label1 = tabDescriptor1.getLabel();
                String label2 = tabDescriptor2.getLabel();
                return Collator.getInstance().compare(label1, label2);
            }

            private ITabDescriptor getPreviousTab(ITabDescriptor tab) {
                String afterId = tab.getAfterTab();
                if (!"top".equals(afterId)) {
                    for (ITabDescriptor descriptor : descriptors) {
                        String id = descriptor.getId();
                        if (id == null || !id.equals(afterId)) continue;
                        return descriptor;
                    }
                }
                return null;
            }

            private int getPriority(ITabDescriptor tab) {
                ITabDescriptor previousTab = this.getPreviousTab(tab);
                if (previousTab != null) {
                    return this.getPriority(previousTab) + 1;
                }
                return this.getXWTTabPriority(tab);
            }

            private int getXWTTabPriority(ITabDescriptor tab) {
                if (tab instanceof XWTTabDescriptor) {
                    XWTTabDescriptor xwtTab = (XWTTabDescriptor)tab;
                    return xwtTab.getPriority();
                }
                return 100;
            }
        });
    }
}

