/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.search.scope;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.resource.ModelMultiException;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.resource.sasheditor.SashModel;
import org.eclipse.papyrus.infra.emf.utils.BusinessModelResolver;
import org.eclipse.papyrus.infra.onefile.model.IPapyrusFile;
import org.eclipse.papyrus.views.search.Activator;
import org.eclipse.papyrus.views.search.Messages;
import org.eclipse.papyrus.views.search.scope.IScopeCollector;
import org.eclipse.papyrus.views.search.scope.ResourceVisitor;
import org.eclipse.papyrus.views.search.utils.ModelUtils;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.ui.IWorkingSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeCollector
implements IScopeCollector {
    private static ScopeCollector instance = null;

    private ScopeCollector() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final ScopeCollector getInstance() {
        if (instance != null) return instance;
        Class<ScopeCollector> clazz = ScopeCollector.class;
        synchronized (ScopeCollector.class) {
            if (instance != null) return instance;
            instance = new ScopeCollector();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public Collection<IResource> computeSearchScope(ISearchPageContainer container) {
        HashSet<IResource> results = new HashSet<IResource>();
        if (container == null) {
            results.addAll(this.createWorkspaceScope());
        } else {
            switch (container.getSelectedScope()) {
                case 0: {
                    results.addAll(this.createWorkspaceScope());
                    break;
                }
                case 1: {
                    ISelection selection = container.getSelection();
                    if (!selection.isEmpty()) {
                        if (selection instanceof IStructuredSelection) {
                            results.addAll(this.createSelectionScope((IStructuredSelection)selection));
                            break;
                        }
                        results.addAll(this.createWorkspaceScope());
                        break;
                    }
                    results.addAll(this.createWorkspaceScope());
                    break;
                }
                case 3: {
                    String[] projects = container.getSelectedProjectNames();
                    results.addAll(this.createProjectsScope(projects));
                    break;
                }
                case 2: {
                    IWorkingSet[] workingSets = container.getSelectedWorkingSets();
                    results.addAll(this.createWorkingSetsScope(workingSets));
                    break;
                }
            }
        }
        return results;
    }

    protected List<IResource> createSelectionScope(IStructuredSelection selection) {
        ArrayList<IResource> results = new ArrayList<IResource>();
        for (Object object : selection) {
            if (object instanceof IPapyrusFile) {
                results.add((IResource)((IPapyrusFile)object).getMainFile());
                continue;
            }
            if (object instanceof IResource) {
                results.addAll(this.findPapyrusModels((IResource)object));
                continue;
            }
            Object element = BusinessModelResolver.getInstance().getBusinessModel(object);
            if (element instanceof EObject) {
                Resource eResource = ((EObject)element).eResource();
                IFile resource = ModelUtils.getIFile(eResource);
                if (resource != null) {
                    try {
                        ModelSet modelSet = ModelUtils.openFile((IResource)resource);
                        SashModel sashModel = (SashModel)modelSet.getModelChecked("org.eclipse.papyrus.infra.core.resource.sasheditor.SashModel");
                        IFile diResource = ModelUtils.getIFile(sashModel.getResource());
                        results.add((IResource)diResource);
                        modelSet.unload();
                    }
                    catch (ModelMultiException e) {
                        results.addAll(this.createWorkspaceScope());
                    }
                    catch (NotFoundException e) {
                        results.addAll(this.createWorkspaceScope());
                    }
                    continue;
                }
                results.addAll(this.createWorkspaceScope());
                continue;
            }
            results.addAll(this.createWorkspaceScope());
        }
        return results;
    }

    protected List<IResource> createProjectsScope(String[] projects) {
        ArrayList<IResource> results = new ArrayList<IResource>();
        String[] stringArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            String projectName = stringArray[n2];
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project.isOpen()) {
                results.addAll(this.findPapyrusModels((IResource)project));
            }
            ++n2;
        }
        return results;
    }

    protected List<IResource> createWorkingSetsScope(IWorkingSet[] workingSets) {
        ArrayList<IResource> results = new ArrayList<IResource>();
        if (workingSets != null && workingSets.length > 0) {
            IWorkingSet[] iWorkingSetArray = workingSets;
            int n = workingSets.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkingSet iWorkingSet = iWorkingSetArray[n2];
                IAdaptable[] iAdaptableArray = iWorkingSet.getElements();
                int n3 = iAdaptableArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IAdaptable element = iAdaptableArray[n4];
                    Object resource = element.getAdapter(IResource.class);
                    if (resource instanceof IResource) {
                        results.addAll(this.findPapyrusModels((IResource)resource));
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return results;
    }

    protected Collection<IResource> findPapyrusModels(IResource res) {
        ResourceVisitor visitor = new ResourceVisitor();
        try {
            res.accept((IResourceProxyVisitor)visitor, 2);
        }
        catch (CoreException e) {
            Activator.log.warn(String.valueOf(Messages.ScopeCollector_0) + res);
        }
        return visitor.getParticipants();
    }

    protected Collection<IResource> createWorkspaceScope() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        return this.findPapyrusModels((IResource)root);
    }
}

