/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.xwt.internal.xml;

import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

public class XDataHandler
extends DefaultHandler
implements ContentHandler {
    private boolean namespaceBegin = false;
    private String currentNamespace;
    private String currentNamespaceUri;
    private StringBuilder out;
    private boolean started;

    public XDataHandler(StringBuilder out) {
        this.out = out;
    }

    public void startPrefixMapping(String prefix, String uri) {
        this.namespaceBegin = true;
        this.currentNamespace = prefix;
        this.currentNamespaceUri = uri;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        if (this.started) {
            this.out.append("<" + qName);
            if (this.namespaceBegin) {
                this.out.append(" xmlns:" + this.currentNamespace + "=\"" + this.currentNamespaceUri + "\"");
                this.namespaceBegin = false;
            }
            int i = 0;
            while (i < atts.getLength()) {
                this.out.append(" " + atts.getQName(i) + "=\"" + atts.getValue(i) + "\"");
                ++i;
            }
            this.out.append(">");
        }
        if (localName.equalsIgnoreCase("xdata")) {
            this.started = true;
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        if (localName.equalsIgnoreCase("xdata")) {
            this.started = false;
        }
        if (this.started) {
            this.out.append("</" + qName + ">");
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.started) {
            int i = start;
            while (i < start + length) {
                this.out.append(ch[i]);
                ++i;
            }
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) {
        if (this.started) {
            int i = start;
            while (i < start + length) {
                this.out.append(ch[i]);
                ++i;
            }
        }
    }

    public void processingInstruction(String target, String data) {
        if (this.started) {
            this.out.append("<?" + target + " " + data + "?>");
        }
    }

    public void skippedEntity(String name) {
        if (this.started) {
            this.out.append("&" + name + ";");
        }
    }
}

