/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.xwt.javabean;

import java.util.HashMap;
import org.eclipse.core.databinding.conversion.IConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueConvertorRegister {
    protected static HashMap<Class<?>, HashMap<Class<?>, IConverter>> register = new HashMap();

    public void register(Class<?> source, Class<?> target, IConverter converter) {
        HashMap<Class<Object>, Object> convertors = register.get(source);
        if (convertors == null) {
            convertors = new HashMap();
            register.put(source, convertors);
        }
        convertors.put(target, converter);
    }

    public IConverter findConverter(Class<?> source, Class<?> target) {
        HashMap<Class<?>, IConverter> convertors = register.get(source);
        if (convertors == null) {
            if (source.isEnum()) {
                convertors = register.get(Enum.class);
                if (convertors == null) {
                    return null;
                }
            } else {
                IConverter converter;
                Class<?>[] interfacees;
                Class<?>[] classArray = interfacees = source.getInterfaces();
                int n = interfacees.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> class1 = classArray[n2];
                    IConverter converter2 = this.findConverter(class1, target);
                    if (converter2 != null) {
                        return converter2;
                    }
                    ++n2;
                }
                Class<?> superclass = source.getSuperclass();
                if (superclass != null && (converter = this.findConverter(superclass, target)) != null) {
                    return converter;
                }
                return null;
            }
        }
        return this.findConverter(convertors, target);
    }

    private IConverter findConverter(HashMap<Class<?>, IConverter> convertors, Class<?> current) {
        IConverter converter = convertors.get(current);
        if (converter == null && current.isEnum()) {
            converter = convertors.get(Enum.class);
        }
        if (converter == null) {
            Class<Object> superclass = current.getSuperclass();
            if (superclass == null && current != Object.class) {
                superclass = Object.class;
            }
            if (superclass != null) {
                converter = this.findConverter(convertors, superclass);
            }
        }
        return converter;
    }
}

