/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.pde.api.tools.internal.builder.AbstractProblemDetector;
import org.eclipse.pde.api.tools.internal.model.ApiType;
import org.eclipse.pde.api.tools.internal.provisional.builder.IReference;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMember;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMethod;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;
import org.eclipse.pde.api.tools.internal.util.Signatures;

public abstract class AbstractIllegalTypeReference
extends AbstractProblemDetector {
    private Map fIllegalTypes = new HashMap();

    void addIllegalType(IReferenceTypeDescriptor type, String componentId) {
        this.fIllegalTypes.put(type.getQualifiedName(), componentId);
    }

    public boolean considerReference(IReference reference) {
        if (super.considerReference(reference) && this.fIllegalTypes.containsKey(reference.getReferencedTypeName())) {
            this.retainReference(reference);
            return true;
        }
        return false;
    }

    protected boolean isIllegalType(IReference reference) {
        return this.fIllegalTypes.containsKey(reference.getReferencedTypeName());
    }

    protected boolean isProblem(IReference reference) {
        if (!super.isProblem(reference)) {
            return false;
        }
        IApiMember type = reference.getResolvedReference();
        String componentId = (String)this.fIllegalTypes.get(type.getName());
        return this.isReferenceFromComponent(reference, componentId);
    }

    protected IMethod getEnclosingMethod(IType jtype, IReference reference, IDocument document) throws CoreException {
        IApiMember member = reference.getMember();
        if (member.getType() == 2) {
            ApiType type = (ApiType)member;
            IApiMethod apimethod = type.getEnclosingMethod();
            if (apimethod != null) {
                String signature = Signatures.processMethodSignature(apimethod);
                String methodname = Signatures.getMethodName(apimethod);
                IMethod method = jtype.getMethod(methodname, Signature.getParameterTypes((String)signature));
                if (method.exists()) {
                    return method;
                }
            } else {
                IMethod method = null;
                if (reference.getLineNumber() > -1) {
                    try {
                        int offset = document.getLineOffset(reference.getLineNumber());
                        method = this.quickLookup(jtype, document, reference, offset);
                    }
                    catch (BadLocationException badLocationException) {}
                }
                if (method == null) {
                    ISourceRange range = jtype.getCompilationUnit().getSourceRange();
                    ASTParser parser = ASTParser.newParser((int)4);
                    parser.setSource(jtype.getCompilationUnit());
                    parser.setSourceRange(range.getOffset(), range.getLength());
                    parser.setResolveBindings(true);
                    ASTNode ptype = parser.createAST(null);
                    MethodFinder finder = new MethodFinder(type, jtype);
                    ptype.accept((ASTVisitor)finder);
                    method = finder.method;
                }
                if (method != null && method.exists()) {
                    ApiType etype = (ApiType)type.getEnclosingType();
                    IApiMethod[] methods = etype.getMethods();
                    String msig = null;
                    int i = 0;
                    while (i < methods.length) {
                        msig = methods[i].getSignature();
                        if (Signatures.getMethodName(methods[i]).equals(method.getElementName()) && Signatures.matchesSignatures(msig.replace('/', '.'), method.getSignature())) {
                            type.setEnclosingMethodInfo(methods[i].getName(), msig);
                        }
                        ++i;
                    }
                    return method;
                }
            }
        }
        return null;
    }

    protected IMethod quickLookup(IType jtype, IDocument document, IReference reference, int offset) throws JavaModelException {
        IJavaElement ancestor;
        IJavaElement element;
        if (offset > -1 && (element = jtype.getCompilationUnit().getElementAt(offset)) != null && (ancestor = element.getAncestor(9)) != null) {
            return (IMethod)ancestor;
        }
        return null;
    }

    protected Position getSourceRange(IType type, IDocument doc, IReference reference) throws CoreException, BadLocationException {
        IApiMember member = reference.getMember();
        if (member.getType() == 2) {
            ApiType ltype = (ApiType)member;
            IMethod method = null;
            if (ltype.isAnonymous()) {
                this.getEnclosingMethod(type, reference, doc);
                if (reference.getLineNumber() < 0) {
                    return this.defaultSourcePosition(type, reference);
                }
                String name = this.getSimpleTypeName(reference.getResolvedReference());
                Position pos = this.getMethodNameRange(true, name, doc, reference);
                if (pos == null) {
                    return this.defaultSourcePosition(type, reference);
                }
                return pos;
            }
            if (ltype.isLocal()) {
                String name = ltype.getSimpleName();
                ICompilationUnit cunit = type.getCompilationUnit();
                if (cunit.isWorkingCopy()) {
                    cunit.reconcile(4, false, null, null);
                }
                IType localtype = type;
                method = this.getEnclosingMethod(type, reference, doc);
                if (method != null) {
                    localtype = method.getType(name, 1);
                }
                if (localtype.exists()) {
                    ISourceRange range = localtype.getNameRange();
                    return new Position(range.getOffset(), range.getLength());
                }
                return this.defaultSourcePosition(type, reference);
            }
        }
        ISourceRange range = type.getNameRange();
        Position pos = null;
        if (range != null) {
            pos = new Position(range.getOffset(), range.getLength());
        }
        if (pos == null) {
            return this.defaultSourcePosition(type, reference);
        }
        return pos;
    }

    protected int getElementType(IReference reference) {
        return 2;
    }

    protected String[] getMessageArgs(IReference reference) throws CoreException {
        IApiMember member = reference.getMember();
        if (member.getType() == 2) {
            ApiType ltype = (ApiType)member;
            String simpleTypeName = this.getSimpleTypeName(reference.getResolvedReference());
            if (ltype.isAnonymous()) {
                IApiType etype = ltype.getEnclosingType();
                String signature = Signatures.getQualifiedTypeSignature(etype);
                IApiMethod method = ltype.getEnclosingMethod();
                if (method != null) {
                    signature = Signatures.getQualifiedMethodSignature(method);
                }
                return new String[]{signature, simpleTypeName};
            }
            if (ltype.isLocal()) {
                IApiType etype = ltype.getEnclosingType();
                IApiMethod method = ltype.getEnclosingMethod();
                if (method != null) {
                    String methodsig = Signatures.getQualifiedMethodSignature(method);
                    return new String[]{Signatures.getAnonymousTypeName(ltype.getName()), methodsig, simpleTypeName};
                }
                return new String[]{Signatures.getAnonymousTypeName(ltype.getName()), this.getSimpleTypeName(etype), simpleTypeName};
            }
        }
        return new String[]{this.getSimpleTypeName(reference.getResolvedReference()), this.getSimpleTypeName(reference.getMember())};
    }

    protected String[] getQualifiedMessageArgs(IReference reference) throws CoreException {
        ApiType ltype;
        IApiMember member = reference.getMember();
        if (member.getType() == 2 && ((ltype = (ApiType)member).isLocal() || ltype.isAnonymous())) {
            return this.getMessageArgs(reference);
        }
        return new String[]{this.getQualifiedTypeName(reference.getResolvedReference()), this.getQualifiedTypeName(reference.getMember())};
    }

    protected int getProblemFlags(IReference reference) {
        IApiMember member = reference.getMember();
        if (member.getType() == 2) {
            IApiType type = (IApiType)reference.getMember();
            if (type.isLocal()) {
                return 10;
            }
            if (type.isAnonymous()) {
                return 11;
            }
        }
        return 0;
    }

    class MethodFinder
    extends ASTVisitor {
        IMethod method = null;
        private IType jtype = null;
        private ApiType type = null;

        public MethodFinder(ApiType type, IType jtype) {
            this.type = type;
            this.jtype = jtype;
        }

        public boolean visit(AnonymousClassDeclaration node) {
            if (this.method == null) {
                ITypeBinding binding = node.resolveBinding();
                String binaryName = binding.getBinaryName();
                if (this.type.getName().endsWith(binaryName)) {
                    try {
                        IJavaElement ancestor;
                        IJavaElement element = this.jtype.getCompilationUnit().getElementAt(node.getStartPosition());
                        if (element != null && (ancestor = element.getAncestor(9)) != null) {
                            this.method = (IMethod)ancestor;
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                    return false;
                }
            }
            return true;
        }

        public boolean visit(TypeDeclaration node) {
            if (this.method == null && node.isLocalTypeDeclaration()) {
                ITypeBinding binding = node.resolveBinding();
                String binaryName = binding.getBinaryName();
                if (this.type.getName().endsWith(binaryName)) {
                    try {
                        IType ltype;
                        IJavaElement parent;
                        IJavaElement element = this.jtype.getCompilationUnit().getElementAt(node.getStartPosition());
                        if (element.getElementType() == 7 && (parent = (ltype = (IType)element).getParent()).getElementType() == 9) {
                            this.method = (IMethod)parent;
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                    return false;
                }
            }
            return true;
        }
    }
}

