/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallChangedListener;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.PropertyChangeEvent;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jdt.launching.environments.ExecutionEnvironmentDescription;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.pde.api.tools.internal.AnyValue;
import org.eclipse.pde.api.tools.internal.ApiBaselineManager;
import org.eclipse.pde.api.tools.internal.CoreMessages;
import org.eclipse.pde.api.tools.internal.model.ApiElement;
import org.eclipse.pde.api.tools.internal.model.ApiModelCache;
import org.eclipse.pde.api.tools.internal.model.BundleComponent;
import org.eclipse.pde.api.tools.internal.model.ProjectComponent;
import org.eclipse.pde.api.tools.internal.model.SystemLibraryApiComponent;
import org.eclipse.pde.api.tools.internal.model.WorkspaceBaseline;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.osgi.framework.Bundle;

public class ApiBaseline
extends ApiElement
implements IApiBaseline,
IVMInstallChangedListener {
    private static final IApiComponent[] EMPTY_COMPONENTS = new IApiComponent[0];
    private State fState;
    private String fExecutionEnvironment;
    private IApiComponent fSystemLibraryComponent;
    private boolean fAutoResolve = true;
    private String fLocation;
    private IStatus fEEStatus = null;
    private AnyValue ANY_VALUE = new AnyValue("*");
    private HashMap fComponentsProvidingPackageCache = null;
    private HashMap fComponentsById = null;
    private HashMap fComponentsByProjectNames = null;
    private HashSet fSystemPackageNames = null;
    private IVMInstall fVMBinding = null;

    public ApiBaseline(String name) {
        super(null, 4, name);
        this.fEEStatus = new Status(4, "org.eclipse.pde.api.tools", CoreMessages.ApiBaseline_0);
    }

    public ApiBaseline(String name, File eeDescription) throws CoreException {
        this(name, eeDescription, null);
    }

    public ApiBaseline(String name, File eeDescription, String location) throws CoreException {
        this(name);
        if (eeDescription != null) {
            this.fAutoResolve = false;
            ExecutionEnvironmentDescription ee = new ExecutionEnvironmentDescription(eeDescription);
            String profile = ee.getProperty("-Dee.class.library.level");
            this.initialize(ee);
            this.fEEStatus = new Status(0, "org.eclipse.pde.api.tools", MessageFormat.format((String)CoreMessages.ApiBaseline_1, (Object[])new String[]{profile}));
        }
        this.fLocation = location;
    }

    private void initialize(ExecutionEnvironmentDescription ee) throws CoreException {
        Properties properties = null;
        String environmentId = ee.getProperty("-Dee.class.library.level");
        properties = ApiPlugin.isRunningInFramework() ? ApiBaseline.getJavaProfileProperties(environmentId) : Util.getEEProfile(environmentId);
        if (properties == null) {
            this.abort("Unknown execution environment: " + environmentId, null);
        } else {
            this.initialize(properties, ee);
        }
    }

    public static Properties getJavaProfileProperties(String ee) throws CoreException {
        Bundle osgiBundle = Platform.getBundle((String)"org.eclipse.osgi");
        if (osgiBundle == null) {
            return null;
        }
        URL profileURL = osgiBundle.getEntry(String.valueOf(ee.replace('/', '_')) + ".profile");
        if (profileURL != null) {
            InputStream is = null;
            try {
                profileURL = FileLocator.resolve((URL)profileURL);
                URLConnection openConnection = profileURL.openConnection();
                openConnection.setUseCaches(false);
                is = openConnection.getInputStream();
                if (is != null) {
                    Properties profile = new Properties();
                    profile.load(is);
                    Properties properties = profile;
                    return properties;
                }
            }
            catch (IOException e) {
                ApiPlugin.log(e);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    ApiPlugin.log(e);
                }
            }
        }
        return null;
    }

    private void initialize(Properties profile, ExecutionEnvironmentDescription description) throws CoreException {
        String value = profile.getProperty("org.osgi.framework.system.packages");
        String[] systemPackages = null;
        if (value != null) {
            systemPackages = value.split(",");
        }
        if (!(this instanceof WorkspaceBaseline)) {
            Hashtable<String, Object> dictionary = new Hashtable<String, Object>();
            ((Dictionary)dictionary).put("org.osgi.framework.system.packages", value);
            value = profile.getProperty("org.osgi.framework.executionenvironment");
            if (value != null) {
                ((Dictionary)dictionary).put("org.osgi.framework.executionenvironment", value);
            }
            this.fExecutionEnvironment = profile.getProperty("osgi.java.profile.name");
            if (this.fExecutionEnvironment == null) {
                this.abort("Profile file missing 'osgi.java.profile.name'", null);
            }
            ((Dictionary)dictionary).put("osgi.os", this.ANY_VALUE);
            ((Dictionary)dictionary).put("osgi.arch", this.ANY_VALUE);
            ((Dictionary)dictionary).put("osgi.ws", this.ANY_VALUE);
            ((Dictionary)dictionary).put("osgi.nl", this.ANY_VALUE);
            this.getState().setPlatformProperties(dictionary);
        }
        if (this.fSystemLibraryComponent != null && this.fComponentsById != null) {
            this.fComponentsById.remove(this.fSystemLibraryComponent.getSymbolicName());
        }
        if (this.fSystemPackageNames != null) {
            this.fSystemPackageNames.clear();
            this.fSystemPackageNames = null;
        }
        this.clearComponentsCache();
        this.fSystemLibraryComponent = new SystemLibraryApiComponent(this, description, systemPackages);
        this.addComponent(this.fSystemLibraryComponent);
    }

    private synchronized void clearComponentsCache() {
        if (this.fComponentsProvidingPackageCache != null) {
            this.fComponentsProvidingPackageCache.clear();
            this.fComponentsProvidingPackageCache = null;
        }
    }

    protected void addComponent(IApiComponent component) throws CoreException {
        if (component == null) {
            return;
        }
        if (this.fComponentsById == null) {
            this.fComponentsById = new HashMap();
        }
        this.fComponentsById.put(component.getSymbolicName(), component);
        if (component instanceof ProjectComponent) {
            ProjectComponent projectApiComponent = (ProjectComponent)component;
            if (this.fComponentsByProjectNames == null) {
                this.fComponentsByProjectNames = new HashMap();
            }
            this.fComponentsByProjectNames.put(projectApiComponent.getJavaProject().getProject().getName(), component);
        }
    }

    public void addApiComponents(IApiComponent[] components) throws CoreException {
        HashSet<String> ees = new HashSet<String>();
        int i = 0;
        while (i < components.length) {
            BundleComponent component = (BundleComponent)components[i];
            if (!component.isSourceComponent()) {
                BundleDescription description = component.getBundleDescription();
                this.getState().addBundle(description);
                this.addComponent(component);
                ees.addAll(Arrays.asList(component.getExecutionEnvironments()));
            }
            ++i;
        }
        this.resolveSystemLibrary(ees);
        this.getState().resolve();
    }

    protected void resolveSystemLibrary(HashSet ees) {
        if (ApiPlugin.isRunningInFramework() && this.fAutoResolve) {
            Status error = null;
            IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
            Iterator<Object> iterator = ees.iterator();
            HashMap<IVMInstall, HashSet<String>> VMsToEEs = new HashMap<IVMInstall, HashSet<String>>();
            while (iterator.hasNext()) {
                String ee = (String)iterator.next();
                IExecutionEnvironment environment = manager.getEnvironment(ee);
                if (environment == null) continue;
                IVMInstall[] compatibleVMs = environment.getCompatibleVMs();
                int i = 0;
                while (i < compatibleVMs.length) {
                    IVMInstall vm = compatibleVMs[i];
                    HashSet<String> EEs = (HashSet<String>)VMsToEEs.get(vm);
                    if (EEs == null) {
                        EEs = new HashSet<String>();
                        VMsToEEs.put(vm, EEs);
                    }
                    EEs.add(ee);
                    ++i;
                }
            }
            iterator = VMsToEEs.entrySet().iterator();
            IVMInstall bestFit = null;
            int bestCount = 0;
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                Set EEs = (Set)entry.getValue();
                if (EEs.size() <= bestCount) continue;
                bestCount = EEs.size();
                bestFit = (IVMInstall)entry.getKey();
            }
            String systemEE = null;
            if (bestFit != null) {
                IExecutionEnvironment[] environments = manager.getExecutionEnvironments();
                int i = 0;
                while (i < environments.length) {
                    IExecutionEnvironment environment = environments[i];
                    if (environment.isStrictlyCompatible(bestFit)) {
                        systemEE = environment.getId();
                        break;
                    }
                    ++i;
                }
                if (systemEE == null) {
                    systemEE = "JavaSE-1.7";
                }
                if (!systemEE.equals(this.getExecutionEnvironment()) || this.fVMBinding == null) {
                    try {
                        File file = Util.createEEFile(bestFit, systemEE);
                        JavaRuntime.addVMInstallChangedListener((IVMInstallChangedListener)this);
                        this.fVMBinding = bestFit;
                        ExecutionEnvironmentDescription ee = new ExecutionEnvironmentDescription(file);
                        this.initialize(ee);
                    }
                    catch (CoreException e) {
                        error = new Status(4, "org.eclipse.pde.api.tools", CoreMessages.ApiBaseline_2, (Throwable)e);
                    }
                    catch (IOException e) {
                        error = new Status(4, "org.eclipse.pde.api.tools", CoreMessages.ApiBaseline_2, (Throwable)e);
                    }
                }
            } else {
                error = new Status(4, "org.eclipse.pde.api.tools", CoreMessages.ApiBaseline_6);
            }
            if (error == null) {
                HashSet missing = new HashSet(ees);
                HashSet covered = new HashSet((Set)VMsToEEs.get(bestFit));
                missing.removeAll(covered);
                if (missing.isEmpty()) {
                    this.fEEStatus = new Status(0, "org.eclipse.pde.api.tools", MessageFormat.format((String)CoreMessages.ApiBaseline_1, (Object[])new String[]{systemEE}));
                } else {
                    iterator = missing.iterator();
                    MultiStatus multi = new MultiStatus("org.eclipse.pde.api.tools", 0, CoreMessages.ApiBaseline_4, null);
                    while (iterator.hasNext()) {
                        String id = (String)iterator.next();
                        multi.add((IStatus)new Status(2, "org.eclipse.pde.api.tools", MessageFormat.format((String)CoreMessages.ApiBaseline_5, (Object[])new String[]{id})));
                    }
                    this.fEEStatus = multi;
                }
            } else {
                this.fEEStatus = error;
            }
        }
    }

    public boolean peekInfos() {
        return this.fComponentsById != null;
    }

    public IApiComponent[] getApiComponents() {
        this.loadBaselineInfos();
        if (this.fComponentsById == null) {
            return EMPTY_COMPONENTS;
        }
        Collection values = this.fComponentsById.values();
        return values.toArray(new IApiComponent[values.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized IApiComponent[] resolvePackage(IApiComponent sourceComponent, String packageName) throws CoreException {
        HashMap<IApiComponent, IApiComponent[]> componentsForPackage = null;
        if (this.fComponentsProvidingPackageCache != null) {
            componentsForPackage = (HashMap<IApiComponent, IApiComponent[]>)this.fComponentsProvidingPackageCache.get(packageName);
        } else {
            this.fComponentsProvidingPackageCache = new HashMap(8);
        }
        IApiComponent[] cachedComponents = null;
        if (componentsForPackage != null) {
            cachedComponents = (IApiComponent[])componentsForPackage.get(sourceComponent);
            if (cachedComponents != null && cachedComponents.length > 0) {
                return cachedComponents;
            }
        } else {
            componentsForPackage = new HashMap<IApiComponent, IApiComponent[]>(8);
            this.fComponentsProvidingPackageCache.put(packageName, componentsForPackage);
        }
        if (this.isSystemPackage(packageName)) {
            if (this.fSystemLibraryComponent == null) return EMPTY_COMPONENTS;
            cachedComponents = new IApiComponent[]{this.fSystemLibraryComponent};
        } else if (sourceComponent != null) {
            ArrayList componentsList = new ArrayList();
            this.resolvePackage0(sourceComponent, packageName, componentsList);
            if (componentsList.size() != 0) {
                cachedComponents = new IApiComponent[componentsList.size()];
                componentsList.toArray(cachedComponents);
            }
        }
        if (cachedComponents == null) {
            cachedComponents = EMPTY_COMPONENTS;
        }
        if (cachedComponents.length == 0) {
            return EMPTY_COMPONENTS;
        }
        componentsForPackage.put(sourceComponent, cachedComponents);
        return cachedComponents;
    }

    private void resolvePackage0(IApiComponent component, String packageName, List componentsList) throws CoreException {
        BundleDescription bundle;
        if (component instanceof BundleComponent && (bundle = ((BundleComponent)component).getBundleDescription()) != null) {
            String[] packageNames;
            int index;
            StateHelper helper = this.getState().getStateHelper();
            ExportPackageDescription[] visiblePackages = helper.getVisiblePackages(bundle);
            int i = 0;
            int max = visiblePackages.length;
            while (i < max) {
                BundleDescription bundleDescription;
                IApiComponent exporter;
                ExportPackageDescription pkg = visiblePackages[i];
                if (packageName.equals(pkg.getName()) && (exporter = this.getApiComponent((bundleDescription = pkg.getExporter()).getSymbolicName())) != null) {
                    componentsList.add(exporter);
                }
                ++i;
            }
            if (component.isFragment()) {
                HostSpecification host = bundle.getHost();
                BundleDescription[] hosts = host.getHosts();
                int i2 = 0;
                int max2 = hosts.length;
                while (i2 < max2) {
                    BundleDescription currentHost = hosts[i2];
                    IApiComponent apiComponent = component.getBaseline().getApiComponent(currentHost.getName());
                    if (apiComponent != null) {
                        this.resolvePackage0(apiComponent, packageName, componentsList);
                    }
                    ++i2;
                }
            }
            if ((index = Arrays.binarySearch(packageNames = component.getPackageNames(), packageName, null)) >= 0) {
                componentsList.add(component);
            }
        }
    }

    public IApiComponent[] getVisibleDependentComponents(IApiComponent[] components) throws CoreException {
        ArrayList bundles = this.getBundleDescriptions(components);
        BundleDescription[] descs = this.getState().getStateHelper().getDependentBundles(bundles.toArray(new BundleDescription[bundles.size()]));
        HashSet<BundleDescription> visible = new HashSet<BundleDescription>();
        ExportPackageDescription[] packages = null;
        int i = 0;
        while (i < descs.length) {
            packages = this.getState().getStateHelper().getVisiblePackages(descs[i]);
            int j = 0;
            while (j < packages.length) {
                if (bundles.contains(packages[j].getSupplier())) {
                    visible.add(descs[i]);
                }
                ++j;
            }
            ++i;
        }
        return this.getApiComponents(visible.toArray(new BundleDescription[visible.size()]));
    }

    private boolean isSystemPackage(String packageName) {
        if (packageName.startsWith("java.")) {
            return true;
        }
        if (this.fSystemPackageNames == null) {
            ExportPackageDescription[] systemPackages = this.getState().getSystemPackages();
            this.fSystemPackageNames = new HashSet(systemPackages.length);
            int i = 0;
            while (i < systemPackages.length) {
                this.fSystemPackageNames.add(systemPackages[i].getName());
                ++i;
            }
        }
        return this.fSystemPackageNames.contains(packageName);
    }

    public State getState() {
        if (this.fState == null) {
            this.fState = StateObjectFactory.defaultFactory.createState(true);
        }
        return this.fState;
    }

    public IApiComponent getApiComponent(String id) {
        this.loadBaselineInfos();
        if (this.fComponentsById == null) {
            return null;
        }
        return (IApiComponent)this.fComponentsById.get(id);
    }

    public String getExecutionEnvironment() {
        return this.fExecutionEnvironment;
    }

    private void loadBaselineInfos() {
        if (this.fComponentsById != null) {
            return;
        }
        try {
            ApiBaselineManager.getManager().loadBaselineInfos(this);
        }
        catch (CoreException ce) {
            ApiPlugin.log(ce);
        }
    }

    public ResolverError[] getErrors() {
        ArrayList<ResolverError> errs = null;
        BundleDescription[] bundles = this.getState().getBundles();
        int i = 0;
        while (i < bundles.length) {
            ResolverError[] errors = this.getState().getResolverErrors(bundles[i]);
            int j = 0;
            while (j < errors.length) {
                if (errs == null) {
                    errs = new ArrayList<ResolverError>();
                }
                errs.add(errors[j]);
                ++j;
            }
            ++i;
        }
        if (errs != null) {
            return errs.toArray(new ResolverError[errs.size()]);
        }
        return null;
    }

    public void setName(String name) {
        super.setName(name);
    }

    public boolean equals(Object obj) {
        if (obj instanceof IApiBaseline) {
            IApiBaseline baseline = (IApiBaseline)obj;
            return this.getName().equals(baseline.getName());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public void dispose() {
        if (this.fState == null) {
            return;
        }
        this.doDispose();
        this.fState = null;
    }

    protected void doDispose() {
        if (ApiPlugin.isRunningInFramework()) {
            JavaRuntime.removeVMInstallChangedListener((IVMInstallChangedListener)this);
        }
        this.clearCachedElements();
        IApiComponent[] components = this.getApiComponents();
        int i = 0;
        while (i < components.length) {
            components[i].dispose();
            ++i;
        }
        this.clearComponentsCache();
        if (this.fComponentsById != null) {
            this.fComponentsById.clear();
            this.fComponentsById = null;
        }
        if (this.fComponentsByProjectNames != null) {
            this.fComponentsByProjectNames.clear();
            this.fComponentsByProjectNames = null;
        }
        if (this.fSystemPackageNames != null) {
            this.fSystemPackageNames.clear();
        }
        if (this.fSystemLibraryComponent != null) {
            this.fSystemLibraryComponent.dispose();
            this.fSystemLibraryComponent = null;
        }
    }

    public void close() throws CoreException {
        this.clearCachedElements();
        IApiComponent[] components = this.getApiComponents();
        int i = 0;
        while (i < components.length) {
            components[i].close();
            ++i;
        }
    }

    void clearCachedElements() {
        ApiModelCache.getCache().removeElementInfo(this);
    }

    public IApiComponent[] getDependentComponents(IApiComponent[] components) throws CoreException {
        ArrayList bundles = this.getBundleDescriptions(components);
        BundleDescription[] bundleDescriptions = this.getState().getStateHelper().getDependentBundles(bundles.toArray(new BundleDescription[bundles.size()]));
        return this.getApiComponents(bundleDescriptions);
    }

    private IApiComponent[] getApiComponents(BundleDescription[] bundles) {
        ArrayList<IApiComponent> dependents = new ArrayList<IApiComponent>(bundles.length);
        int i = 0;
        while (i < bundles.length) {
            BundleDescription bundle = bundles[i];
            IApiComponent component = this.getApiComponent(bundle.getSymbolicName());
            if (component != null) {
                dependents.add(component);
            }
            ++i;
        }
        return dependents.toArray(new IApiComponent[dependents.size()]);
    }

    private ArrayList getBundleDescriptions(IApiComponent[] components) throws CoreException {
        ArrayList<BundleDescription> bundles = new ArrayList<BundleDescription>(components.length);
        int i = 0;
        while (i < components.length) {
            IApiComponent component = components[i];
            if (component instanceof BundleComponent) {
                bundles.add(((BundleComponent)component).getBundleDescription());
            }
            ++i;
        }
        return bundles;
    }

    public IApiComponent[] getPrerequisiteComponents(IApiComponent[] components) throws CoreException {
        ArrayList bundles = this.getBundleDescriptions(components);
        BundleDescription[] bundlesDescriptions = this.getState().getStateHelper().getPrerequisites(bundles.toArray(new BundleDescription[bundles.size()]));
        return this.getApiComponents(bundlesDescriptions);
    }

    public synchronized void clearPackage(String packageName) {
        if (this.fComponentsProvidingPackageCache != null) {
            this.fComponentsProvidingPackageCache.remove(packageName);
        }
    }

    public String toString() {
        return this.getName();
    }

    public IStatus getExecutionEnvironmentStatus() {
        return this.fEEStatus;
    }

    public void defaultVMInstallChanged(IVMInstall previous, IVMInstall current) {
    }

    public void vmAdded(IVMInstall vm) {
        if (!(vm instanceof VMStandin)) {
            try {
                this.rebindVM();
            }
            catch (CoreException e) {
                ApiPlugin.log(e);
            }
        }
    }

    public void vmChanged(PropertyChangeEvent event) {
        String property;
        if (!(event.getSource() instanceof VMStandin) && (IVMInstallChangedListener.PROPERTY_INSTALL_LOCATION.equals(property = event.getProperty()) || IVMInstallChangedListener.PROPERTY_LIBRARY_LOCATIONS.equals(property))) {
            try {
                this.rebindVM();
            }
            catch (CoreException e) {
                ApiPlugin.log(e);
            }
        }
    }

    private void rebindVM() throws CoreException {
        this.fVMBinding = null;
        IApiComponent[] components = this.getApiComponents();
        HashSet<String> ees = new HashSet<String>();
        int i = 0;
        while (i < components.length) {
            ees.addAll(Arrays.asList(components[i].getExecutionEnvironments()));
            ++i;
        }
        this.resolveSystemLibrary(ees);
    }

    public void vmRemoved(IVMInstall vm) {
        if (vm.equals(this.fVMBinding)) {
            try {
                this.rebindVM();
            }
            catch (CoreException e) {
                ApiPlugin.log(e);
            }
        }
    }

    public String getLocation() {
        return this.fLocation;
    }

    public void setLocation(String location) {
        this.fLocation = location;
    }

    public IApiComponent getApiComponent(IProject project) {
        this.loadBaselineInfos();
        if (this.fComponentsByProjectNames == null) {
            return null;
        }
        return (IApiComponent)this.fComponentsByProjectNames.get(project.getName());
    }
}

