/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.goals.AbstractTypeGoal;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferencer;
import org.eclipse.php.internal.core.typeinference.context.FileContext;

public class ModelElementResolver {
    public static IModelElement[] resolve(ISourceModule sourceModule, int offset) {
        IType[] modelElements = null;
        ContextFinder visitor = new ContextFinder(sourceModule, offset);
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
        try {
            moduleDeclaration.traverse((ASTVisitor)visitor);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        if (visitor.getNode() != null) {
            PHPTypeInferencer typeInferencer = new PHPTypeInferencer();
            IEvaluatedType evaluatedType = typeInferencer.evaluateType((AbstractTypeGoal)new ExpressionTypeGoal(visitor.getContext(), visitor.getNode()));
            modelElements = PHPTypeInferenceUtils.getModelElements(evaluatedType, (ISourceModuleContext)((FileContext)visitor.getContext()), offset);
        }
        return modelElements;
    }

    private static class ContextFinder
    extends org.eclipse.php.internal.core.typeinference.context.ContextFinder {
        private IContext context;
        private ASTNode node;
        private int offset;

        public ContextFinder(ISourceModule sourceModule, int offset) {
            super(sourceModule);
            this.offset = offset;
        }

        public IContext getContext() {
            return this.context;
        }

        public ASTNode getNode() {
            return this.node;
        }

        public boolean visitGeneral(ASTNode node) throws Exception {
            if (node.sourceEnd() < this.offset || node.sourceStart() > this.offset) {
                return false;
            }
            if (node.sourceStart() <= this.offset && node.sourceEnd() >= this.offset && !this.contextStack.isEmpty()) {
                this.context = (IContext)this.contextStack.peek();
                this.node = node;
            }
            return true;
        }
    }
}

