/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.php.debug.core.debugger.IDebugHandler;
import org.eclipse.php.debug.core.debugger.messages.IDebugMessage;
import org.eclipse.php.debug.core.debugger.messages.IDebugNotificationMessage;
import org.eclipse.php.debug.core.debugger.messages.IDebugRequestMessage;
import org.eclipse.php.debug.core.debugger.messages.IDebugResponseMessage;
import org.eclipse.php.internal.core.includepath.IncludePath;
import org.eclipse.php.internal.core.includepath.IncludePathManager;
import org.eclipse.php.internal.core.util.PHPSearchEngine;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.pathmapper.DebugSearchEngine;
import org.eclipse.php.internal.debug.core.pathmapper.PathEntry;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapper;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapperRegistry;
import org.eclipse.php.internal.debug.core.pathmapper.VirtualPath;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.zend.communication.DebugConnectionThread;
import org.eclipse.php.internal.debug.core.zend.communication.ResponseHandler;
import org.eclipse.php.internal.debug.core.zend.debugger.Breakpoint;
import org.eclipse.php.internal.debug.core.zend.debugger.Debugger;
import org.eclipse.php.internal.debug.core.zend.debugger.IRemoteDebugger;
import org.eclipse.php.internal.debug.core.zend.debugger.OldDebuggerWarningDialog;
import org.eclipse.php.internal.debug.core.zend.debugger.PHPstack;
import org.eclipse.php.internal.debug.core.zend.debugger.StackLayer;
import org.eclipse.php.internal.debug.core.zend.debugger.ZendDebuggerConfiguration;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.AddBreakpointRequest;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.AddBreakpointResponse;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.AddFilesRequest;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.AddFilesResponse;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.AssignValueRequest;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.CancelAllBreakpointsRequest;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.CancelAllBreakpointsResponse;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.CancelBreakpointRequest;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.CancelBreakpointResponse;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.DebugSessionClosedNotification;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.EvalRequest;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.EvalResponse;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.GetCWDRequest;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.GetCWDResponse;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.GetCallStackRequest;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.GetCallStackResponse;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.GetStackVariableValueRequest;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.GetStackVariableValueResponse;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.GetVariableValueRequest;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.GetVariableValueResponse;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.GoRequest;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.GoResponse;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.PauseDebuggerRequest;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.PauseDebuggerResponse;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.SetProtocolRequest;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.SetProtocolResponse;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.StartRequest;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.StartResponse;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.StepIntoRequest;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.StepIntoResponse;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.StepOutRequest;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.StepOutResponse;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.StepOverRequest;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.StepOverResponse;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteDebugger
implements IRemoteDebugger {
    public static final int PROTOCOL_ID_2006040701 = 2006040701;
    public static final int PROTOCOL_ID_2006040703 = 2006040703;
    public static final int PROTOCOL_ID_2006040705 = 2006040705;
    public static final int PROTOCOL_ID_2012121702 = 2012121702;
    public static final int PROTOCOL_ID_LATEST = 2012121702;
    private static final String EVAL_ERROR = "[Error]";
    protected boolean isDebugMode = System.getProperty("loggingDebug") != null;
    private DebugConnectionThread connection;
    private IDebugHandler debugHandler;
    private Map<String, String> resolvedFiles;
    private Map<String, List<IPath>> resolvedIncludePaths;
    private int currentProtocolId = 0;
    private int previousSuspendCount;
    private String cachedCWD;
    private PHPstack cachedStack;

    public RemoteDebugger(IDebugHandler debugHandler, DebugConnectionThread connectionThread) {
        this.connection = connectionThread;
        this.debugHandler = debugHandler;
        this.connection.setCommunicationAdministrator(this);
        this.connection.setCommunicationClient(this);
        this.resolvedFiles = new HashMap<String, String>();
        this.resolvedIncludePaths = new HashMap<String, List<IPath>>();
    }

    @Override
    public IDebugHandler getDebugHandler() {
        return this.debugHandler;
    }

    @Override
    public DebugConnectionThread getConnectionThread() {
        return this.connection;
    }

    @Override
    public void closeConnection() {
        this.connection.closeConnection();
    }

    @Override
    public void connectionEstablished() {
        this.debugHandler.connectionEstablished();
    }

    @Override
    public void connectionClosed() {
        this.debugHandler.connectionClosed();
    }

    @Override
    public void closeDebugSession() {
        if (this.connection.isConnected()) {
            this.connection.sendNotification(new DebugSessionClosedNotification());
        }
    }

    @Override
    public void handleMultipleBindings() {
        this.debugHandler.multipleBindOccured();
    }

    @Override
    public void handlePeerResponseTimeout() {
        this.debugHandler.connectionTimedout();
    }

    @Override
    public boolean canDo(int feature) {
        switch (feature) {
            case 1: {
                return this.getCurrentProtocolID() >= 2006040703;
            }
            case 2: 
            case 3: {
                return this.getCurrentProtocolID() >= 2006040705;
            }
        }
        return false;
    }

    public String getCWDOld() {
        String result;
        EvalRequest request = new EvalRequest();
        request.setCommand("getcwd()");
        IDebugResponseMessage response = this.sendCustomRequest(request);
        if (response != null && response instanceof EvalResponse && !EVAL_ERROR.equals(result = ((EvalResponse)response).getResult())) {
            return result;
        }
        return null;
    }

    public String getCWDNew() {
        GetCWDRequest request = new GetCWDRequest();
        IDebugResponseMessage response = this.sendCustomRequest(request);
        if (response != null && response.getStatus() == 0) {
            return ((GetCWDResponse)response).getCWD();
        }
        return null;
    }

    public String getCWD() {
        if (!this.isActive()) {
            return null;
        }
        PHPDebugTarget debugTarget = this.getDebugHandler().getDebugTarget();
        int suspendCount = debugTarget.getSuspendCount();
        if (suspendCount == this.previousSuspendCount && this.cachedCWD != null) {
            return this.cachedCWD;
        }
        this.cachedCWD = this.canDo(2) ? this.getCWDNew() : this.getCWDOld();
        return this.cachedCWD;
    }

    public String getCurrentWorkingDirectory() {
        PathEntry cwdEntry;
        PathMapper pathMapper;
        PHPDebugTarget debugTarget = this.debugHandler.getDebugTarget();
        String cwd = this.getCWD();
        if (cwd != null && (pathMapper = PathMapperRegistry.getByLaunchConfiguration(debugTarget.getLaunch().getLaunchConfiguration())) != null && (cwdEntry = pathMapper.getLocalFile(cwd)) != null) {
            cwd = cwdEntry.getResolvedPath();
        }
        return cwd;
    }

    public boolean setCurrentWorkingDirectory(String cwd) {
        try {
            String result;
            EvalRequest request = new EvalRequest();
            request.setCommand(String.format("chdir('%1$s')", cwd));
            IDebugResponseMessage response = this.sendCustomRequest(request);
            if (response != null && response instanceof EvalResponse && !EVAL_ERROR.equals(result = ((EvalResponse)response).getResult())) {
                return true;
            }
        }
        catch (Exception e) {
            Logger.logException((Throwable)e);
        }
        return false;
    }

    public String convertToLocalFilename(String remoteFile) {
        String currentScript = null;
        PHPstack callStack = this.getCallStack();
        if (callStack.getSize() > 0) {
            currentScript = callStack.getLayer(callStack.getSize() - 1).getResolvedCalledFileName();
        }
        return this.convertToLocalFilename(remoteFile, this.getCurrentWorkingDirectory(), currentScript);
    }

    public String convertToLocalFilename(String remoteFile, String cwd, String currentScript) {
        String localFile;
        PHPDebugTarget debugTarget = this.debugHandler.getDebugTarget();
        if (debugTarget.getContextManager().isResolveBlacklisted(remoteFile)) {
            return remoteFile;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace.getRoot().findMember(remoteFile) != null) {
            return remoteFile;
        }
        if (debugTarget.isPHPCGI() && new File(remoteFile).exists()) {
            IProject project;
            IFile wsFile = null;
            Path location = new Path(remoteFile);
            IProject[] projects = workspace.getRoot().getProjects();
            IProject currentProject = debugTarget.getProject();
            int i = 0;
            while (i < projects.length) {
                project = projects[i];
                if (project.equals((Object)currentProject)) {
                    IProject tmp = projects[0];
                    projects[0] = project;
                    projects[i] = tmp;
                    break;
                }
                ++i;
            }
            i = 0;
            while (i < projects.length) {
                IPath projectLocation;
                project = projects[i];
                if (project.isOpen() && project.isAccessible() && (projectLocation = project.getLocation()) != null && projectLocation.isPrefixOf((IPath)location)) {
                    int segmentsToRemove = projectLocation.segmentCount();
                    wsFile = workspace.getRoot().getFile(project.getFullPath().append(location.removeFirstSegments(segmentsToRemove)));
                    break;
                }
                ++i;
            }
            if (wsFile != null) {
                return wsFile.getFullPath().toString();
            }
            return remoteFile;
        }
        String resolvedFileKey = remoteFile + cwd + currentScript;
        if (!this.resolvedFiles.containsKey(resolvedFileKey)) {
            String currentScriptDir = null;
            if (currentScript != null) {
                currentScriptDir = new Path(currentScript).removeLastSegments(1).toString();
            }
            String resolvedFile = null;
            PathEntry pathEntry = DebugSearchEngine.find(remoteFile, debugTarget, cwd, currentScriptDir);
            if (pathEntry != null) {
                resolvedFile = pathEntry.getResolvedPath();
            } else {
                try {
                    resolvedFile = this.tryGuessMapping(remoteFile, debugTarget);
                }
                catch (ModelException modelException) {
                    resolvedFile = remoteFile;
                }
            }
            this.resolvedFiles.put(resolvedFileKey, resolvedFile);
        }
        if ((localFile = this.resolvedFiles.get(resolvedFileKey)) == null) {
            return remoteFile;
        }
        return localFile;
    }

    public static String convertToRemoteFilename(String localFile, PHPDebugTarget debugTarget) {
        String remoteFile;
        PathMapper pathMapper;
        IPath path = Path.fromPortableString((String)localFile);
        if (path.segmentCount() >= 2) {
            File fsFile;
            IFile wsFile = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            if (debugTarget.isPHPCGI() && wsFile.exists() && wsFile.getLocation() != null && (fsFile = wsFile.getLocation().toFile()).exists()) {
                return fsFile.getAbsolutePath();
            }
        }
        if (VirtualPath.isAbsolute(localFile) && (pathMapper = PathMapperRegistry.getByLaunchConfiguration(debugTarget.getLaunch().getLaunchConfiguration())) != null && (remoteFile = pathMapper.getRemoteFile(localFile)) != null) {
            return remoteFile;
        }
        return localFile;
    }

    @Override
    public IDebugResponseMessage sendCustomRequest(IDebugRequestMessage request) {
        IDebugResponseMessage response = null;
        if (this.isActive()) {
            try {
                Object obj = this.connection.sendRequest(request);
                if (obj instanceof IDebugResponseMessage) {
                    response = (IDebugResponseMessage)obj;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return response;
    }

    public boolean sendCustomNotification(IDebugNotificationMessage notification) {
        if (this.isActive()) {
            try {
                this.connection.sendNotification(notification);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public boolean addBreakpoint(Breakpoint bp, Debugger.BreakpointAddedResponseHandler responseHandler) {
        if (!this.isActive()) {
            return false;
        }
        try {
            AddBreakpointRequest request = new AddBreakpointRequest();
            Breakpoint tmpBreakpoint = (Breakpoint)bp.clone();
            String fileName = tmpBreakpoint.getFileName();
            tmpBreakpoint.setFileName(fileName);
            request.setBreakpoint(tmpBreakpoint);
            this.connection.sendRequest(request, new ThisHandleResponse(responseHandler));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void addBreakpoint(Breakpoint breakpoint) {
        if (!this.isActive()) {
            return;
        }
        try {
            AddBreakpointRequest request = new AddBreakpointRequest();
            Breakpoint tmpBreakpoint = (Breakpoint)breakpoint.clone();
            String fileName = tmpBreakpoint.getFileName();
            tmpBreakpoint.setFileName(fileName);
            request.setBreakpoint(tmpBreakpoint);
            AddBreakpointResponse response = (AddBreakpointResponse)this.connection.sendRequest(request);
            if (response != null && response.getStatus() == 0) {
                breakpoint.setID(response.getBreakpointID());
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    @Override
    public boolean removeBreakpoint(int id, Debugger.BreakpointRemovedResponseHandler responseHandler) {
        if (!this.isActive()) {
            return false;
        }
        CancelBreakpointRequest request = new CancelBreakpointRequest();
        request.setBreakpointID(id);
        this.connection.sendRequest(request, new ThisHandleResponse(responseHandler));
        return true;
    }

    @Override
    public boolean removeBreakpoint(int id) {
        if (!this.isActive()) {
            return false;
        }
        try {
            CancelBreakpointRequest request = new CancelBreakpointRequest();
            request.setBreakpointID(id);
            CancelBreakpointResponse response = (CancelBreakpointResponse)this.connection.sendRequest(request);
            return response != null && response.getStatus() == 0;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean removeBreakpoint(Breakpoint breakpoint, Debugger.BreakpointRemovedResponseHandler responseHandler) {
        return this.removeBreakpoint(breakpoint.getID(), responseHandler);
    }

    @Override
    public boolean removeBreakpoint(Breakpoint breakpoint) {
        return this.removeBreakpoint(breakpoint.getID());
    }

    @Override
    public boolean removeAllBreakpoints(Debugger.AllBreakpointRemovedResponseHandler responseHandler) {
        if (!this.isActive()) {
            return false;
        }
        CancelAllBreakpointsRequest request = new CancelAllBreakpointsRequest();
        this.connection.sendRequest(request, new ThisHandleResponse(responseHandler));
        return true;
    }

    @Override
    public boolean removeAllBreakpoints() {
        if (!this.isActive()) {
            return false;
        }
        try {
            CancelAllBreakpointsRequest request = new CancelAllBreakpointsRequest();
            CancelAllBreakpointsResponse response = (CancelAllBreakpointsResponse)this.connection.sendRequest(request);
            return response != null && response.getStatus() == 0;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean stepInto(Debugger.StepIntoResponseHandler responseHandler) {
        if (!this.isActive()) {
            return false;
        }
        StepIntoRequest request = new StepIntoRequest();
        this.connection.sendRequest(request, new ThisHandleResponse(responseHandler));
        return true;
    }

    @Override
    public boolean stepInto() {
        if (!this.isActive()) {
            return false;
        }
        try {
            StepIntoRequest request = new StepIntoRequest();
            StepIntoResponse response = (StepIntoResponse)this.connection.sendRequest(request);
            return response != null && response.getStatus() == 0;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean stepOver(Debugger.StepOverResponseHandler responseHandler) {
        if (!this.isActive()) {
            return false;
        }
        try {
            StepOverRequest request = new StepOverRequest();
            this.connection.sendRequest(request, new ThisHandleResponse(responseHandler));
            return true;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean stepOver() {
        if (!this.isActive()) {
            return false;
        }
        try {
            StepOverRequest request = new StepOverRequest();
            StepOverResponse response = (StepOverResponse)this.connection.sendRequest(request);
            return response != null && response.getStatus() == 0;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean stepOut(Debugger.StepOutResponseHandler responseHandler) {
        if (!this.isActive()) {
            return false;
        }
        try {
            StepOutRequest request = new StepOutRequest();
            this.connection.sendRequest(request, new ThisHandleResponse(responseHandler));
            return true;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean stepOut() {
        if (!this.isActive()) {
            return false;
        }
        try {
            StepOutRequest request = new StepOutRequest();
            StepOutResponse response = (StepOutResponse)this.connection.sendRequest(request);
            return response != null && response.getStatus() == 0;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean go(Debugger.GoResponseHandler responseHandler) {
        if (!this.isActive()) {
            return false;
        }
        try {
            GoRequest request = new GoRequest();
            this.connection.sendRequest(request, new ThisHandleResponse(responseHandler));
            return true;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean go() {
        if (!this.isActive()) {
            return false;
        }
        try {
            GoRequest request = new GoRequest();
            GoResponse response = (GoResponse)this.connection.sendRequest(request);
            return response != null && response.getStatus() == 0;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean start(Debugger.StartResponseHandler responseHandler) {
        if (!this.isActive()) {
            return false;
        }
        if (!this.detectProtocolID()) {
            return false;
        }
        try {
            this.debugHandler.getDebugTarget().installDeferredBreakpoints();
        }
        catch (CoreException coreException) {
            return false;
        }
        StartRequest request = new StartRequest();
        try {
            this.connection.sendRequest(request, new ThisHandleResponse(responseHandler));
            return true;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean start() {
        if (!this.isActive()) {
            return false;
        }
        if (!this.detectProtocolID()) {
            return false;
        }
        StartRequest request = new StartRequest();
        try {
            StartResponse response = (StartResponse)this.connection.sendRequest(request);
            return response != null && response.getStatus() == 0;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean addFiles(String[] paths, Debugger.AddFilesResponseHandler responseHandler) {
        if (!this.isActive()) {
            return false;
        }
        try {
            AddFilesRequest request = new AddFilesRequest();
            request.setPaths(paths);
            this.connection.sendRequest(request, new ThisHandleResponse(responseHandler));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean addFiles(String[] paths) {
        if (!this.isActive()) {
            return false;
        }
        try {
            AddFilesRequest request = new AddFilesRequest();
            request.setPaths(paths);
            AddFilesResponse response = (AddFilesResponse)this.connection.sendRequest(request);
            return response != null && response.getStatus() == 0;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
    }

    protected boolean detectProtocolID() {
        boolean isUseNewProtocol = false;
        try {
            ILaunchConfiguration config = this.getDebugHandler().getDebugTarget().getLaunch().getLaunchConfiguration();
            String debuggerId = config.getAttribute(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, "org.eclipse.php.debug.core.zendDebugger");
            if (debuggerId == "org.eclipse.php.debug.core.zendDebugger") {
                ZendDebuggerConfiguration debuggerConfiguration = (ZendDebuggerConfiguration)PHPDebuggersRegistry.getDebuggerConfiguration(debuggerId);
                isUseNewProtocol = debuggerConfiguration.isUseNewProtocol();
            }
        }
        catch (CoreException e) {
            PHPDebugPlugin.log(e);
        }
        if (isUseNewProtocol && this.setProtocol(2012121702)) {
            return true;
        }
        if (this.setProtocol(2006040705)) {
            return true;
        }
        if (this.setProtocol(2006040703)) {
            RemoteDebugger.warnOlderDebugVersion();
            return true;
        }
        if (this.setProtocol(2006040701)) {
            RemoteDebugger.warnOlderDebugVersion();
            return true;
        }
        this.getDebugHandler().wrongDebugServer();
        return false;
    }

    public static void warnOlderDebugVersion() {
        boolean dontShowWarning = PHPDebugPlugin.getDefault().getPluginPreferences().getBoolean("DontShowOlderDebuggerWarning");
        if (!dontShowWarning) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    OldDebuggerWarningDialog dialog = new OldDebuggerWarningDialog(Display.getDefault().getActiveShell());
                    dialog.open();
                }
            });
        }
    }

    @Override
    public boolean setProtocol(int protocolID) {
        int responceProtocolID;
        SetProtocolRequest request = new SetProtocolRequest();
        request.setProtocolID(protocolID);
        IDebugResponseMessage response = this.sendCustomRequest(request);
        if (response != null && response instanceof SetProtocolResponse && (responceProtocolID = ((SetProtocolResponse)response).getProtocolID()) == protocolID) {
            this.currentProtocolId = protocolID;
            return true;
        }
        return false;
    }

    @Override
    public int getCurrentProtocolID() {
        return this.currentProtocolId;
    }

    @Override
    public boolean pause(Debugger.PauseResponseHandler responseHandler) {
        if (!this.isActive()) {
            return false;
        }
        PauseDebuggerRequest request = new PauseDebuggerRequest();
        try {
            this.connection.sendRequest(request, new ThisHandleResponse(responseHandler));
            return true;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean pause() {
        if (!this.isActive()) {
            return false;
        }
        PauseDebuggerRequest request = new PauseDebuggerRequest();
        try {
            PauseDebuggerResponse response = (PauseDebuggerResponse)this.connection.sendRequest(request);
            return response != null && response.getStatus() == 0;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean eval(String commandString, Debugger.EvalResponseHandler responseHandler) {
        if (!this.isActive()) {
            return false;
        }
        EvalRequest request = new EvalRequest();
        request.setCommand(commandString);
        try {
            this.connection.sendRequest(request, new ThisHandleResponse(responseHandler));
            return true;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean assignValue(String var, String value, int depth, String[] path, Debugger.AssignValueResponseHandler responseHandler) {
        if (!this.isActive()) {
            return false;
        }
        AssignValueRequest request = new AssignValueRequest();
        request.setVar(var);
        request.setValue(value);
        request.setDepth(depth);
        request.setPath(path);
        request.setTransferEncoding(this.getTransferEncoding());
        try {
            this.connection.sendRequest(request, new ThisHandleResponse(responseHandler));
            return true;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
    }

    private String getTransferEncoding() {
        IProject project = this.debugHandler.getDebugTarget().getProject();
        return project == null ? null : PHPProjectPreferences.getTransferEncoding(project);
    }

    @Override
    public boolean assignValue(String var, String value, int depth, String[] path) {
        if (!this.isActive()) {
            return false;
        }
        AssignValueRequest request = new AssignValueRequest();
        request.setVar(var);
        request.setValue(value);
        request.setDepth(depth);
        request.setPath(path);
        request.setTransferEncoding(this.getTransferEncoding());
        try {
            this.connection.sendRequest(request);
            return true;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
    }

    @Override
    public String eval(String commandString) {
        if (!this.isActive()) {
            return null;
        }
        EvalRequest request = new EvalRequest();
        request.setCommand(commandString);
        try {
            EvalResponse response = (EvalResponse)this.connection.sendRequest(request);
            String result = null;
            if (response != null) {
                result = response.getStatus() == 0 ? response.getResult() : "---ERROR---";
            }
            return result;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    @Override
    public void finish() {
        this.connection.closeConnection();
    }

    @Override
    public boolean isActive() {
        return this.connection != null && this.connection.isConnected();
    }

    @Override
    public boolean getVariableValue(String var, int depth, String[] path, Debugger.VariableValueResponseHandler responseHandler) {
        if (!this.isActive()) {
            return false;
        }
        GetVariableValueRequest request = new GetVariableValueRequest();
        request.setVar(var);
        request.setDepth(depth);
        request.setPath(path);
        try {
            this.connection.sendRequest(request, new ThisHandleResponse(responseHandler));
            return true;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
    }

    @Override
    public byte[] getVariableValue(String var, int depth, String[] path) throws IllegalArgumentException {
        if (!this.isActive()) {
            return null;
        }
        GetVariableValueRequest request = new GetVariableValueRequest();
        request.setVar(var);
        request.setDepth(depth);
        request.setPath(path);
        GetVariableValueResponse response = null;
        try {
            response = (GetVariableValueResponse)this.connection.sendRequest(request);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        if (response == null || response.getStatus() != 0) {
            return null;
        }
        return response.getVarResult();
    }

    @Override
    public boolean getCallStack(Debugger.GetCallStackResponseHandler responseHandler) {
        if (!this.isActive()) {
            return false;
        }
        GetCallStackRequest request = new GetCallStackRequest();
        try {
            this.connection.sendRequest(request, new ThisHandleResponse(responseHandler));
            return true;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
    }

    @Override
    public PHPstack getCallStack() {
        if (!this.isActive()) {
            return null;
        }
        PHPDebugTarget debugTarget = this.getDebugHandler().getDebugTarget();
        int suspendCount = debugTarget.getSuspendCount();
        if (suspendCount == this.previousSuspendCount && this.cachedStack != null) {
            return this.cachedStack;
        }
        GetCallStackRequest request = new GetCallStackRequest();
        PHPstack remoteStack = null;
        try {
            GetCallStackResponse response = (GetCallStackResponse)this.connection.sendRequest(request);
            if (response != null) {
                remoteStack = response.getPHPstack();
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        this.convertToSystem(remoteStack);
        this.previousSuspendCount = suspendCount;
        this.cachedStack = remoteStack;
        return remoteStack;
    }

    private void convertToSystem(PHPstack remoteStack) {
        if (remoteStack != null) {
            String currentWorkingDir = this.getCurrentWorkingDirectory();
            int i = 0;
            while (i < remoteStack.getSize()) {
                StackLayer layer = remoteStack.getLayer(i);
                layer.setCallerLineNumber(layer.getCallerLineNumber() - 1);
                layer.setCalledLineNumber(layer.getCalledLineNumber() - 1);
                layer.setResolvedCalledFileName(layer.getCalledFileName());
                if (i > 0) {
                    String previousScript = remoteStack.getLayer(i - 1).getResolvedCalledFileName();
                    String previousScriptDir = ".";
                    int idx = Math.max(previousScript.lastIndexOf(47), previousScript.lastIndexOf(92));
                    if (idx != -1) {
                        previousScriptDir = previousScript.substring(0, idx);
                    }
                    IProject project = null;
                    IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(previousScript);
                    project = resource != null ? resource.getProject() : this.debugHandler.getDebugTarget().getProject();
                    if (layer.getCalledFileName() != null && currentWorkingDir != null && project != null) {
                        PHPSearchEngine.Result result = PHPSearchEngine.find((String)layer.getCalledFileName(), (String)currentWorkingDir, (String)previousScriptDir, (IProject)project);
                        if (result instanceof PHPSearchEngine.ResourceResult) {
                            layer.setResolvedCalledFileName(((IFile)((PHPSearchEngine.ResourceResult)result).getFile()).getFullPath().toString());
                        } else if (result instanceof PHPSearchEngine.IncludedFileResult) {
                            layer.setResolvedCalledFileName(((File)((PHPSearchEngine.IncludedFileResult)result).getFile()).getAbsolutePath());
                        } else if (result instanceof PHPSearchEngine.ExternalFileResult) {
                            layer.setResolvedCalledFileName(((File)((PHPSearchEngine.ExternalFileResult)result).getFile()).getAbsolutePath());
                        }
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public boolean getStackVariableValue(int stackDepth, String value, int depth, String[] path, Debugger.GetStackVariableValueResponseHandler responseHandler) {
        if (!this.isActive()) {
            return false;
        }
        GetStackVariableValueRequest request = new GetStackVariableValueRequest();
        request.setVar(value);
        request.setDepth(depth);
        request.setLayerDepth(stackDepth);
        request.setPath(path);
        try {
            this.connection.sendRequest(request, new ThisHandleResponse(responseHandler));
            return true;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
    }

    @Override
    public byte[] getStackVariableValue(int stackDepth, String value, int depth, String[] path) {
        if (!this.isActive()) {
            return null;
        }
        GetStackVariableValueRequest request = new GetStackVariableValueRequest();
        request.setVar(value);
        request.setDepth(depth);
        request.setLayerDepth(stackDepth);
        request.setPath(path);
        GetStackVariableValueResponse response = null;
        try {
            response = (GetStackVariableValueResponse)this.connection.sendRequest(request);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        if (response == null || response.getStatus() != 0) {
            return null;
        }
        return response.getVarResult();
    }

    private String tryGuessMapping(String remoteFile, PHPDebugTarget debugTarget) throws ModelException {
        IProject project = debugTarget.getProject();
        if (project == null) {
            String orginalURL = debugTarget.getLaunch().getAttribute("uriginalURL");
            String projectName = new Path(orginalURL).segment(0);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            project = workspace.getRoot().getProject(projectName);
        }
        if (project != null) {
            String projectName = project.getName();
            Path remotePath = new Path(remoteFile);
            int size = remotePath.segmentCount();
            int j = 0;
            while (j < size) {
                String segment = remotePath.segment(j);
                if (segment.equals(projectName)) {
                    remotePath = remotePath.removeFirstSegments(j);
                    size = remotePath.segmentCount();
                    int i = 0;
                    while (i < size) {
                        IFile res;
                        if ((remotePath = remotePath.removeFirstSegments(1)).segmentCount() > 0 && (res = project.getFile((IPath)remotePath)) != null && res.exists()) {
                            return project.getFullPath().append((IPath)remotePath).toString();
                        }
                        ++i;
                    }
                    List<IPath> includePaths = this.getIncludePaths(project);
                    if (includePaths.size() <= 0) break;
                    return this.checkIncludePaths(remoteFile, includePaths);
                }
                ++j;
            }
        }
        return remoteFile;
    }

    private String checkIncludePaths(String remoteFile, List<IPath> includePaths) {
        Path remotePath = new Path(remoteFile);
        int size = remotePath.segmentCount();
        int i = 0;
        while (i < size) {
            if (remotePath.segmentCount() > 0) {
                for (IPath includePath : includePaths) {
                    File file = includePath.append((IPath)remotePath).toFile();
                    if (!file.exists()) continue;
                    return file.toString();
                }
                remotePath = remotePath.removeFirstSegments(1);
            }
            ++i;
        }
        return remoteFile;
    }

    public List<IPath> getIncludePaths(IProject project) throws ModelException {
        IncludePath[] paths;
        List<IPath> includePaths = this.resolvedIncludePaths.get(project.getName());
        if (includePaths != null) {
            return includePaths;
        }
        includePaths = new ArrayList<IPath>();
        IncludePath[] includePathArray = paths = IncludePathManager.getInstance().getIncludePaths(project);
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildpathContainer buildpathContainer;
            IBuildpathEntry bPath;
            IncludePath includePath = includePathArray[n2];
            if (includePath.getEntry() instanceof IBuildpathEntry && (bPath = (IBuildpathEntry)includePath.getEntry()).getEntryKind() == 5 && !bPath.getPath().toString().equals("org.eclipse.php.core.LANGUAGE") && (buildpathContainer = DLTKCore.getBuildpathContainer((IPath)bPath.getPath(), (IScriptProject)DLTKCore.create((IProject)project))) != null) {
                IBuildpathEntry[] buildpathEntries;
                IBuildpathEntry[] iBuildpathEntryArray = buildpathEntries = buildpathContainer.getBuildpathEntries();
                int n3 = buildpathEntries.length;
                int n4 = 0;
                while (n4 < n3) {
                    IBuildpathEntry buildpathEntry = iBuildpathEntryArray[n4];
                    IPath localPath = EnvironmentPathUtils.getLocalPath((IPath)buildpathEntry.getPath());
                    includePaths.add(localPath);
                    ++n4;
                }
            }
            ++n2;
        }
        this.resolvedIncludePaths.put(project.getName(), includePaths);
        return includePaths;
    }

    private class ThisHandleResponse
    implements ResponseHandler {
        Object responseHandler;

        public ThisHandleResponse(Object responseHandler) {
            this.responseHandler = responseHandler;
        }

        public void handleResponse(Object request, Object response) {
            boolean success;
            boolean bl = success = response != null && ((IDebugResponseMessage)response).getStatus() == 0;
            if (request instanceof AddBreakpointRequest) {
                AddBreakpointRequest addBreakpointRequest = (AddBreakpointRequest)request;
                Breakpoint bp = addBreakpointRequest.getBreakpoint();
                String fileName = bp.getFileName();
                int lineNumber = bp.getLineNumber();
                int id = -1;
                if (response != null) {
                    id = ((AddBreakpointResponse)response).getBreakpointID();
                }
                ((Debugger.BreakpointAddedResponseHandler)this.responseHandler).breakpointAdded(fileName, lineNumber, id, success);
            } else if (request instanceof CancelBreakpointRequest) {
                ((Debugger.BreakpointRemovedResponseHandler)this.responseHandler).breakpointRemoved(((CancelBreakpointRequest)request).getBreakpointID(), success);
            } else if (request instanceof CancelAllBreakpointsRequest) {
                ((Debugger.AllBreakpointRemovedResponseHandler)this.responseHandler).allBreakpointRemoved(success);
            } else if (request instanceof StartRequest) {
                ((Debugger.StartResponseHandler)this.responseHandler).started(success);
            } else if (request instanceof EvalRequest) {
                ((Debugger.EvalResponseHandler)this.responseHandler).evaled(((EvalRequest)request).getCommand(), success ? ((EvalResponse)response).getResult() : null, success);
            } else if (request instanceof StepIntoRequest) {
                ((Debugger.StepIntoResponseHandler)this.responseHandler).stepInto(success);
            } else if (request instanceof StepOverRequest) {
                ((Debugger.StepOverResponseHandler)this.responseHandler).stepOver(success);
            } else if (request instanceof StepOutRequest) {
                ((Debugger.StepOutResponseHandler)this.responseHandler).stepOut(success);
            } else if (request instanceof GoRequest) {
                ((Debugger.GoResponseHandler)this.responseHandler).go(success);
            } else if (request instanceof PauseDebuggerRequest) {
                ((Debugger.PauseResponseHandler)this.responseHandler).pause(success);
            } else if (request instanceof AssignValueRequest) {
                AssignValueRequest assignValueRequest = (AssignValueRequest)request;
                String var = assignValueRequest.getVar();
                String value = assignValueRequest.getValue();
                int depth = assignValueRequest.getDepth();
                String[] path = assignValueRequest.getPath();
                ((Debugger.AssignValueResponseHandler)this.responseHandler).valueAssigned(var, value, depth, path, success);
            } else if (request instanceof GetVariableValueRequest) {
                GetVariableValueRequest getVariableValueRequest = (GetVariableValueRequest)request;
                String value = getVariableValueRequest.getVar();
                int depth = getVariableValueRequest.getDepth();
                String[] path = getVariableValueRequest.getPath();
                String result = null;
                if (response != null) {
                    try {
                        result = new String(((GetVariableValueResponse)response).getVarResult(), ((IDebugMessage)response).getTransferEncoding());
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                }
                ((Debugger.VariableValueResponseHandler)this.responseHandler).variableValue(value, depth, path, result, success);
            } else if (request instanceof GetCallStackRequest) {
                PHPstack remoteStack = null;
                if (response != null) {
                    remoteStack = ((GetCallStackResponse)response).getPHPstack();
                }
                RemoteDebugger.this.convertToSystem(remoteStack);
                ((Debugger.GetCallStackResponseHandler)this.responseHandler).callStack(remoteStack, success);
            } else if (request instanceof GetStackVariableValueRequest) {
                GetStackVariableValueRequest getStackVariableValueRequest = (GetStackVariableValueRequest)request;
                int stackDepth = getStackVariableValueRequest.getLayerDepth();
                String value = getStackVariableValueRequest.getVar();
                int depth = getStackVariableValueRequest.getDepth();
                String[] path = getStackVariableValueRequest.getPath();
                String result = null;
                if (response != null) {
                    try {
                        result = new String(((GetStackVariableValueResponse)response).getVarResult(), ((IDebugMessage)response).getTransferEncoding());
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                }
                ((Debugger.GetStackVariableValueResponseHandler)this.responseHandler).stackVariableValue(stackDepth, value, depth, path, result, success);
            }
        }
    }
}

