/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.contentassist;

import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.internal.core.ArchiveProjectFragment;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.text.completion.CompletionProposalLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.codeassist.AliasType;
import org.eclipse.php.internal.core.typeinference.FakeConstructor;
import org.eclipse.php.internal.ui.util.PHPPluginImages;

public class PHPCompletionProposalLabelProvider
extends CompletionProposalLabelProvider {
    private static final String ENCLOSING_TYPE_SEPARATOR = new String(new char[]{'\\'});

    protected String createMethodProposalLabel(CompletionProposal methodProposal) {
        StringBuffer nameBuffer = new StringBuffer();
        nameBuffer.append(methodProposal.getName());
        nameBuffer.append('(');
        this.appendParameterList(nameBuffer, methodProposal);
        nameBuffer.append(')');
        IMethod method = (IMethod)methodProposal.getModelElement();
        nameBuffer.append(" - ");
        IModelElement parent = method.getParent();
        if (parent instanceof IType) {
            IType type = (IType)parent;
            nameBuffer.append(type.getTypeQualifiedName(ENCLOSING_TYPE_SEPARATOR));
        } else {
            nameBuffer.append(parent.getElementName());
        }
        return nameBuffer.toString();
    }

    protected String createOverrideMethodProposalLabel(CompletionProposal methodProposal) {
        IType type;
        StringBuffer nameBuffer = new StringBuffer();
        IMethod method = (IMethod)methodProposal.getModelElement();
        if (method instanceof FakeConstructor && (type = (IType)method.getParent()) instanceof AliasType) {
            AliasType aliasType = (AliasType)type;
            nameBuffer.append(aliasType.getAlias());
            nameBuffer.append("()");
            return nameBuffer.toString();
        }
        nameBuffer.append(methodProposal.getName());
        nameBuffer.append('(');
        this.appendParameterList(nameBuffer, methodProposal);
        nameBuffer.append(')');
        nameBuffer.append(" - ");
        IModelElement parent = method.getParent();
        if (parent instanceof IType) {
            IType type2 = (IType)parent;
            nameBuffer.append(type2.getTypeQualifiedName(ENCLOSING_TYPE_SEPARATOR));
        } else {
            nameBuffer.append(parent.getElementName());
        }
        return nameBuffer.toString();
    }

    public String createTypeProposalLabel(CompletionProposal typeProposal) {
        StringBuffer nameBuffer = new StringBuffer();
        IType type = (IType)typeProposal.getModelElement();
        if (type instanceof AliasType) {
            AliasType aliasType = (AliasType)type;
            nameBuffer.append(aliasType.getAlias());
            return nameBuffer.toString();
        }
        nameBuffer.append(typeProposal.getName());
        if (type.getParent() != null) {
            nameBuffer.append(" - ");
            IModelElement parent = type.getParent();
            nameBuffer.append(parent.getElementName());
        }
        return nameBuffer.toString();
    }

    protected String createLabelWithTypeAndDeclaration(CompletionProposal proposal) {
        StringBuffer nameBuffer = new StringBuffer();
        nameBuffer.append(proposal.getName());
        IField field = (IField)proposal.getModelElement();
        if (field.getParent() != null) {
            nameBuffer.append(" - ");
            IModelElement parent = field.getParent();
            nameBuffer.append(parent.getElementName());
        }
        return nameBuffer.toString();
    }

    protected String createTypeProposalLabel(String fullName) {
        return super.createTypeProposalLabel(fullName);
    }

    public ImageDescriptor createImageDescriptor(CompletionProposal proposal) {
        if (proposal.getModelElement() instanceof ArchiveProjectFragment) {
            return DLTKPluginImages.DESC_OBJS_JAR;
        }
        return super.createImageDescriptor(proposal);
    }

    public ImageDescriptor createTypeImageDescriptor(CompletionProposal proposal) {
        if (PHPFlags.isTrait((int)proposal.getFlags())) {
            return this.decorateImageDescriptor(PHPPluginImages.DESC_OBJS_TRAIT, proposal);
        }
        return super.createTypeImageDescriptor(proposal);
    }

    public String createFieldProposalLabel(CompletionProposal proposal) {
        return super.createFieldProposalLabel(proposal);
    }

    public ImageDescriptor createFieldImageDescriptor(CompletionProposal proposal) {
        return super.createFieldImageDescriptor(proposal);
    }
}

