/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.breakpoint;

import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.debug.core.model.IPBreakpoint;
import org.eclipse.ptp.internal.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.internal.debug.core.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PBreakpoint
extends Breakpoint
implements IPBreakpoint {
    private String fJobId = "";
    private String fSetId = "";

    public PBreakpoint() {
    }

    public PBreakpoint(final IResource resource, final String markerType, final Map<String, ? extends Object> attributes, String jobId, String setId, final boolean add) throws CoreException {
        this();
        this.fJobId = jobId;
        this.fSetId = setId;
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                PBreakpoint.this.setMarker(resource.createMarker(markerType));
                PBreakpoint.this.ensureMarker().setAttributes(attributes);
                PBreakpoint.this.setAttribute("message", PBreakpoint.this.getMarkerMessage());
                PBreakpoint.this.register(add);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(wr, null);
        }
        catch (CoreException e) {
            throw new DebugException(e.getStatus());
        }
    }

    @Override
    public synchronized int decrementInstallCount() throws CoreException {
        int count = this.getInstallCount();
        if (count > 0) {
            this.setAttribute("org.eclipse.ptp.debug.core.installCount", --count);
        }
        return count;
    }

    public void fireChanged() {
        if (this.markerExists()) {
            DebugPlugin.getDefault().getBreakpointManager().fireBreakpointChanged((IBreakpoint)this);
        }
    }

    @Override
    public String getCondition() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.ptp.debug.core.condition", "");
    }

    @Override
    public String getCurSetId() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.ptp.debug.core.cursetid", "");
    }

    @Override
    public int getIgnoreCount() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.ptp.debug.core.ignoreCount", 0);
    }

    public int getInstallCount() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.ptp.debug.core.installCount", 0);
    }

    @Override
    public String getJobId() throws CoreException {
        return this.fJobId;
    }

    @Override
    public String getJobName() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.ptp.debug.core.jobname", "");
    }

    public String getJobSetFormat() throws CoreException {
        return "{" + this.getJobName() + ":" + this.getSetId() + "}";
    }

    public String getModelIdentifier() {
        return PTPDebugCorePlugin.getUniqueIdentifier();
    }

    @Override
    public String getSetId() throws CoreException {
        return this.fSetId;
    }

    @Override
    public String getSourceHandle() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.ptp.debug.core.sourceHandle", "");
    }

    @Override
    public synchronized int incrementInstallCount() throws CoreException {
        int count = this.getInstallCount();
        this.setAttribute("org.eclipse.ptp.debug.core.installCount", ++count);
        return count;
    }

    @Override
    public boolean isConditional() throws CoreException {
        return this.getCondition() != null && this.getCondition().trim().length() > 0 || this.getIgnoreCount() > 0;
    }

    @Override
    public boolean isGlobal() throws CoreException {
        return this.getJobId().equals(IPBreakpoint.GLOBAL);
    }

    @Override
    public boolean isInstalled() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.ptp.debug.core.installCount", 0) > 0;
    }

    public void register(boolean register) throws CoreException {
        if (register) {
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)this);
        }
    }

    @Override
    public synchronized void resetInstallCount() throws CoreException {
        this.setAttribute("org.eclipse.ptp.debug.core.installCount", 0);
    }

    @Override
    public void setCondition(String condition) throws CoreException {
        this.setAttribute("org.eclipse.ptp.debug.core.condition", condition);
        this.setAttribute("message", this.getMarkerMessage());
    }

    @Override
    public void setCurSetId(String id) throws CoreException {
        this.setAttribute("org.eclipse.ptp.debug.core.cursetid", id);
    }

    @Override
    public void setIgnoreCount(int ignoreCount) throws CoreException {
        this.setAttribute("org.eclipse.ptp.debug.core.ignoreCount", ignoreCount);
        this.setAttribute("message", this.getMarkerMessage());
    }

    @Override
    public void setJobId(String id) throws CoreException {
        this.fJobId = id;
    }

    @Override
    public void setJobName(String name) throws CoreException {
        this.setAttribute("org.eclipse.ptp.debug.core.jobname", name);
    }

    @Override
    public void setSetId(String id) throws CoreException {
        this.fSetId = id;
    }

    @Override
    public void setSourceHandle(String sourceHandle) throws CoreException {
        this.setAttribute("org.eclipse.ptp.debug.core.sourceHandle", sourceHandle);
    }

    @Override
    public void updateMarkerMessage() throws CoreException {
        this.setAttribute("message", this.getMarkerMessage());
    }

    protected String getConditionText() throws CoreException {
        String condition;
        StringBuffer sb = new StringBuffer();
        int ignoreCount = this.getIgnoreCount();
        if (ignoreCount > 0) {
            sb.append(NLS.bind((String)Messages.PBreakpoint_0, (Object[])new Object[]{new Integer(ignoreCount)}));
        }
        if ((condition = this.getCondition()) != null && condition.length() > 0) {
            sb.append(NLS.bind((String)Messages.PBreakpoint_10, (Object[])new Object[]{condition}));
        }
        return sb.toString();
    }

    protected abstract String getMarkerMessage() throws CoreException;
}

