/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.pdi.manager;

import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.manager.IPDITaskManager;
import org.eclipse.ptp.internal.debug.core.pdi.manager.AbstractPDIManager;

public class TaskManager
extends AbstractPDIManager
implements IPDITaskManager {
    private TaskSet terminatedTasks;
    private TaskSet suspendedTasks;
    private TaskSet registeredTasks;
    private TaskSet pendingTasks;
    private TaskSet canStepReturnTasks;

    public TaskManager(IPDISession session) {
        super(session, false);
        this.terminatedTasks = new TaskSet(session.getTotalTasks());
        this.suspendedTasks = new TaskSet(session.getTotalTasks());
        this.registeredTasks = new TaskSet(session.getTotalTasks());
        this.pendingTasks = new TaskSet(session.getTotalTasks());
        this.canStepReturnTasks = new TaskSet(session.getTotalTasks());
    }

    public boolean canAllStepReturn(TaskSet tasks) {
        return this.getCannotStepReturnTasks(tasks.copy()).isEmpty();
    }

    public TaskSet getCannotStepReturnTasks(TaskSet tasks) {
        tasks.andNot(this.getCanStepReturnTasks());
        return tasks;
    }

    public TaskSet getCanStepReturnTasks() {
        return this.canStepReturnTasks;
    }

    public TaskSet getCanStepReturnTasks(TaskSet tasks) {
        tasks.and(this.getCanStepReturnTasks());
        return tasks;
    }

    public TaskSet getNonPendingTasks(TaskSet tasks) {
        tasks.andNot(this.getPendingTasks());
        return tasks;
    }

    public TaskSet getNonRunningTasks(TaskSet tasks) {
        tasks.andNot(this.getRunningTasks(tasks.copy()));
        return tasks;
    }

    public TaskSet getNonSuspendedTasks(TaskSet tasks) {
        tasks.andNot(this.getSuspendedTasks());
        return tasks;
    }

    public TaskSet getNonTerminatedTasks(TaskSet tasks) {
        tasks.andNot(this.getTerminatedTasks());
        return tasks;
    }

    public TaskSet getPendingTasks() {
        return this.pendingTasks;
    }

    public TaskSet getPendingTasks(TaskSet tasks) {
        tasks.and(this.getPendingTasks());
        return tasks;
    }

    public TaskSet getRegisteredTasks() {
        return this.registeredTasks;
    }

    public TaskSet getRegisteredTasks(TaskSet tasks) {
        tasks.and(this.getRegisteredTasks());
        return tasks;
    }

    public TaskSet getRunningTasks(TaskSet tasks) {
        tasks.andNot(this.getTerminatedTasks());
        tasks.andNot(this.getSuspendedTasks());
        return tasks;
    }

    public TaskSet getSuspendedTasks() {
        return this.suspendedTasks;
    }

    public TaskSet getSuspendedTasks(TaskSet tasks) {
        tasks.and(this.getSuspendedTasks());
        return tasks;
    }

    public TaskSet getTerminatedTasks() {
        return this.terminatedTasks;
    }

    public TaskSet getTerminatedTasks(TaskSet tasks) {
        tasks.and(this.getTerminatedTasks());
        return tasks;
    }

    public TaskSet getUnregisteredTasks(TaskSet tasks) {
        tasks.andNot(this.getRegisteredTasks());
        return tasks;
    }

    public boolean isAllPending(TaskSet tasks) {
        return this.getNonPendingTasks(tasks.copy()).isEmpty();
    }

    public boolean isAllRegistered(TaskSet tasks) {
        return this.getUnregisteredTasks(tasks.copy()).isEmpty();
    }

    public boolean isAllRunning(TaskSet tasks) {
        return !this.isAllSuspended(tasks) && !this.isAllTerminated(tasks);
    }

    public boolean isAllSuspended(TaskSet tasks) {
        return this.getNonSuspendedTasks(tasks.copy()).isEmpty();
    }

    public boolean isAllTerminated(TaskSet tasks) {
        return this.getNonTerminatedTasks(tasks.copy()).isEmpty();
    }

    public void setCanStepReturnTasks(boolean isAdd, TaskSet tasks) {
        if (isAdd) {
            this.canStepReturnTasks = this.addTasks(this.canStepReturnTasks, tasks);
        } else {
            this.removeTasks(this.canStepReturnTasks, tasks);
        }
    }

    public void setPendingTasks(boolean isAdd, TaskSet tasks) {
        if (isAdd) {
            this.pendingTasks = this.addTasks(this.pendingTasks, tasks);
        } else {
            this.removeTasks(this.pendingTasks, tasks);
        }
    }

    public void setRegisterTasks(boolean isAdd, TaskSet tasks) {
        if (isAdd) {
            this.registeredTasks = this.addTasks(this.registeredTasks, tasks);
        } else {
            this.removeTasks(this.registeredTasks, tasks);
        }
    }

    public void setSuspendTasks(boolean isAdd, TaskSet tasks) {
        if (isAdd) {
            this.suspendedTasks = this.addTasks(this.suspendedTasks, tasks);
        } else {
            this.removeTasks(this.suspendedTasks, tasks);
            this.setCanStepReturnTasks(false, tasks);
        }
    }

    public void setTerminateTasks(boolean isAdd, TaskSet tasks) {
        if (isAdd) {
            this.terminatedTasks = this.addTasks(this.terminatedTasks, tasks);
            this.setSuspendTasks(false, tasks);
        } else {
            this.removeTasks(this.terminatedTasks, tasks);
        }
    }

    public void shutdown() {
    }

    public void update(TaskSet tasks) throws PDIException {
    }

    private synchronized TaskSet addTasks(TaskSet curTasks, TaskSet newTasks) {
        if (curTasks.taskSize() < newTasks.taskSize()) {
            newTasks.or(curTasks);
            curTasks = newTasks.copy();
        }
        curTasks.or(newTasks);
        return curTasks;
    }

    private synchronized void removeTasks(TaskSet curTasks, TaskSet newTasks) {
        curTasks.andNot(newTasks);
    }
}

