/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.pdi.model;

import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.model.IPDIExpression;
import org.eclipse.ptp.debug.core.pdi.model.IPDIStackFrame;
import org.eclipse.ptp.debug.core.pdi.model.IPDITargetExpression;
import org.eclipse.ptp.debug.core.pdi.model.IPDIVariable;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIF;
import org.eclipse.ptp.internal.debug.core.pdi.SessionObject;
import org.eclipse.ptp.internal.debug.core.pdi.messages.Messages;

public class Expression
extends SessionObject
implements IPDITargetExpression {
    private static int ID_COUNT = 0;
    private final int id;
    private final String fExpression;
    private IPDIVariable variable = null;

    public Expression(IPDISession session, TaskSet tasks, String ex) {
        super(session, tasks);
        this.fExpression = ex;
        this.id = ++ID_COUNT;
    }

    public void dispose() throws PDIException {
        this.session.getExpressionManager().destroyExpressions(this.getTasks(), new Expression[]{this});
        if (this.variable != null) {
            this.session.getExpressionManager().deleteVariable(this.variable);
        }
    }

    public boolean equals(IPDIExpression obj) {
        if (obj instanceof Expression) {
            Expression other = (Expression)obj;
            return other.id == this.id;
        }
        return false;
    }

    public IAIF getAIF() throws PDIException {
        if (this.variable == null) {
            return null;
        }
        return this.variable.getAIF();
    }

    public String getExpressionText() {
        return this.fExpression;
    }

    public IPDIVariable getVariable(IPDIStackFrame context) throws PDIException {
        IPDIVariable var = this.session.getExpressionManager().createVariable(context, this.getExpressionText());
        if (var == null) {
            throw new PDIException(context.getTasks(), Messages.Expression_0);
        }
        this.variable = var;
        return var;
    }

    public void setAIF(IAIF aif) {
        if (this.variable != null) {
            this.variable.setAIF(aif);
        }
    }
}

