/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.pdi.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.model.IPDIExpression;
import org.eclipse.ptp.debug.core.pdi.model.IPDIMultiExpressions;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIF;
import org.eclipse.ptp.debug.core.pdi.request.IPDIEvaluateExpressionRequest;
import org.eclipse.ptp.internal.debug.core.pdi.SessionObject;
import org.eclipse.ptp.internal.debug.core.pdi.messages.Messages;
import org.eclipse.ptp.internal.debug.core.pdi.model.aif.AIFFactory;

public class MultiExpressions
extends SessionObject
implements IPDIMultiExpressions {
    private final String expr;
    private boolean enabled;
    private final Map<Integer, IPDIExpression> expressions = new HashMap<Integer, IPDIExpression>();

    public MultiExpressions(IPDISession session, TaskSet tasks, String ex, boolean enabled) {
        super(session, tasks);
        this.expr = ex;
        this.enabled = enabled;
        this.initital();
    }

    public void addExpression(IPDIExpression expression) {
        if (expression instanceof MExpression) {
            Integer id = new Integer(((MExpression)expression).getId());
            this.expressions.put(id, expression);
        }
    }

    public void cleanExpressionsValue(TaskSet tasks, IProgressMonitor monitor) {
        monitor.setTaskName(NLS.bind((String)Messages.MultiExpressions_0, (Object)this.expr));
        int[] nArray = tasks.toArray();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int task = nArray[n2];
            IPDIExpression expression = this.getExpression(task);
            if (expression != null) {
                expression.setAIF(null);
            }
            monitor.worked(1);
            ++n2;
        }
    }

    public IAIF getAIF(IPDIExpression expression) throws PDIException {
        return expression.getAIF();
    }

    public IPDIExpression getExpression(int task) {
        return this.expressions.get(new Integer(task));
    }

    public IPDIExpression[] getExpressions() {
        return this.expressions.values().toArray(new IPDIExpression[0]);
    }

    public String getExpressionText() {
        return this.expr;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void removeExpression(TaskSet tasks) {
        int[] nArray = tasks.toArray();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int task = nArray[n2];
            this.expressions.remove(new Integer(task));
            ++n2;
        }
    }

    public void removeExpression(IPDIExpression expression) {
        if (expression instanceof MExpression) {
            Integer id = new Integer(((MExpression)expression).getId());
            this.expressions.remove(id);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void shutdown() {
        this.expressions.clear();
    }

    public void updateExpressionsValue(TaskSet tasks, IProgressMonitor monitor) throws PDIException {
        monitor.setTaskName(NLS.bind((String)Messages.MultiExpressions_1, (Object)this.expr));
        IPDIEvaluateExpressionRequest request = this.session.getRequestFactory().getEvaluateExpressionRequest(tasks, this.expr);
        this.session.getEventRequestManager().addEventRequest(request);
        Map<TaskSet, Object> results = request.getResultMap(tasks);
        for (TaskSet sTasks : results.keySet()) {
            int n;
            Object obj = results.get(sTasks);
            if (!(obj instanceof IAIF)) {
                int[] nArray = sTasks.toArray();
                n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int task = nArray[n2];
                    IPDIExpression expression = this.getExpression(task);
                    if (expression != null) {
                        expression.setAIF(AIFFactory.UNKNOWNAIF());
                    }
                    ++n2;
                }
                continue;
            }
            IAIF aif = (IAIF)obj;
            int[] nArray = sTasks.toArray();
            int n3 = nArray.length;
            n = 0;
            while (n < n3) {
                int task = nArray[n];
                IPDIExpression expression = this.getExpression(task);
                if (expression != null) {
                    if (monitor.isCanceled()) {
                        expression.setAIF(AIFFactory.UNKNOWNAIF());
                        throw new PDIException(tasks, Messages.MultiExpressions_2);
                    }
                    expression.setAIF(aif);
                    monitor.worked(1);
                }
                ++n;
            }
        }
    }

    private void initital() {
        int[] nArray = this.getTasks().toArray();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int task = nArray[n2];
            this.addExpression(new MExpression(task));
            ++n2;
        }
    }

    class MExpression
    implements IPDIExpression {
        private final int id;
        private IAIF aif;

        public MExpression(int id) {
            this.id = id;
        }

        public void dispose() throws PDIException {
            this.aif = null;
        }

        public boolean equals(IPDIExpression expr) {
            if (expr instanceof MExpression) {
                return ((MExpression)expr).getId() == this.id;
            }
            return false;
        }

        public IAIF getAIF() throws PDIException {
            return this.aif;
        }

        public String getExpressionText() {
            return MultiExpressions.this.expr;
        }

        public int getId() {
            return this.id;
        }

        public void setAIF(IAIF aif) {
            this.aif = aif;
        }
    }
}

