/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.sourcelookup;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.containers.DirectorySourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.FolderSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.WorkspaceSourceContainer;
import org.eclipse.ptp.debug.core.model.IPBreakpoint;
import org.eclipse.ptp.internal.debug.core.sourcelookup.IPSourceLookupDirector;
import org.eclipse.ptp.internal.debug.core.sourcelookup.PSourceLookupParticipant;
import org.eclipse.ptp.internal.debug.core.sourcelookup.ResourceMappingSourceContainer;

public class PSourceLookupDirector
extends AbstractSourceLookupDirector
implements IPSourceLookupDirector {
    private static Set<String> fSupportedTypes = new HashSet<String>();

    static {
        fSupportedTypes.add(WorkspaceSourceContainer.TYPE_ID);
        fSupportedTypes.add(ProjectSourceContainer.TYPE_ID);
        fSupportedTypes.add(FolderSourceContainer.TYPE_ID);
        fSupportedTypes.add(DirectorySourceContainer.TYPE_ID);
        fSupportedTypes.add(ResourceMappingSourceContainer.TYPE_ID);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean contains(IPBreakpoint breakpoint) {
        try {
            String handle = breakpoint.getSourceHandle();
            ISourceContainer[] iSourceContainerArray = this.getSourceContainers();
            int n = iSourceContainerArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                ISourceContainer container = iSourceContainerArray[n2];
                if (this.contains(container, handle)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public boolean contains(IProject project) {
        ISourceContainer[] iSourceContainerArray = this.getSourceContainers();
        int n = iSourceContainerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceContainer container = iSourceContainerArray[n2];
            if (this.contains(container, project)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public IPath getCompilationPath(String sourceName) {
        IPath path = null;
        ISourceContainer[] iSourceContainerArray = this.getSourceContainers();
        int n = iSourceContainerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceContainer container = iSourceContainerArray[n2];
            IPath cp = this.getCompilationPath(container, sourceName);
            if (cp != null) {
                path = cp;
                break;
            }
            ++n2;
        }
        return path;
    }

    public void initializeParticipants() {
        this.addParticipants(new ISourceLookupParticipant[]{new PSourceLookupParticipant()});
    }

    public boolean supportsSourceContainerType(ISourceContainerType type) {
        return fSupportedTypes.contains(type.getId());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean contains(ISourceContainer container, IProject project) {
        if (container instanceof ProjectSourceContainer && ((ProjectSourceContainer)container).getProject().equals((Object)project)) {
            return true;
        }
        try {
            ISourceContainer[] iSourceContainerArray = container.getSourceContainers();
            int n = iSourceContainerArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                ISourceContainer child = iSourceContainerArray[n2];
                if (this.contains(child, project)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean contains(ISourceContainer container, String sourceName) {
        Path path = new Path(sourceName);
        if (!path.isValidPath(sourceName)) {
            return false;
        }
        if (container instanceof ProjectSourceContainer) {
            IProject project = ((ProjectSourceContainer)container).getProject();
            Path srcPath = new Path(sourceName);
            return project.exists((IPath)srcPath);
        }
        if (container instanceof FolderSourceContainer) {
            IContainer folder = ((FolderSourceContainer)container).getContainer();
            Path srcPath = new Path(sourceName);
            return folder.exists((IPath)srcPath);
        }
        if (container instanceof ResourceMappingSourceContainer) {
            if (((ResourceMappingSourceContainer)container).getCompilationPath(sourceName) == null) return false;
            return true;
        }
        try {
            ISourceContainer[] iSourceContainerArray = container.getSourceContainers();
            int n = iSourceContainerArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                ISourceContainer child = iSourceContainerArray[n2];
                if (this.contains(child, sourceName)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    private IPath getCompilationPath(ISourceContainer container, String sourceName) {
        IPath path = null;
        if (container instanceof ResourceMappingSourceContainer) {
            path = ((ResourceMappingSourceContainer)container).getCompilationPath(sourceName);
        } else {
            try {
                ISourceContainer[] iSourceContainerArray = container.getSourceContainers();
                int n = iSourceContainerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ISourceContainer child = iSourceContainerArray[n2];
                    path = this.getCompilationPath(child, sourceName);
                    if (path == null) {
                        ++n2;
                        continue;
                    }
                    break;
                }
            }
            catch (CoreException coreException) {}
        }
        return path;
    }
}

