/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.etfw;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.eclipse.cdt.utils.Platform;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ptp.core.util.LaunchUtils;
import org.eclipse.ptp.ems.core.EnvManagerConfigString;
import org.eclipse.ptp.ems.core.EnvManagerRegistry;
import org.eclipse.ptp.ems.core.IEnvManager;
import org.eclipse.ptp.ems.core.IEnvManagerConfig;
import org.eclipse.ptp.etfw.IBuildLaunchUtils;
import org.eclipse.ptp.etfw.toolopts.ExternalToolProcess;
import org.eclipse.ptp.internal.etfw.Activator;
import org.eclipse.ptp.internal.etfw.messages.Messages;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.RemoteServices;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.remote.ui.IRemoteUIFileManager;
import org.eclipse.ptp.remote.ui.IRemoteUIServices;
import org.eclipse.ptp.remote.ui.RemoteUIServices;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteBuildLaunchUtils
implements IBuildLaunchUtils {
    public static final String REMOTE_MAKE_BUILDER_ID = "org.eclipse.ptp.rdt.core.remoteMakeBuilder";
    private static final String EMPTY_STRING = "";
    Shell selshell = null;
    ILaunchConfiguration config;
    IRemoteConnection conn = null;
    IRemoteServices remoteServices = null;
    IRemoteUIServices remoteUIServices = null;
    IRemoteConnectionManager connMgr = null;
    IRemoteUIFileManager fileManagerUI = null;
    IRemoteFileManager fileManager = null;
    IEnvManagerConfig envMgrConfig = null;
    private IEnvManager envManager = null;

    public static String getNow() {
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss");
        sdf.setTimeZone(TimeZone.getDefault());
        return sdf.format(cal.getTime());
    }

    public RemoteBuildLaunchUtils(ILaunchConfiguration config) {
        this.config = config;
        this.remoteServices = RemoteServices.getRemoteServices((String)LaunchUtils.getRemoteServicesId((ILaunchConfiguration)config));
        this.remoteUIServices = RemoteUIServices.getRemoteUIServices((IRemoteServices)this.remoteServices);
        this.connMgr = this.remoteServices.getConnectionManager();
        this.conn = this.connMgr.getConnection(LaunchUtils.getConnectionName((ILaunchConfiguration)config));
        this.fileManagerUI = this.remoteUIServices.getUIFileManager();
        this.fileManagerUI.setConnection(this.conn);
        this.fileManager = this.remoteServices.getFileManager(this.conn);
        this.envMgrConfig = this.getEnvManagerConfig(config);
        if (this.envMgrConfig != null) {
            this.envManager = EnvManagerRegistry.getEnvManager(null, (IRemoteConnection)this.conn);
        }
    }

    public ILaunchConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(ILaunchConfiguration config) {
        this.config = config;
        this.envMgrConfig = this.getEnvManagerConfig(config);
        if (this.envMgrConfig != null) {
            this.envManager = EnvManagerRegistry.getEnvManager(null, (IRemoteConnection)this.conn);
        }
    }

    public RemoteBuildLaunchUtils(IRemoteConnection conn) {
        this.conn = conn;
        this.remoteServices = conn.getRemoteServices();
        this.remoteUIServices = RemoteUIServices.getRemoteUIServices((IRemoteServices)this.remoteServices);
        this.connMgr = this.remoteServices.getConnectionManager();
        this.fileManagerUI = this.remoteUIServices.getUIFileManager();
        this.fileManager = this.remoteServices.getFileManager(conn);
    }

    @Override
    public String askToolPath(String archpath, String toolName) {
        return this.askToolPath(archpath, String.valueOf(Messages.BuildLaunchUtils_Select) + toolName + Messages.BuildLaunchUtils_BinDir, String.valueOf(Messages.BuildLaunchUtils_PleaseSelectDir) + toolName);
    }

    @Override
    public String askToolPath(String archpath, String toolText, String toolMessage) {
        if (this.selshell == null || this.selshell.isDisposed()) {
            this.selshell = PlatformUI.getWorkbench().getDisplay().getShells()[0];
        }
        return this.fileManagerUI.browseDirectory(this.selshell, toolMessage, archpath, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String checkToolEnvPath(String toolname) {
        if (Platform.getOS().toLowerCase().trim().indexOf("win") >= 0 && !this.isRemote()) {
            return null;
        }
        String pPath = null;
        try {
            IRemoteProcessBuilder rpb = this.remoteServices.getProcessBuilder(this.conn, new String[0]);
            if (this.envManager != null) {
                String com = EMPTY_STRING;
                try {
                    com = this.envManager.createBashScript(null, false, this.envMgrConfig, "which " + toolname);
                    IFileStore envScript = this.fileManager.getResource(com);
                    IFileInfo envInfo = envScript.fetchInfo();
                    envInfo.setAttribute(0x1000000, true);
                    envInfo.setAttribute(4, true);
                    envScript.putInfo(envInfo, 1024, null);
                }
                catch (RemoteConnectionException e) {
                    e.printStackTrace();
                    return null;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                rpb.command(new String[]{com});
            } else {
                rpb.command(new String[]{"which", toolname});
            }
            IRemoteProcess p = rpb.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = null;
            while (true) {
                if ((line = reader.readLine()) == null) {
                    reader.close();
                    reader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                    while ((line = reader.readLine()) != null) {
                    }
                    break;
                }
                IFileStore test = this.fileManager.getResource(line);
                if (!test.fetchInfo().exists()) continue;
                pPath = line;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (pPath == null) {
            return null;
        }
        IFileStore test = this.fileManager.getResource(pPath);
        String name = test.fetchInfo().getName();
        if (!name.equals(toolname)) {
            return null;
        }
        if (test.fetchInfo().exists()) {
            return test.getParent().toURI().getPath();
        }
        return null;
    }

    @Override
    public String findToolBinPath(String toolfind, String suggPath, String toolName) {
        String vtbinpath = this.checkToolEnvPath(toolfind);
        if ((vtbinpath == null || vtbinpath.equals(EMPTY_STRING)) && (vtbinpath = this.askToolPath(suggPath, toolName)) == null) {
            vtbinpath = EMPTY_STRING;
        }
        return vtbinpath;
    }

    @Override
    public String findToolBinPath(String toolfind, String suggPath, String queryText, String queryMessage) {
        String vtbinpath = this.checkToolEnvPath(toolfind);
        if ((vtbinpath == null || vtbinpath.equals(EMPTY_STRING)) && (vtbinpath = this.askToolPath(suggPath, queryText, queryMessage)) == null) {
            vtbinpath = EMPTY_STRING;
        }
        return vtbinpath;
    }

    @Override
    public void getAllToolPaths(ExternalToolProcess[] tools, boolean force) {
        IPreferenceStore pstore = Activator.getDefault().getPreferenceStore();
        Iterator eIt = null;
        Map.Entry me2 = null;
        String entry = null;
        ExternalToolProcess[] externalToolProcessArray = tools;
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            ExternalToolProcess tool = externalToolProcessArray[n2];
            for (Map.Entry me2 : tool.groupApp.entrySet()) {
                entry = (String)me2.getKey();
                if (entry.equals("internal")) continue;
                String toolBinID = "performance_tool_bin_directory." + entry + "." + LaunchUtils.getResourceManagerUniqueName((ILaunchConfiguration)this.config);
                if (!force && !pstore.getString(toolBinID).equals(EMPTY_STRING)) continue;
                pstore.setValue(toolBinID, this.findToolBinPath((String)me2.getValue(), null, entry));
            }
            ++n2;
        }
    }

    private IEnvManagerConfig getEnvManagerConfig(ILaunchConfiguration configuration) {
        try {
            EnvManagerConfigString config;
            String moduleLine;
            String emsConfigAttr = configuration.getAttribute("org.eclipse.ptp.launch.ATTR_EMS_CONFIG", null);
            if (emsConfigAttr == null && (moduleLine = configuration.getAttribute("org.eclipse.ptp.launch.RESOURCE_MANAGER_NAME", null)) != null) {
                emsConfigAttr = configuration.getAttribute(String.valueOf(moduleLine) + ".modules", null);
            }
            if (emsConfigAttr != null && (config = new EnvManagerConfigString(emsConfigAttr)).isEnvMgmtEnabled()) {
                return config;
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    @Override
    public IFileStore getFile(String path) {
        return this.fileManager.getResource(path);
    }

    private IRemoteProcess getProcess(List<String> tool, Map<String, String> env, String directory, boolean mergeOutput) throws IOException {
        IRemoteProcessBuilder pb;
        if (this.envManager != null) {
            String com = EMPTY_STRING;
            String concat = EMPTY_STRING;
            try {
                int i = 0;
                while (i < tool.size()) {
                    concat = String.valueOf(concat) + " " + tool.get(i);
                    ++i;
                }
                com = this.envManager.createBashScript(null, false, this.envMgrConfig, concat);
                IFileStore envScript = this.fileManager.getResource(com);
                IFileInfo envInfo = envScript.fetchInfo();
                envInfo.setAttribute(4, true);
                envInfo.setAttribute(0x1000000, true);
                envScript.putInfo(envInfo, 1024, null);
            }
            catch (RemoteConnectionException e) {
                e.printStackTrace();
                return null;
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            pb = this.remoteServices.getProcessBuilder(this.conn, new String[]{com});
        } else {
            pb = this.remoteServices.getProcessBuilder(this.conn, tool);
        }
        if (directory != null) {
            pb.directory(this.fileManager.getResource(directory));
        }
        if (env != null) {
            pb.environment().putAll(env);
        }
        pb.redirectErrorStream(mergeOutput);
        return pb.start();
    }

    @Override
    public String getToolPath(String toolID) {
        IPreferenceStore pstore = Activator.getDefault().getPreferenceStore();
        String toolBinID = null;
        toolBinID = this.config != null ? "performance_tool_bin_directory." + toolID + "." + LaunchUtils.getResourceManagerUniqueName((ILaunchConfiguration)this.config) : "performance_tool_bin_directory." + toolID + "." + this.conn.getName();
        String path = pstore.getString(toolBinID);
        if (path != null) {
            return path;
        }
        return EMPTY_STRING;
    }

    @Override
    public String getWorkingDirectory() {
        return this.conn.getWorkingDirectory();
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    @Override
    public boolean runTool(List<String> tool, Map<String, String> env, String directory) {
        return this.runTool(tool, env, directory, null);
    }

    @Override
    public boolean runTool(List<String> tool, Map<String, String> env, String directory, String output) {
        int eval = -1;
        try {
            OutputStream fos = null;
            if (output != null) {
                IFileStore test = this.fileManager.getResource(output);
                IFileStore parent = test.getParent();
                if (parent == null || !parent.fetchInfo().exists()) {
                    parent = this.fileManager.getResource(directory);
                    test = parent.getChild(output);
                }
                fos = test.openOutputStream(0, null);
            }
            IRemoteProcess p = this.getProcess(tool, env, directory, false);
            StreamRunner outRun = new StreamRunner(p.getInputStream(), "out", fos);
            StreamRunner errRun = new StreamRunner(p.getErrorStream(), "err", null);
            outRun.start();
            errRun.start();
            outRun.join();
            eval = p.waitFor();
            if (fos != null) {
                fos.flush();
                fos.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return eval == 0;
    }

    @Override
    public byte[] runToolGetOutput(List<String> tool, Map<String, String> env, String directory) {
        return this.runToolGetOutput(tool, env, directory, false);
    }

    @Override
    public byte[] runToolGetOutput(List<String> tool, Map<String, String> env, String directory, boolean showErr) {
        int eval = -1;
        byte[] out = null;
        try {
            ByteArrayOutputStream fos = new ByteArrayOutputStream();
            IRemoteProcess p = this.getProcess(tool, env, directory, showErr);
            StreamRunner outRun = new StreamRunner(p.getInputStream(), "out", fos);
            StreamRunner errRun = null;
            errRun = new StreamRunner(p.getErrorStream(), "err", null);
            outRun.start();
            errRun.start();
            outRun.join();
            eval = p.waitFor();
            if (fos != null) {
                fos.flush();
                out = fos.toByteArray();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        if (eval != 0) {
            return null;
        }
        return out;
    }

    @Override
    public void runVis(List<String> tool, Map<String, String> env, String directory) {
        try {
            if (env == null) {
                env = new HashMap<String, String>();
            }
            if (env.get("DISPLAY") == null) {
                env.put("DISPLAY", ":0.0");
            }
            this.getProcess(tool, env, directory, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void verifyEnvToolPath(ExternalToolProcess tool) {
        IPreferenceStore pstore = Activator.getDefault().getPreferenceStore();
        Iterator eIt = null;
        Map.Entry me2 = null;
        String entry = null;
        String toolBinID = null;
        String curTool = null;
        for (Map.Entry me2 : tool.groupApp.entrySet()) {
            String gVal;
            entry = (String)me2.getKey();
            if (entry.equals("internal")) continue;
            toolBinID = "performance_tool_bin_directory." + entry + "." + LaunchUtils.getResourceManagerUniqueName((ILaunchConfiguration)this.config);
            curTool = pstore.getString(toolBinID);
            IFileStore ttool = this.fileManager.getResource(curTool);
            if (curTool != null && !curTool.equals(EMPTY_STRING) && ttool.fetchInfo().exists() || (gVal = (String)me2.getValue()) == null || gVal.trim().length() <= 0 || (curTool = this.checkToolEnvPath(gVal)) == null) continue;
            pstore.setValue(toolBinID, curTool);
        }
    }

    @Override
    public void verifyRequestToolPath(ExternalToolProcess tool, boolean force) {
        IPreferenceStore pstore = Activator.getDefault().getPreferenceStore();
        Iterator eIt = null;
        Map.Entry me2 = null;
        String entry = null;
        for (Map.Entry me2 : tool.groupApp.entrySet()) {
            entry = (String)me2.getKey();
            if (entry.equals("internal")) continue;
            String toolBinID = "performance_tool_bin_directory." + entry + "." + LaunchUtils.getResourceManagerUniqueName((ILaunchConfiguration)this.config);
            if (!force && !pstore.getString(toolBinID).equals(EMPTY_STRING)) continue;
            pstore.setValue(toolBinID, this.findToolBinPath((String)me2.getValue(), null, entry));
        }
    }

    static class StreamRunner
    extends Thread {
        InputStream is;
        OutputStream os;
        String type;

        StreamRunner(InputStream is, String type, OutputStream os) {
            this.is = is;
            this.os = os;
            this.type = type;
        }

        public void run() {
            try {
                PrintWriter pw = null;
                if (this.os != null) {
                    pw = new PrintWriter(this.os);
                }
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (pw != null) {
                        pw.println(line);
                        continue;
                    }
                    System.out.println(line);
                }
                if (pw != null) {
                    pw.flush();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

