/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.remotetools.core;

import java.net.URI;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.internal.remote.remotetools.core.RemoteToolsConnection;
import org.eclipse.ptp.internal.remote.remotetools.core.RemoteToolsFileStore;
import org.eclipse.ptp.internal.remote.remotetools.core.RemoteToolsFileSystem;
import org.eclipse.ptp.remote.core.IRemoteFileManager;

public class RemoteToolsFileManager
implements IRemoteFileManager {
    private final RemoteToolsConnection fConnection;

    public RemoteToolsFileManager(RemoteToolsConnection conn) {
        this.fConnection = conn;
    }

    public String getDirectorySeparator() {
        return "/";
    }

    public IFileStore getResource(String pathStr) {
        Path path = new Path(pathStr);
        if (!path.isAbsolute()) {
            path = new Path(this.fConnection.getWorkingDirectory()).append((IPath)path);
        }
        return new RemoteToolsFileStore(this.fConnection.getName(), path.toString());
    }

    public String toPath(URI uri) {
        return uri.getPath();
    }

    public URI toURI(IPath path) {
        try {
            return RemoteToolsFileSystem.getURIFor(this.fConnection.getName(), path.toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public URI toURI(String path) {
        return this.toURI((IPath)new Path(path));
    }
}

