/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.server.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.internal.remote.server.core.Activator;
import org.eclipse.ptp.internal.remote.server.core.DebugUtil;
import org.eclipse.ptp.internal.remote.server.core.messages.Messages;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.remote.server.core.RemoteVariableManager;
import org.osgi.framework.Bundle;

public abstract class AbstractRemoteServerRunner
extends Job {
    private static String LAUNCH_COMMAND_VAR = "launch_command";
    private static String UNPACK_COMMAND_VAR = "unpack_command";
    private static String PAYLOAD_VAR = "payload";
    private static String WORKING_DIR_VAR = "working_dir";
    private static String VERIFY_LAUNCH_COMMAND_VAR = "verify_launch_command";
    private static String VERIFY_LAUNCH_FAIL_MESSAGE_VAR = "verify_launch_fail_message";
    private static String VERIFY_LAUNCH_PATTERN_VAR = "verify_launch_pattern";
    private static String VERIFY_UNPACK_COMMAND_VAR = "verify_unpack_command";
    private static String VERIFY_UNPACK_FAIL_MESSAGE_VAR = "verify_unpack_fail_message";
    private static String VERIFY_UNPACK_PATTERN_VAR = "verify_unpack_pattern";
    private final boolean DEBUG = true;
    private final Map<String, String> fEnv = new HashMap<String, String>();
    private final Map<String, String> fVars = new HashMap<String, String>();
    private final String fServerName;
    private volatile ServerState fServerState = ServerState.STOPPED;
    private IRemoteProcess fRemoteProcess;
    private IRemoteConnection fRemoteConnection;
    private Bundle fBundle;
    private boolean fContinuous = true;
    private IStatus fStatus;
    private String stdErrOutput;

    public AbstractRemoteServerRunner(String name) {
        super(name);
        this.fServerName = name;
        this.setPriority(30);
        this.setSystem(false);
    }

    public Map<String, String> getEnv() {
        return this.fEnv;
    }

    public InputStream getErrorStream() {
        if (this.fRemoteProcess != null) {
            return this.fRemoteProcess.getErrorStream();
        }
        return null;
    }

    public InputStream getInputStream() {
        if (this.fRemoteProcess != null) {
            return this.fRemoteProcess.getInputStream();
        }
        return null;
    }

    public String getLaunchCommand() {
        return this.fVars.get(LAUNCH_COMMAND_VAR);
    }

    public OutputStream getOutputStream() {
        if (this.fRemoteProcess != null) {
            return this.fRemoteProcess.getOutputStream();
        }
        return null;
    }

    public String getPayload() {
        return this.fVars.get(PAYLOAD_VAR);
    }

    public IRemoteConnection getRemoteConnection() {
        return this.fRemoteConnection;
    }

    public ServerState getServerState() {
        return this.fServerState;
    }

    public String getUnpackCommand() {
        return this.fVars.get(UNPACK_COMMAND_VAR);
    }

    public String getVariable(String name) {
        return this.fVars.get(name);
    }

    public String getVerifyLaunchCommand() {
        return this.fVars.get(VERIFY_LAUNCH_COMMAND_VAR);
    }

    public String getVerifyLaunchFailMessage() {
        return this.fVars.get(VERIFY_LAUNCH_FAIL_MESSAGE_VAR);
    }

    public String getVerifyLaunchPattern() {
        return this.fVars.get(VERIFY_LAUNCH_PATTERN_VAR);
    }

    public String getVerifyUnpackCommand() {
        return this.fVars.get(VERIFY_UNPACK_COMMAND_VAR);
    }

    public String getVerifyUnpackFailMessage() {
        return this.fVars.get(VERIFY_UNPACK_FAIL_MESSAGE_VAR);
    }

    public String getVerifyUnpackPattern() {
        return this.fVars.get(VERIFY_UNPACK_PATTERN_VAR);
    }

    public String getWorkingDir() {
        return this.fVars.get(WORKING_DIR_VAR);
    }

    public void setBundleId(String id) {
        this.fBundle = Platform.getBundle((String)id);
    }

    public void setContinuous(boolean continuous) {
        this.fContinuous = continuous;
    }

    public void setEnv(String env) {
        if (env != null) {
            String[] stringArray = env.split("\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String vars = stringArray[n2];
                String[] envVar = vars.split("=");
                if (envVar.length == 2) {
                    this.fEnv.put(envVar[0], envVar[1]);
                }
                ++n2;
            }
        }
    }

    public void setLaunchCommand(String command) {
        this.fVars.put(LAUNCH_COMMAND_VAR, command);
    }

    public void setPayload(String file) {
        this.fVars.put(PAYLOAD_VAR, file);
    }

    public void setRemoteConnection(IRemoteConnection conn) {
        this.fRemoteConnection = conn;
        this.setName(String.valueOf(this.fServerName) + " (" + conn.getName() + ")");
    }

    public void setUnpackCommand(String command) {
        this.fVars.put(UNPACK_COMMAND_VAR, command);
    }

    public void setVariable(String name, String value) {
        this.fVars.put(name, value);
    }

    public void setVerifyLaunchCommand(String verifyCommand) {
        this.fVars.put(VERIFY_LAUNCH_COMMAND_VAR, verifyCommand);
    }

    public void setVerifyLaunchFailMessage(String verifyFailMessage) {
        this.fVars.put(VERIFY_LAUNCH_FAIL_MESSAGE_VAR, verifyFailMessage);
    }

    public void setVerifyLaunchPattern(String verifyPattern) {
        this.fVars.put(VERIFY_LAUNCH_PATTERN_VAR, verifyPattern);
    }

    public void setVerifyUnpackCommand(String verifyCommand) {
        this.fVars.put(VERIFY_UNPACK_COMMAND_VAR, verifyCommand);
    }

    public void setVerifyUnpackFailMessage(String verifyFailMessage) {
        this.fVars.put(VERIFY_UNPACK_FAIL_MESSAGE_VAR, verifyFailMessage);
    }

    public void setVerifyUnpackPattern(String verifyPattern) {
        this.fVars.put(VERIFY_UNPACK_PATTERN_VAR, verifyPattern);
    }

    public void setWorkDir(String workDir) {
        this.fVars.put(WORKING_DIR_VAR, workDir);
    }

    public void startServer(IProgressMonitor monitor) throws IOException {
        block16: {
            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                if (this.fRemoteConnection == null || this.fServerState == ServerState.RUNNING) break block16;
                if (!this.doServerStarting((IProgressMonitor)subMon.newChild(10))) {
                    throw new IOException(Messages.AbstractRemoteServerRunner_serverRestartAborted);
                }
                this.setServerState(ServerState.STARTING);
                if (!this.fRemoteConnection.isOpen()) {
                    try {
                        this.fRemoteConnection.open((IProgressMonitor)subMon.newChild(10));
                    }
                    catch (RemoteConnectionException e) {
                        throw new IOException(e.getMessage());
                    }
                    if (subMon.isCanceled()) {
                        return;
                    }
                    if (!this.fRemoteConnection.isOpen()) {
                        throw new IOException(Messages.AbstractRemoteServerRunner_unableToOpenConnection);
                    }
                }
                if (this.getVerifyLaunchCommand() != null && this.getVerifyLaunchCommand().length() != 0 && !this.isValidCommand(this.getVerifyLaunchCommand(), this.getVerifyLaunchPattern(), (IProgressMonitor)subMon.newChild(10))) {
                    if (this.getVerifyLaunchFailMessage() != null && this.getVerifyLaunchFailMessage().length() != 0) {
                        this.setServerState(ServerState.STOPPED);
                        throw new IOException(NLS.bind((String)this.getVerifyLaunchFailMessage(), (Object[])new Object[]{this.fServerName, this.fRemoteConnection.getName()}));
                    }
                    this.setServerState(ServerState.STOPPED);
                    throw new IOException(Messages.AbstractRemoteServerRunner_cannotRunServerMissingRequirements);
                }
                if (this.getVerifyUnpackCommand() != null && this.getVerifyUnpackCommand().length() != 0 && !this.isValidCommand(this.getVerifyUnpackCommand(), this.getVerifyUnpackPattern(), (IProgressMonitor)subMon.newChild(10))) {
                    if (this.getVerifyUnpackFailMessage() != null && this.getVerifyUnpackFailMessage().length() != 0) {
                        this.setServerState(ServerState.STOPPED);
                        throw new IOException(NLS.bind((String)this.getVerifyUnpackFailMessage(), (Object[])new Object[]{this.fServerName, this.fRemoteConnection.getName()}));
                    }
                    this.setServerState(ServerState.STOPPED);
                    throw new IOException(Messages.AbstractRemoteServerRunner_cannotRunUnpack);
                }
                this.fStatus = Status.OK_STATUS;
                if (!subMon.isCanceled()) {
                    this.schedule();
                }
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
    }

    public void updateServer(IProgressMonitor monitor) throws IOException {
        block10: {
            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                if (this.fRemoteConnection == null) break block10;
                if (!this.fRemoteConnection.isOpen()) {
                    try {
                        this.fRemoteConnection.open((IProgressMonitor)subMon.newChild(20));
                    }
                    catch (RemoteConnectionException e) {
                        throw new IOException(e.getMessage());
                    }
                    if (subMon.isCanceled()) {
                        return;
                    }
                    if (!this.fRemoteConnection.isOpen()) {
                        throw new IOException(Messages.AbstractRemoteServerRunner_unableToOpenConnection);
                    }
                }
                this.doUpdate((IProgressMonitor)subMon.newChild(80));
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus waitForServerFinish(IProgressMonitor monitor) {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            while (this.getServerState() != ServerState.STOPPED && !subMon.isCanceled()) {
                AbstractRemoteServerRunner abstractRemoteServerRunner = this;
                synchronized (abstractRemoteServerRunner) {
                    try {
                        ((Object)((Object)this)).wait(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            IStatus iStatus = this.fStatus;
            return iStatus;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForServerStart(int timeout) {
        int waitVal = timeout < 1000 ? timeout : 1000;
        int dec = timeout > 0 ? 1000 : 0;
        while (this.getServerState() == ServerState.STARTING && timeout >= 0) {
            try {
                AbstractRemoteServerRunner abstractRemoteServerRunner = this;
                synchronized (abstractRemoteServerRunner) {
                    ((Object)((Object)this)).wait(waitVal);
                }
                timeout -= dec;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitForServerStart(IProgressMonitor monitor) {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            block12: {
                block11: {
                    if (!true) break block11;
                    if (this.getServerState() != ServerState.STARTING) return;
                    if (subMon.isCanceled()) break block12;
                }
                do {
                    AbstractRemoteServerRunner abstractRemoteServerRunner = this;
                    synchronized (abstractRemoteServerRunner) {
                        try {
                            ((Object)((Object)this)).wait(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (this.getServerState() != ServerState.STARTING) return;
                } while (!subMon.isCanceled());
            }
            return;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private boolean checkAndUploadPayload(IFileStore directory, IProgressMonitor monitor) throws IOException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            IFileStore server = directory.getChild(this.getPayload());
            IFileInfo serverInfo = server.fetchInfo(0, (IProgressMonitor)subMon.newChild(10));
            IFileStore local = null;
            URL jarURL = FileLocator.find((Bundle)this.fBundle, (IPath)new Path(this.getPayload()), null);
            if (jarURL != null) {
                jarURL = FileLocator.toFileURL((URL)jarURL);
                local = EFS.getStore((URI)URIUtil.toURI((URL)jarURL));
            }
            if (local == null) {
                throw new IOException(NLS.bind((String)Messages.AbstractRemoteServerRunner_unableToLocatePayload, (Object[])new Object[]{this.getPayload(), this.fBundle.getSymbolicName()}));
            }
            IFileInfo localInfo = local.fetchInfo(0, (IProgressMonitor)subMon.newChild(10));
            if (!serverInfo.exists() || serverInfo.getLength() != localInfo.getLength()) {
                local.copy(server, 2, (IProgressMonitor)subMon.newChild(70));
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private IFileStore doUpdate(IProgressMonitor monitor) throws IOException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            IRemoteFileManager fileManager = this.fRemoteConnection.getRemoteServices().getFileManager(this.fRemoteConnection);
            IFileStore directory = fileManager.getResource(this.getWorkingDir());
            directory.mkdir(0, (IProgressMonitor)subMon.newChild(10));
            if (this.checkAndUploadPayload(directory, (IProgressMonitor)subMon.newChild(30)) && !subMon.isCanceled()) {
                this.unpackPayload(directory, (IProgressMonitor)subMon.newChild(30));
            }
            IFileStore iFileStore = directory;
            return iFileStore;
        }
        catch (CoreException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isValidCommand(String command, String verifyPattern, IProgressMonitor monitor) throws IOException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            Pattern pattern = Pattern.compile(verifyPattern);
            IRemoteProcess p = this.runCommand(command, Messages.AbstractRemoteServerRunner_runningValidate, null, true, (IProgressMonitor)subMon.newChild(100));
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            try {
                String s;
                while ((s = stdInput.readLine()) != null) {
                    Matcher m = pattern.matcher(s);
                    if (!m.matches()) continue;
                    return true;
                }
                return false;
            }
            catch (IOException e) {
                Activator.log(e);
                return false;
            }
        }
        finally {
            monitor.done();
        }
    }

    private IRemoteProcess launchServer(IProgressMonitor monitor) throws IOException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            IFileStore directory = this.doUpdate((IProgressMonitor)subMon.newChild(50));
            if (!subMon.isCanceled()) {
                IRemoteProcess iRemoteProcess = this.runCommand(this.getLaunchCommand(), Messages.AbstractRemoteServerRunner_launching, directory, false, (IProgressMonitor)subMon.newChild(50));
                return iRemoteProcess;
            }
            return null;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private IRemoteProcess runCommand(String command, String message, IFileStore directory, boolean redirect, IProgressMonitor monitor) throws IOException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor);
        subMon.subTask(message);
        try {
            RemoteVariableManager varMgr = RemoteVariableManager.getInstance();
            varMgr.setVars(this.fVars);
            String cmdToRun = varMgr.performStringSubstitution(command);
            List<String> cmdArgs = Arrays.asList(cmdToRun.split(" "));
            IRemoteProcessBuilder builder = this.fRemoteConnection.getRemoteServices().getProcessBuilder(this.fRemoteConnection, cmdArgs);
            if (directory != null) {
                builder.directory(directory);
            }
            builder.redirectErrorStream(redirect);
            builder.environment().putAll(this.getEnv());
            IRemoteProcess iRemoteProcess = builder.start();
            return iRemoteProcess;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpackPayload(IFileStore directory, IProgressMonitor monitor) throws IOException {
        String unpackCommand = this.getUnpackCommand();
        if (unpackCommand != null && unpackCommand.length() != 0) {
            IRemoteProcess proc = this.runCommand(unpackCommand, Messages.AbstractRemoteServerRunner_unpackingPayload, directory, false, monitor);
            while (!proc.isCompleted() && !monitor.isCanceled()) {
                AbstractRemoteServerRunner abstractRemoteServerRunner = this;
                synchronized (abstractRemoteServerRunner) {
                    try {
                        ((Object)((Object)this)).wait(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    protected abstract void doServerFinished(IProgressMonitor var1);

    protected abstract boolean doServerStarted(IProgressMonitor var1);

    protected abstract boolean doServerStarting(IProgressMonitor var1);

    protected boolean doVerifyServerRunningFromStderr(String output) {
        return false;
    }

    protected boolean doVerifyServerRunningFromStdout(String output) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        this.stdErrOutput = "";
        assert (this.getLaunchCommand() != null);
        final SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            if (subMon.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            this.fRemoteProcess = this.launchServer((IProgressMonitor)subMon.newChild(50));
            if (this.fRemoteProcess == null || subMon.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            try {
                if (this.fContinuous) {
                    final BufferedReader stdout = new BufferedReader(new InputStreamReader(this.fRemoteProcess.getInputStream()));
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                while (AbstractRemoteServerRunner.this.getServerState() != ServerState.STOPPED) {
                                    String output = stdout.readLine();
                                    if (output == null) continue;
                                    if (AbstractRemoteServerRunner.this.getServerState() == ServerState.STARTING && AbstractRemoteServerRunner.this.doVerifyServerRunningFromStdout(output)) {
                                        if (!AbstractRemoteServerRunner.this.doServerStarted((IProgressMonitor)subMon.newChild(10))) {
                                            AbstractRemoteServerRunner.this.fRemoteProcess.destroy();
                                        }
                                        AbstractRemoteServerRunner.this.setServerState(ServerState.RUNNING);
                                    }
                                    if (!DebugUtil.SERVER_TRACING) continue;
                                    System.out.println("SERVER: " + output);
                                }
                                stdout.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }, "server stdout").start();
                }
                final BufferedReader stderr = new BufferedReader(new InputStreamReader(this.fRemoteProcess.getErrorStream()));
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            while (AbstractRemoteServerRunner.this.getServerState() != ServerState.STOPPED) {
                                String output = stderr.readLine();
                                if (output == null) continue;
                                if (AbstractRemoteServerRunner.this.fContinuous && AbstractRemoteServerRunner.this.getServerState() == ServerState.STARTING && AbstractRemoteServerRunner.this.doVerifyServerRunningFromStderr(output)) {
                                    if (!AbstractRemoteServerRunner.this.doServerStarted((IProgressMonitor)subMon.newChild(10))) {
                                        AbstractRemoteServerRunner.this.fRemoteProcess.destroy();
                                    }
                                    AbstractRemoteServerRunner.this.setServerState(ServerState.RUNNING);
                                }
                                if (DebugUtil.SERVER_TRACING) {
                                    System.out.println("SERVER: " + output);
                                }
                                AbstractRemoteServerRunner abstractRemoteServerRunner = AbstractRemoteServerRunner.this;
                                abstractRemoteServerRunner.stdErrOutput = String.valueOf(abstractRemoteServerRunner.stdErrOutput) + output;
                            }
                            stderr.close();
                        }
                        catch (IOException iOException) {}
                    }
                }, "server stderr").start();
                if (!this.fContinuous) {
                    this.setServerState(ServerState.RUNNING);
                }
                subMon.worked(40);
                subMon.subTask(Messages.AbstractRemoteServerRunner_serverRunningCancelToTerminate);
                while (!this.fRemoteProcess.isCompleted() && !subMon.isCanceled()) {
                    AbstractRemoteServerRunner abstractRemoteServerRunner = this;
                    synchronized (abstractRemoteServerRunner) {
                        try {
                            ((Object)((Object)this)).wait(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (!this.fRemoteProcess.isCompleted()) {
                    this.fRemoteProcess.destroy();
                }
                try {
                    this.fRemoteProcess.waitFor();
                }
                catch (InterruptedException interruptedException) {}
                IStatus iStatus = this.fStatus = subMon.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
                if (this.fRemoteProcess.exitValue() != 0 && !subMon.isCanceled()) {
                    RemoteServerException exc = new RemoteServerException(this.stdErrOutput);
                    String msg = NLS.bind((String)Messages.AbstractRemoteServerRunner_serverFinishedWithExitCode, (Object)this.fRemoteProcess.exitValue());
                    this.fStatus = new Status(4, "org.eclipse.ptp.remote.server.core", msg, (Throwable)exc);
                }
            }
            catch (IOException e) {
                this.fStatus = new Status(4, "org.eclipse.ptp.remote.server.core", e.getMessage(), null);
            }
        }
        finally {
            this.doServerFinished((IProgressMonitor)subMon.newChild(1));
            this.setServerState(ServerState.STOPPED);
            if (monitor != null) {
                monitor.done();
            }
        }
        return this.fStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setServerState(ServerState state) {
        if (this.fServerState != state) {
            if (DebugUtil.SERVER_TRACING) {
                System.out.println("SERVER RUNNER: " + state.toString());
            }
            this.fServerState = state;
            AbstractRemoteServerRunner abstractRemoteServerRunner = this;
            synchronized (abstractRemoteServerRunner) {
                ((Object)((Object)this)).notifyAll();
            }
        }
    }

    protected void terminateServer() {
        if (this.fServerState == ServerState.RUNNING && this.fRemoteProcess != null) {
            this.fRemoteProcess.destroy();
        }
    }

    private class RemoteServerException
    extends Exception {
        public RemoteServerException(String message) {
            super(message);
        }
    }

    public static enum ServerState {
        STOPPED,
        STARTING,
        RUNNING;

    }
}

