/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.terminal;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.eclipse.ptp.internal.remote.terminal.RemoteToolsConnector;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.RemoteServices;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;

class RemoteToolsConnection
extends Thread {
    private static int fgNo;
    private final ITerminalControl fControl;
    private final RemoteToolsConnector fConn;
    private IRemoteConnection fRemoteConnection;
    private IRemoteProcess fProcess;

    protected static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    protected RemoteToolsConnection(RemoteToolsConnector conn, ITerminalControl control) {
        super("RemoteToolsConnection-" + fgNo++);
        this.fControl = control;
        this.fConn = conn;
        this.fControl.setState(TerminalState.CONNECTING);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void run() {
        try {
            try {
                IRemoteConnectionManager connMgr;
                IRemoteServices services = RemoteServices.getRemoteServices((String)this.fConn.getSshSettings().getRemoteServices());
                if (services != null && (connMgr = services.getConnectionManager()) != null) {
                    this.fRemoteConnection = connMgr.getConnection(this.fConn.getSshSettings().getConnectionName());
                }
                if (this.fRemoteConnection != null && !this.fRemoteConnection.isOpen()) {
                    try {
                        this.fRemoteConnection.open(null);
                    }
                    catch (RemoteConnectionException e) {
                        e.printStackTrace();
                    }
                }
                if (!this.fRemoteConnection.isOpen()) {
                    Object var3_4 = null;
                    try {
                        this.disconnect();
                        Object var5_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_10 = null;
                        this.fControl.setState(TerminalState.CLOSED);
                        throw throwable;
                    }
                    this.fControl.setState(TerminalState.CLOSED);
                    return;
                }
                IRemoteProcessBuilder processBuilder = this.fRemoteConnection.getRemoteServices().getProcessBuilder(this.fRemoteConnection, new String[]{"/bin/bash", "-l"});
                this.fProcess = processBuilder.start(1);
                this.fConn.setInputStream(this.fProcess.getInputStream());
                this.fConn.setOutputStream(this.fProcess.getOutputStream());
                this.fControl.setState(TerminalState.CONNECTED);
                try {
                    this.readDataForever(this.fConn.getInputStream());
                }
                catch (InterruptedIOException interruptedIOException) {}
            }
            catch (IOException iOException) {
                this.fControl.setState(TerminalState.CLOSED);
            }
            Object var3_6 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            try {}
            catch (Throwable throwable2) {
                Object var5_12 = null;
                this.fControl.setState(TerminalState.CLOSED);
                throw throwable2;
            }
            this.disconnect();
            Object var5_13 = null;
            this.fControl.setState(TerminalState.CLOSED);
            throw throwable;
        }
        try {}
        catch (Throwable throwable) {
            Object var5_14 = null;
            this.fControl.setState(TerminalState.CLOSED);
            throw throwable;
        }
        this.disconnect();
        Object var5_15 = null;
        this.fControl.setState(TerminalState.CLOSED);
    }

    public void shutdown() {
        this.disconnect();
    }

    private void connectFailed(String terminalText, String msg) {
        Logger.log((String)terminalText);
        this.fControl.displayTextInTerminal(terminalText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect() {
        this.interrupt();
        RemoteToolsConnection remoteToolsConnection = this;
        synchronized (remoteToolsConnection) {
            if (!this.fProcess.isCompleted()) {
                this.fProcess.destroy();
            }
        }
    }

    private void readDataForever(InputStream in) throws IOException {
        int n;
        byte[] bytes = new byte[32768];
        while ((n = in.read(bytes)) != -1) {
            this.fControl.getRemoteToTerminalOutputStream().write(bytes, 0, n);
        }
    }
}

