/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.monitor.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ptp.internal.rm.jaxb.core.JAXBExtensionUtils;
import org.eclipse.ptp.internal.rm.jaxb.core.JAXBInitializationUtils;
import org.eclipse.ptp.internal.rm.lml.monitor.core.LMLMonitorCorePlugin;
import org.eclipse.ptp.internal.rm.lml.monitor.core.MonitorControl;
import org.eclipse.ptp.internal.rm.lml.monitor.core.messages.Messages;
import org.eclipse.ptp.rm.jaxb.control.core.ILaunchController;
import org.eclipse.ptp.rm.jaxb.control.core.LaunchControllerManager;
import org.eclipse.ptp.rm.jaxb.core.data.MonitorType;
import org.eclipse.ptp.rm.jaxb.core.data.ResourceManagerData;
import org.eclipse.ptp.rm.lml.core.LMLManager;
import org.eclipse.ptp.rm.lml.monitor.core.IMonitorControl;
import org.eclipse.ptp.rm.lml.monitor.core.listeners.IMonitorChangedListener;
import org.eclipse.ptp.rm.lml.monitor.core.listeners.IMonitorRefreshListener;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.progress.UIJob;

public class MonitorControlManager {
    private static final MonitorControlManager fInstance = new MonitorControlManager();
    private static final ListenerList fMonitorChangedListeners = new ListenerList();
    private static final ListenerList fSelectionChangedListeners = new ListenerList();
    private static final ListenerList fMonitorRefreshListeners = new ListenerList();
    private static final String MONITORS_SAVED_STATE = "monitors.xml";
    private static final String MONITORS_ATTR = "monitors";
    private static final String MONITOR_ID_ATTR = "monitor";
    private static Map<String, String> fSystemTypesByConfigName = new TreeMap<String, String>();
    private final Map<String, IMonitorControl> fMonitorControls = Collections.synchronizedMap(new HashMap());
    private final Set<IMonitorControl> fMonitorControlsToStart = new HashSet<IMonitorControl>();

    public static String generateMonitorId(String remoteServicesId, String connectionName, String monitorType) {
        return LaunchControllerManager.generateControlId((String)remoteServicesId, (String)connectionName, (String)monitorType);
    }

    public static MonitorControlManager getInstance() {
        return fInstance;
    }

    public static String getSystemType(String configName) {
        MonitorControlManager.loadSystemTypes();
        return fSystemTypesByConfigName.get(configName);
    }

    public static String[] getConfigurationNames() {
        MonitorControlManager.loadSystemTypes();
        TreeSet<String> set = new TreeSet<String>();
        set.addAll(fSystemTypesByConfigName.keySet());
        return set.toArray(new String[0]);
    }

    private static void loadSystemTypes() {
        String[] configNames;
        String[] stringArray = configNames = JAXBExtensionUtils.getConfiguationNames();
        int n = configNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            URL url = JAXBExtensionUtils.getConfigurationURL((String)name);
            try {
                String type;
                ResourceManagerData data = JAXBInitializationUtils.initializeRMData((URL)url);
                MonitorType monitorType = data.getMonitorData();
                if (monitorType != null && (type = monitorType.getSchedulerType()) != null) {
                    fSystemTypesByConfigName.put(name, type);
                }
            }
            catch (Exception exception) {}
            ++n2;
        }
    }

    private MonitorControlManager() {
    }

    public void addMonitorChangedListener(IMonitorChangedListener listener) {
        fMonitorChangedListeners.add((Object)listener);
    }

    private void addMonitorControl(IMonitorControl monitor) {
        this.fMonitorControls.put(monitor.getControlId(), monitor);
        this.fireMonitorAdded(new IMonitorControl[]{monitor});
    }

    public void addMonitorRefreshListener(IMonitorChangedListener listener) {
        fMonitorRefreshListeners.add((Object)listener);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        fSelectionChangedListeners.add((Object)listener);
    }

    public IMonitorControl createMonitorControl(ILaunchController controller) {
        return this.createMonitorControl(controller.getRemoteServicesId(), controller.getConnectionName(), controller.getConfiguration().getName());
    }

    public IMonitorControl createMonitorControl(String remoteServicesId, String connectionName, String configName) {
        String controlId = LaunchControllerManager.generateControlId((String)remoteServicesId, (String)connectionName, (String)configName);
        MonitorControl monitor = new MonitorControl(controlId);
        monitor.setRemoteServicesId(remoteServicesId);
        monitor.setConnectionName(connectionName);
        monitor.setConfigurationName(configName);
        monitor.save();
        this.addMonitorControl(monitor);
        this.saveMonitors();
        return monitor;
    }

    public void fireMonitorAdded(final IMonitorControl[] monitors) {
        UIJob job = new UIJob(Messages.MonitorControlManager_monitorAddedJobName){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                Object[] objectArray = fMonitorChangedListeners.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    ((IMonitorChangedListener)listener).monitorAdded(monitors);
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void fireMonitorRefresh(final IMonitorControl[] monitors) {
        UIJob job = new UIJob(Messages.MonitorControlManager_monitoRefreshJobName){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                Object[] objectArray = fMonitorRefreshListeners.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    ((IMonitorRefreshListener)listener).refresh(monitors);
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void fireMonitorRemoved(final IMonitorControl[] monitors) {
        UIJob job = new UIJob(Messages.MonitorControlManager_monitorRemovedJobName){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                Object[] objectArray = fMonitorChangedListeners.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    ((IMonitorChangedListener)listener).monitorRemoved(monitors);
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void fireMonitorUpdated(final IMonitorControl[] monitors) {
        UIJob job = new UIJob(Messages.MonitorControlManager_monitorUpdatedJobName){

            public IStatus runInUIThread(IProgressMonitor progress) {
                Object[] objectArray = fMonitorChangedListeners.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    ((IMonitorChangedListener)listener).monitorUpdated(monitors);
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void fireSelectionChanged(final SelectionChangedEvent event) {
        UIJob job = new UIJob(Messages.MonitorControlManager_monitorSelectionChangedJobName){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IStructuredSelection sel;
                Object[] objectArray = fSelectionChangedListeners.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    ((ISelectionChangedListener)listener).selectionChanged(event);
                    ++n2;
                }
                String monitorId = null;
                if (event.getSelection() instanceof IStructuredSelection && !(sel = (IStructuredSelection)event.getSelection()).isEmpty()) {
                    monitorId = ((IMonitorControl)sel.getFirstElement()).getControlId();
                }
                LMLManager.getInstance().selectLgui(monitorId);
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public IMonitorControl getMonitorControl(String controlId) {
        return this.fMonitorControls.get(controlId);
    }

    public Collection<IMonitorControl> getMonitorControls() {
        return Collections.unmodifiableCollection(this.fMonitorControls.values());
    }

    private File getSaveLocation() {
        return LMLMonitorCorePlugin.getDefault().getStateLocation().append(MONITORS_SAVED_STATE).toFile();
    }

    private void loadMonitor(IMemento memento) {
        try {
            MonitorControl monitor = new MonitorControl(memento.getID());
            if (monitor.load()) {
                this.fMonitorControlsToStart.add(monitor);
            }
            this.addMonitorControl(monitor);
        }
        catch (CoreException e) {
            LMLMonitorCorePlugin.log(e.getLocalizedMessage());
        }
    }

    private void loadMonitors() {
        try {
            IMemento[] monitorsMemento;
            FileReader reader = new FileReader(this.getSaveLocation());
            XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
            IMemento[] iMementoArray = monitorsMemento = memento.getChildren(MONITOR_ID_ATTR);
            int n = monitorsMemento.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento monitorMemento = iMementoArray[n2];
                this.loadMonitor(monitorMemento);
                ++n2;
            }
        }
        catch (FileNotFoundException e) {
            LMLMonitorCorePlugin.log(e.getLocalizedMessage());
        }
        catch (WorkbenchException e) {
            LMLMonitorCorePlugin.log(e.getLocalizedMessage());
        }
    }

    public void removeMonitorChangedListener(IMonitorChangedListener listener) {
        fMonitorChangedListeners.remove((Object)listener);
    }

    public void removeMonitorControls(IMonitorControl[] monitors) {
        IMonitorControl[] iMonitorControlArray = monitors;
        int n = monitors.length;
        int n2 = 0;
        while (n2 < n) {
            IMonitorControl monitor = iMonitorControlArray[n2];
            this.fMonitorControls.remove(monitor.getControlId());
            monitor.dispose();
            ++n2;
        }
        this.saveMonitors();
        this.fireMonitorRemoved(monitors);
    }

    public void removeMonitorRefreshListener(IMonitorChangedListener listener) {
        fMonitorRefreshListeners.remove((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        fSelectionChangedListeners.remove((Object)listener);
    }

    private void saveMonitors() {
        XMLMemento memento = XMLMemento.createWriteRoot((String)MONITORS_ATTR);
        for (IMonitorControl monitor : this.fMonitorControls.values()) {
            memento.createChild(MONITOR_ID_ATTR, monitor.getControlId());
        }
        try {
            FileWriter writer = new FileWriter(this.getSaveLocation());
            memento.save((Writer)writer);
        }
        catch (IOException e) {
            LMLMonitorCorePlugin.log(e.getLocalizedMessage());
        }
    }

    public void start() {
        this.fMonitorControls.clear();
        this.fMonitorControlsToStart.clear();
        this.loadMonitors();
        this.startMonitors();
    }

    private void startMonitors() {
    }

    public void stop() throws CoreException {
        this.stopMonitors();
    }

    private void stopMonitors() {
        for (IMonitorControl monitor : this.fMonitorControls.values()) {
            try {
                monitor.stop();
            }
            catch (CoreException e) {
                LMLMonitorCorePlugin.log(e.getLocalizedMessage());
            }
        }
    }
}

