/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.lml.monitor.ui.dialogs;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.ptp.internal.rm.lml.monitor.ui.messages.Messages;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.ui.widgets.RemoteConnectionWidget;
import org.eclipse.ptp.rm.jaxb.control.core.LaunchControllerManager;
import org.eclipse.ptp.rm.lml.monitor.core.MonitorControlManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class AddMonitorDialog
extends TitleAreaDialog {
    private Combo fConfigNameCombo;
    private RemoteConnectionWidget fRemoteConnectionWidget;
    private String fConfigName;
    private IRemoteConnection fRemoteConnection;

    public AddMonitorDialog(Shell parentShell) {
        super(parentShell);
    }

    public IRemoteConnection getRemoteConnection() {
        return this.fRemoteConnection;
    }

    public String getConfigurationName() {
        return this.fConfigName;
    }

    private void updateEnablement() {
        Boolean valid = false;
        this.fRemoteConnection = this.fRemoteConnectionWidget.getConnection();
        if (this.fRemoteConnection != null) {
            try {
                valid = LaunchControllerManager.getInstance().getLaunchController(this.fRemoteConnection.getRemoteServices().getId(), this.fRemoteConnection.getName(), this.getConfigurationName()) != null;
            }
            catch (CoreException coreException) {}
        }
        this.fRemoteConnectionWidget.setEnabled(this.fConfigNameCombo.getSelectionIndex() > 0);
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(valid != false && this.fConfigNameCombo.getSelectionIndex() > 0 && this.fRemoteConnectionWidget.getConnection() != null);
        }
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.updateEnablement();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.AddMonitorDialog_Add_Monitor);
        this.setTitle(Messages.AddMonitorDialog_Select_new_monitor);
        this.setMessage(Messages.AddMonitorDialog_Choose_a_monitor_type);
        Composite composite = new Composite(parent, 0);
        GridData gd = new GridData(1808);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        composite.setLayout((Layout)topLayout);
        composite.setLayoutData((Object)gd);
        new Label(composite, 0).setText(Messages.AddMonitorDialog_Monitor_Type);
        this.fConfigNameCombo = new Combo(composite, 8);
        gd = new GridData(768);
        this.fConfigNameCombo.setLayoutData((Object)gd);
        this.fConfigNameCombo.setItems(MonitorControlManager.getConfigurationNames());
        this.fConfigNameCombo.add(Messages.AddMonitorDialog_Please_select_a_monitor_type, 0);
        this.fConfigNameCombo.select(0);
        this.fConfigNameCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AddMonitorDialog.this.fConfigNameCombo.getSelectionIndex() > 0) {
                    AddMonitorDialog.this.fConfigName = AddMonitorDialog.this.fConfigNameCombo.getItem(AddMonitorDialog.this.fConfigNameCombo.getSelectionIndex());
                }
                AddMonitorDialog.this.updateEnablement();
            }
        });
        this.fRemoteConnectionWidget = new RemoteConnectionWidget(composite, 0, Messages.AddMonitorDialog_Connection_Type, 0, null);
        this.fRemoteConnectionWidget.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.fRemoteConnectionWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddMonitorDialog.this.updateEnablement();
            }
        });
        this.fRemoteConnectionWidget.setEnabled(false);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }
}

