/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.rap.demo.controls.Util;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class CoolBarTab
extends ExampleTab {
    private static final String TOOL_ITEM_IMAGE_PATH = "resources/newfile_wiz.gif";
    private CoolBar coolBar;

    public CoolBarTab() {
        super("CoolBar");
    }

    protected void createStyleControls(Composite parent) {
        this.createStyleButton("BORDER", 2048);
        this.createStyleButton("FLAT", 0x800000);
        this.createVisibilityButton();
        this.createEnablementButton();
        this.createLockedButton(parent);
        this.createBgColorButton();
        this.createBgImageButton();
    }

    protected void createExampleControls(final Composite parent) {
        int style = this.getStyle();
        this.coolBar = new CoolBar(parent, style);
        this.createItem(this.coolBar, 1);
        this.createItem(this.coolBar, 2);
        this.createItem(this.coolBar, 3);
        this.coolBar.setLocation(5, 5);
        this.coolBar.setSize(this.coolBar.computeSize(parent.getSize().x - 10, -1));
        this.registerControl((Control)this.coolBar);
        final ControlAdapter controlListener = new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                CoolBarTab.this.coolBar.setSize(CoolBarTab.this.coolBar.computeSize(parent.getSize().x - 10, -1));
            }
        };
        parent.addControlListener((ControlListener)controlListener);
        this.coolBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                parent.removeControlListener((ControlListener)controlListener);
            }
        });
    }

    private CoolItem createItem(CoolBar coolBar, int id) {
        ToolBar toolBar = this.createToolBar((Composite)coolBar, id);
        toolBar.pack();
        Point size = toolBar.getSize();
        size = new Point(size.x + (int)((double)size.x * 0.1), size.y);
        CoolItem item = new CoolItem(coolBar, 0);
        item.setControl((Control)toolBar);
        Point preferred = item.computeSize(size.x, size.y);
        item.setPreferredSize(preferred);
        return item;
    }

    private ToolBar createToolBar(Composite parent, int id) {
        int style = this.getStyle() & 0x300;
        ToolBar toolBar = new ToolBar(parent, style);
        ToolItem item1 = new ToolItem(toolBar, 8);
        item1.setText("new" + id);
        Image image = Util.loadImage(parent.getDisplay(), TOOL_ITEM_IMAGE_PATH);
        item1.setImage(image);
        ToolItem item2 = new ToolItem(toolBar, 8);
        item2.setText("open" + id);
        ToolItem item3 = new ToolItem(toolBar, 8);
        item3.setText("save as" + id);
        new ToolItem(toolBar, 2);
        ToolItem item4 = new ToolItem(toolBar, 8);
        item4.setText("print" + id);
        return toolBar;
    }

    private void createLockedButton(Composite parent) {
        final Button button = new Button(parent, 32);
        button.setText("Locked");
        button.setSelection(this.coolBar.getLocked());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CoolBarTab.this.coolBar.setLocked(button.getSelection());
            }
        });
    }
}

