/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.examples.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.eclipse.rap.examples.internal.MainUi;
import org.eclipse.rap.rwt.application.Application;
import org.eclipse.rap.rwt.application.ApplicationConfiguration;
import org.eclipse.rap.rwt.service.ResourceLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class ExampleApplication
implements ApplicationConfiguration {
    public void configure(Application application) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.eclipse.rap.rwt.webclient.pageTitle", "RAP Examples");
        properties.put("org.eclipse.rap.rwt.webclient.bodyHtml", ExampleApplication.readTextFromResource("resources/body.html", "UTF-8"));
        properties.put("org.eclipse.rap.rwt.webclient.favicon", "icons/favicon.png");
        application.setOperationMode(Application.OperationMode.SWT_COMPATIBILITY);
        application.addEntryPoint("/examples", MainUi.class, properties);
        application.addStyleSheet("org.eclipse.rap.rwt.theme.Default", "theme/theme.css");
        application.addResource("icons/favicon.png", ExampleApplication.createResourceLoader("icons/favicon.png"));
        application.addResource("icons/loading.gif", ExampleApplication.createResourceLoader("icons/loading.gif"));
        this.registerClientScriptingResources(application);
    }

    private void registerClientScriptingResources(Application application) {
        Bundle clientScriptingBundle = this.findBundle("org.eclipse.rap.clientscripting");
        if (clientScriptingBundle != null) {
            String className = "org.eclipse.rap.clientscripting.internal.resources.ClientScriptingResources";
            try {
                Class resourceClass = clientScriptingBundle.loadClass(className);
                Method registerMethod = resourceClass.getMethod("register", Application.class);
                registerMethod.invoke(null, application);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    private Bundle findBundle(String symbolicId) {
        Bundle result = null;
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        Bundle[] bundleArray = bundleContext.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (symbolicId.equals(bundle.getSymbolicName())) {
                result = bundle;
            }
            ++n2;
        }
        return result;
    }

    private static ResourceLoader createResourceLoader(String resourceName) {
        return new ResourceLoader(){

            public InputStream getResourceAsStream(String resourceName) throws IOException {
                return this.getClass().getClassLoader().getResourceAsStream(resourceName);
            }
        };
    }

    private static String readTextFromResource(String resourceName, String charset) {
        String result;
        try {
            ClassLoader classLoader = ExampleApplication.class.getClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream(resourceName);
            if (inputStream == null) {
                throw new RuntimeException("Resource not found: " + resourceName);
            }
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, charset));
                StringBuilder stringBuilder = new StringBuilder();
                String line = reader.readLine();
                while (line != null) {
                    stringBuilder.append(line);
                    stringBuilder.append('\n');
                    line = reader.readLine();
                }
                result = stringBuilder.toString();
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to read text from resource: " + resourceName);
        }
        return result;
    }
}

