/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.overrides;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.collections.primitives.ArrayDoubleList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.math.stat.StatUtils;
import org.eclipse.recommenders.internal.completion.rcp.overrides.ClassOverridesNetwork;
import org.eclipse.recommenders.internal.completion.rcp.overrides.ClassOverridesObservation;
import org.eclipse.recommenders.jayes.BayesNet;
import org.eclipse.recommenders.jayes.BayesNode;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;

public class ClassOverridesNetworkBuilder {
    private static final double MIN = 1.0E-4;
    private static final double MAX = 0.9999;
    private final ITypeName typeName;
    private final BayesNet network;
    private final Collection<ClassOverridesObservation> overriddenMethods;
    private int totalNumberOfSubtypesFound;
    private BayesNode patternNode;
    private LinkedList<BayesNode> methodNodes;

    public ClassOverridesNetworkBuilder(ITypeName typeName, Collection<ClassOverridesObservation> overriddenMethods) {
        this.typeName = typeName;
        this.overriddenMethods = overriddenMethods;
        Checks.ensureIsGreaterOrEqualTo((double)overriddenMethods.size(), (double)1.0, (String)"at least one observation is required");
        this.computeTotalNumberOfSubtypes();
        this.network = new BayesNet();
    }

    private void computeTotalNumberOfSubtypes() {
        for (ClassOverridesObservation usage : this.overriddenMethods) {
            this.totalNumberOfSubtypesFound += usage.frequency;
        }
    }

    public ClassOverridesNetwork build() {
        return new ClassOverridesNetwork(this.typeName, this.network, this.patternNode, this.methodNodes);
    }

    public void createPatternsNode() {
        this.createPatternNodeInNetwork();
    }

    private void createPatternNodeInNetwork() {
        this.patternNode = new BayesNode("patternNode");
        this.network.addNode(this.patternNode);
        this.patternNode.addOutcome("none");
        ArrayDoubleList def = new ArrayDoubleList();
        def.add(1.0E-4);
        int i = 0;
        for (ClassOverridesObservation obs : this.overriddenMethods) {
            String name = "observation_" + String.valueOf(++i);
            this.patternNode.addOutcome(name);
            double priorPatternProbability = (double)obs.frequency / (double)this.totalNumberOfSubtypesFound;
            def.add(priorPatternProbability);
        }
        this.scaleMaximalValue(def);
        this.patternNode.setProbabilities(def.toArray());
    }

    private void scaleMaximalValue(ArrayDoubleList subDefinition) {
        double[] values = subDefinition.toArray();
        double diff = StatUtils.sum((double[])values) - 1.0;
        double max = StatUtils.max((double[])values);
        int indexOf = ArrayUtils.indexOf((double[])values, (double)max);
        subDefinition.set(indexOf, values[indexOf] - diff);
    }

    public void createMethodNodes() {
        TreeSet<IMethodName> methods = this.collectInvokedMethodsFromPatterns();
        this.methodNodes = Lists.newLinkedList();
        for (IMethodName ref : methods) {
            BayesNode methodNode = new BayesNode(ref.getIdentifier());
            this.network.addNode(methodNode);
            methodNode.setParents((List)Lists.newArrayList((Object[])new BayesNode[]{this.patternNode}));
            methodNode.addOutcome("true");
            methodNode.addOutcome("false");
            methodNode.setProbabilities(this.createMethodNodeDefinition(ref));
            this.methodNodes.add(methodNode);
        }
    }

    private double[] createMethodNodeDefinition(IMethodName ref) {
        ArrayDoubleList definition = new ArrayDoubleList();
        definition.add(0.0);
        definition.add(1.0);
        for (ClassOverridesObservation pattern : this.overriddenMethods) {
            boolean overridesMethod = pattern.overriddenMethods.contains(ref);
            if (overridesMethod) {
                definition.add(0.9999);
                definition.add(1.0E-4);
                continue;
            }
            definition.add(1.0E-4);
            definition.add(0.9999);
        }
        return definition.toArray();
    }

    private TreeSet<IMethodName> collectInvokedMethodsFromPatterns() {
        TreeSet<IMethodName> methods = new TreeSet<IMethodName>();
        for (ClassOverridesObservation observation : this.overriddenMethods) {
            methods.addAll(observation.overriddenMethods);
        }
        return methods;
    }
}

