/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.proposals;

import com.google.common.base.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.internal.ui.text.java.MethodDeclarationCompletionProposal;
import org.eclipse.recommenders.completion.rcp.IProcessableProposal;
import org.eclipse.recommenders.completion.rcp.ProposalProcessorManager;

public class ProcessableMethodDeclarationCompletionProposal
extends MethodDeclarationCompletionProposal
implements IProcessableProposal {
    private CompletionProposal coreProposal;
    private ProposalProcessorManager mgr;
    private String lastPrefix;

    public static ProcessableMethodDeclarationCompletionProposal newProposal(CompletionProposal proposal, IType type, int relevance) throws CoreException {
        String constructorName;
        String prefix = String.valueOf(proposal.getName());
        int offset = proposal.getReplaceStart();
        int length = proposal.getReplaceEnd() - offset;
        IMethod[] methods = type.getMethods();
        if (!type.isInterface() && (constructorName = type.getElementName()).length() > 0 && constructorName.startsWith(prefix) && !ProcessableMethodDeclarationCompletionProposal.hasMethod(methods, constructorName)) {
            return new ProcessableMethodDeclarationCompletionProposal(type, constructorName, null, offset, length, relevance + 500);
        }
        if (!(prefix.length() <= 0 || "main".equals(prefix) || ProcessableMethodDeclarationCompletionProposal.hasMethod(methods, prefix) || JavaConventionsUtil.validateMethodName((String)prefix, (IJavaElement)type).matches(4))) {
            return new ProcessableMethodDeclarationCompletionProposal(type, prefix, "V", offset, length, relevance);
        }
        return null;
    }

    private static boolean hasMethod(IMethod[] methods, String name) {
        int i = 0;
        while (i < methods.length) {
            IMethod curr = methods[i];
            if (curr.getElementName().equals(name) && curr.getParameterTypes().length == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ProcessableMethodDeclarationCompletionProposal(IType type, String methodName, String returnTypeSig, int start, int length, int relevance) {
        super(type, methodName, returnTypeSig, start, length, relevance);
    }

    public boolean isPrefix(String prefix, String completion) {
        this.lastPrefix = prefix;
        if (this.mgr.prefixChanged(prefix)) {
            return true;
        }
        return super.isPrefix(prefix, completion);
    }

    @Override
    public String getPrefix() {
        return this.lastPrefix;
    }

    @Override
    public Optional<CompletionProposal> getCoreProposal() {
        return Optional.fromNullable((Object)this.coreProposal);
    }

    @Override
    public ProposalProcessorManager getProposalProcessorManager() {
        return this.mgr;
    }

    @Override
    public void setProposalProcessorManager(ProposalProcessorManager mgr) {
        this.mgr = mgr;
    }
}

