/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.extdoc.rcp.providers;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.recommenders.extdoc.ClassOverrideDirectives;
import org.eclipse.recommenders.extdoc.ClassOverridePatterns;
import org.eclipse.recommenders.extdoc.MethodPattern;
import org.eclipse.recommenders.extdoc.rcp.l10n.Messages;
import org.eclipse.recommenders.extdoc.rcp.providers.ExtdocProvider;
import org.eclipse.recommenders.extdoc.rcp.providers.JavaSelectionSubscriber;
import org.eclipse.recommenders.internal.extdoc.rcp.ui.ExtdocUtils;
import org.eclipse.recommenders.internal.extdoc.rcp.wiring.ManualModelStoreWiring;
import org.eclipse.recommenders.rcp.events.JavaSelectionEvent;
import org.eclipse.recommenders.utils.TreeBag;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.rcp.JavaElementResolver;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public final class OverridesProvider
extends ExtdocProvider {
    private final JavaElementResolver resolver;
    private final EventBus workspaceBus;
    private final ManualModelStoreWiring.ClassOverridesModelStore oStore;
    private final ManualModelStoreWiring.ClassOverridesPatternsModelStore pStore;

    @Inject
    public OverridesProvider(ManualModelStoreWiring.ClassOverridesModelStore oStore, ManualModelStoreWiring.ClassOverridesPatternsModelStore pStore, JavaElementResolver resolver, EventBus workspaceBus) {
        this.oStore = oStore;
        this.pStore = pStore;
        this.resolver = resolver;
        this.workspaceBus = workspaceBus;
    }

    @JavaSelectionSubscriber
    public void onTypeRootSelection(ITypeRoot root, JavaSelectionEvent event, Composite parent) throws ExecutionException {
        IType type = root.findPrimaryType();
        if (type != null) {
            this.onTypeSelection(type, event, parent);
        }
    }

    @JavaSelectionSubscriber
    public void onTypeSelection(IType type, JavaSelectionEvent event, Composite parent) throws ExecutionException {
        this.renderClassOverrideDirectives(type, parent);
        this.renderClassOverridesPatterns(type, parent);
    }

    private boolean renderClassOverrideDirectives(IType type, Composite parent) throws ExecutionException {
        Optional model = this.oStore.aquireModel((IMember)type);
        if (!model.isPresent() || ((ClassOverrideDirectives)model.get()).getOverrides() == null) {
            return false;
        }
        this.runSyncInUiThread(new TypeOverrideDirectivesRenderer(type, (ClassOverrideDirectives)model.get(), parent));
        return true;
    }

    private boolean renderClassOverridesPatterns(IType type, Composite parent) throws ExecutionException {
        Optional opt = this.pStore.aquireModel((IMember)type);
        if (!opt.isPresent()) {
            return false;
        }
        this.runSyncInUiThread(new OverridePatternsRenderer(type, (ClassOverridePatterns)opt.get(), parent));
        return true;
    }

    private class OverridePatternsRenderer
    implements Runnable {
        private final Composite parent;
        private Composite container;
        double totalNumberOfExamples;
        private List<MethodPattern> patterns;

        public OverridePatternsRenderer(IType type, ClassOverridePatterns directive, Composite parent) {
            this.parent = parent;
            this.setPatterns(directive);
            this.computeTotalNumberOfExamples();
            this.filterInfrequentPatterns();
            this.sortPatterns();
        }

        private void setPatterns(ClassOverridePatterns patterns) {
            this.patterns = Arrays.asList(patterns.getPatterns());
        }

        private void filterInfrequentPatterns() {
            this.patterns = Lists.newLinkedList((Iterable)Collections2.filter(this.patterns, (Predicate)new Predicate<MethodPattern>(){

                public boolean apply(MethodPattern input) {
                    int numberOfObservations = input.getNumberOfObservations();
                    return (double)numberOfObservations / OverridePatternsRenderer.this.totalNumberOfExamples > 0.1;
                }
            }));
        }

        private void sortPatterns() {
            Collections.sort(this.patterns, new Comparator<MethodPattern>(){

                @Override
                public int compare(MethodPattern o1, MethodPattern o2) {
                    return o2.getNumberOfObservations() - o1.getNumberOfObservations();
                }
            });
        }

        private void computeTotalNumberOfExamples() {
            for (MethodPattern pattern : this.patterns) {
                this.totalNumberOfExamples += (double)pattern.getNumberOfObservations();
            }
        }

        @Override
        public void run() {
            this.createContainer();
            this.addHeader();
            int i = 1;
            for (MethodPattern pattern : this.patterns) {
                this.addDirectives(pattern, i++);
            }
        }

        private void createContainer() {
            this.container = new Composite(this.parent, 0);
            ExtdocUtils.setInfoBackgroundColor((Control)this.container);
            this.container.setLayout((Layout)new GridLayout());
            this.container.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        }

        private void addHeader() {
            new Label(this.container, 0);
            String message = String.format(Messages.EXTDOC_OVERRIDES_INTRO_PATTERN, new Object[0]);
            ExtdocUtils.createLabel(this.container, message, true);
        }

        private void addDirectives(MethodPattern pattern, int index) {
            int patternPercentage = (int)Math.rint((double)(100 * pattern.getNumberOfObservations()) / this.totalNumberOfExamples);
            String text = String.format(Messages.EXTDOC_OVERRIDES_PERCENTAGE_PATTERN, index, patternPercentage, pattern.getNumberOfObservations());
            ExtdocUtils.createLabel(this.container, text, true, false, 16, true);
            Composite group = ExtdocUtils.createGridComposite(this.container, 1, 0, 0, 0, 0);
            LinkedList s = Lists.newLinkedList(pattern.getMethods().entrySet());
            Collections.sort(s, new Comparator<Map.Entry<IMethodName, Double>>(){

                @Override
                public int compare(Map.Entry<IMethodName, Double> o1, Map.Entry<IMethodName, Double> o2) {
                    return o1.getKey().getName().compareTo(o2.getKey().getName());
                }
            });
            Table table = new Table(group, 32768);
            table.setBackground(ExtdocUtils.createColor(29));
            table.setLayoutData((Object)GridDataFactory.fillDefaults().indent(10, 0).create());
            TableColumn column1 = new TableColumn(table, 0);
            TableColumn column2 = new TableColumn(table, 0);
            TableColumn column3 = new TableColumn(table, 0);
            TableColumn column4 = new TableColumn(table, 0);
            for (Map.Entry entry : s) {
                int percentage = (int)Math.rint((Double)entry.getValue() * 100.0);
                String phraseText = ExtdocUtils.percentageToRecommendationPhrase(percentage);
                String stats = String.format(Messages.EXTDOC_OVERRIDES_PERCENTAGE, percentage);
                Link bar = ExtdocUtils.createMethodLink((Composite)table, (IMethodName)entry.getKey(), OverridesProvider.this.resolver, OverridesProvider.this.workspaceBus);
                TableItem item = new TableItem(table, 0);
                item.setText(new String[]{phraseText, Messages.EXTDOC_OVERRIDES_OVERRIDE, bar.getText(), stats});
                item.setFont(0, JFaceResources.getBannerFont());
                item.setForeground(ExtdocUtils.createColor(28));
                TableEditor editor = new TableEditor(table);
                editor.grabVertical = true;
                editor.grabHorizontal = true;
                editor.setEditor((Control)bar, item, 2);
            }
            column1.pack();
            column2.pack();
            column3.pack();
            column4.pack();
            new Label(this.container, 258);
        }
    }

    private class TypeOverrideDirectivesRenderer
    implements Runnable {
        private final IType type;
        private final ClassOverrideDirectives directive;
        private final Composite parent;
        private Composite container;

        public TypeOverrideDirectivesRenderer(IType type, ClassOverrideDirectives directive, Composite parent) {
            this.type = type;
            this.directive = directive;
            this.parent = parent;
        }

        @Override
        public void run() {
            this.createContainer();
            this.addHeader();
            this.addDirectives();
        }

        private void createContainer() {
            this.container = new Composite(this.parent, 0);
            ExtdocUtils.setInfoBackgroundColor((Control)this.container);
            this.container.setLayout((Layout)new GridLayout());
        }

        private void addHeader() {
            String message = String.format(Messages.EXTDOC_OVERRIDES_INTRO, this.directive.getNumberOfSubclasses(), this.type.getElementName());
            Label label = new Label(this.container, 0);
            label.setText(message);
            ExtdocUtils.setInfoForegroundColor((Control)label);
            ExtdocUtils.setInfoBackgroundColor((Control)label);
        }

        private void addDirectives() {
            int numberOfSubclasses = this.directive.getNumberOfSubclasses();
            TreeBag b = TreeBag.newTreeBag((Map)this.directive.getOverrides());
            ExtdocUtils.renderMethodDirectivesBlock(this.container, (TreeBag<IMethodName>)b, numberOfSubclasses, OverridesProvider.this.workspaceBus, OverridesProvider.this.resolver, Messages.EXTDOC_OVERRIDES_OVERRIDES);
        }
    }
}

