/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.jayes.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class ArrayUtils {
    private ArrayUtils() {
    }

    public static <T extends Number> Object toPrimitiveArray(T[] array) {
        Class<?> primitiveClass = ArrayUtils.getPrimitiveClass(array.getClass().getComponentType());
        Object arr = Array.newInstance(primitiveClass, array.length);
        int i = 0;
        while (i < array.length) {
            Array.set(arr, i, array[i]);
            ++i;
        }
        return arr;
    }

    public static <T extends Number> T[] toWrapperArray(Object array) {
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("not an array");
        }
        Class<?> primitiveClass = ArrayUtils.getWrapperClass(array.getClass().getComponentType());
        Object arr = Array.newInstance(primitiveClass, Array.getLength(array));
        int i = 0;
        while (i < Array.getLength(array)) {
            Array.set(arr, i, Array.get(array, i));
            ++i;
        }
        return (Number[])arr;
    }

    private static Class<?> getWrapperClass(Class<?> componentType) {
        if (Integer.TYPE.isAssignableFrom(componentType)) {
            return Integer.class;
        }
        if (Double.TYPE.isAssignableFrom(componentType)) {
            return Double.class;
        }
        return null;
    }

    private static Class<?> getPrimitiveClass(Class<?> componentType) {
        if (Integer.class.isAssignableFrom(componentType)) {
            return Integer.TYPE;
        }
        if (Double.class.isAssignableFrom(componentType)) {
            return Double.TYPE;
        }
        throw new UnsupportedOperationException("Mapping not implemented");
    }

    public static <T> T[] shift(T[] arr, int amount) {
        T[] result = Arrays.copyOf(arr, arr.length);
        int i = 0;
        while (i < arr.length) {
            result[(i + amount) % arr.length] = arr[i];
            ++i;
        }
        return result;
    }

    public static double[] flatten(Object array) {
        ArrayList<Double> doubles = new ArrayList<Double>();
        ArrayUtils.flatten(array, doubles);
        double[] result = new double[doubles.size()];
        int index = 0;
        for (Double d : doubles) {
            result[index] = d;
            ++index;
        }
        return result;
    }

    private static void flatten(Object array, List<Double> acc) {
        if (array.getClass().isArray()) {
            int i = 0;
            while (i < Array.getLength(array)) {
                ArrayUtils.flatten(Array.get(array, i), acc);
                ++i;
            }
        } else if (array.getClass().isAssignableFrom(Double.class)) {
            acc.add((Double)array);
        } else {
            throw new IllegalArgumentException("not a double array!");
        }
    }

    public static <T> T[] reverse(T[] array) {
        List<Object> l = Arrays.asList(array);
        Collections.reverse(l);
        return l.toArray((Object[])Array.newInstance(array.getClass().getComponentType(), array.length));
    }
}

