/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils.rcp;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class CompletionProposalDecorator
implements IJavaCompletionProposal,
ICompletionProposalExtension,
ICompletionProposalExtension2,
ICompletionProposalExtension3,
ICompletionProposalExtension5,
ICompletionProposalExtension6 {
    private final AbstractJavaCompletionProposal delegate;
    private final double probablity;

    public CompletionProposalDecorator(IJavaCompletionProposal delegate, double probablity) {
        Checks.ensureIsNotNull((Object)delegate, (String)"delegate", (Object[])new Object[0]);
        this.delegate = (AbstractJavaCompletionProposal)delegate;
        this.probablity = probablity;
    }

    public void apply(IDocument document) {
        this.delegate.apply(document);
    }

    public String getAdditionalProposalInfo() {
        return this.delegate.getAdditionalProposalInfo();
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        return this.delegate.getAdditionalProposalInfo(monitor);
    }

    public IContextInformation getContextInformation() {
        return this.delegate.getContextInformation();
    }

    public String getDisplayString() {
        return this.delegate.getDisplayString();
    }

    public Image getImage() {
        return this.delegate.getImage();
    }

    private int computePercentage() {
        double precentage = this.probablity * 100.0;
        return (int)Math.rint(precentage);
    }

    public Point getSelection(IDocument document) {
        return this.delegate.getSelection(document);
    }

    public StyledString getStyledDisplayString() {
        int percentage = this.computePercentage();
        StyledString origStyledString = this.delegate.getStyledDisplayString();
        if (origStyledString.toString().endsWith("%")) {
            return origStyledString;
        }
        StyledString appendix = new StyledString(" - " + percentage + " %", StyledString.COUNTER_STYLER);
        StyledString res = origStyledString.append(appendix);
        return res;
    }

    public String toString() {
        return this.getDisplayString();
    }

    public int getRelevance() {
        return this.delegate.getRelevance();
    }

    public IInformationControlCreator getInformationControlCreator() {
        return this.delegate.getInformationControlCreator();
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return this.delegate.getPrefixCompletionText(document, completionOffset);
    }

    public int getPrefixCompletionStart(IDocument document, int completionOffset) {
        return this.delegate.getPrefixCompletionStart(document, completionOffset);
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        this.delegate.apply(viewer, trigger, stateMask, offset);
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
        this.delegate.selected(viewer, smartToggle);
    }

    public void unselected(ITextViewer viewer) {
        this.delegate.unselected(viewer);
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        return this.delegate.validate(document, offset, event);
    }

    public void apply(IDocument document, char trigger, int offset) {
        this.delegate.apply(document, trigger, offset);
    }

    public boolean isValidFor(IDocument document, int offset) {
        return this.delegate.isValidFor(document, offset);
    }

    public char[] getTriggerCharacters() {
        return this.delegate.getTriggerCharacters();
    }

    public int getContextInformationPosition() {
        return this.delegate.getContextInformationPosition();
    }
}

