/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.communication.factory.hessian.serializer;

import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.Deserializer;
import com.caucho.hessian.io.HessianProtocolException;
import com.caucho.hessian.io.JavaDeserializer;
import com.caucho.hessian.io.JavaSerializer;
import com.caucho.hessian.io.Serializer;
import java.io.IOException;
import java.math.BigInteger;
import org.eclipse.riena.communication.factory.hessian.serializer.AbstractRienaSerializerFactory;

public class BigIntegerSerializerFactory
extends AbstractRienaSerializerFactory {
    public Deserializer getDeserializer(Class cl) throws HessianProtocolException {
        if (cl == BigInteger.class) {
            return new JavaDeserializer(cl){

                public Class getType() {
                    return BigInteger.class;
                }

                public Object readObject(AbstractHessianInput in, String[] fieldNames) throws IOException {
                    BigInteger result = new BigInteger(in.readString());
                    in.addRef((Object)result);
                    return result;
                }
            };
        }
        return null;
    }

    public Serializer getSerializer(Class cl) throws HessianProtocolException {
        if (cl == BigInteger.class) {
            return new JavaSerializer(cl){

                public void writeInstance(Object obj, AbstractHessianOutput out) throws IOException {
                    BigInteger bi = (BigInteger)obj;
                    out.writeString(bi.toString());
                }
            };
        }
        return null;
    }
}

