/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.riena.core.util.VariableManagerUtil;
import org.eclipse.riena.internal.core.Activator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;

public final class RienaStatus {
    public static final String RIENA_DEVELOPMENT_SYSTEM_PROPERTY = "riena.development";
    public static final String RIENA_TEST_SYSTEM_PROPERTY = "riena.test";
    public static final String DEVELOPMENT_DEFAULT = RienaStatus.inOsgiDevMode();
    public static final String TEST_DEFAULT = "false";
    public static final String UNKNOWN_STAGE = "<unknown>";

    private RienaStatus() {
    }

    public static boolean isActive() {
        if (Activator.getDefault() == null) {
            return false;
        }
        return Activator.getDefault().isActive();
    }

    public static boolean areStartupActionsExecuted() {
        return Activator.getDefault().areStartupActionsExecuted();
    }

    public static boolean isDevelopment() {
        return Boolean.parseBoolean(System.getProperty(RIENA_DEVELOPMENT_SYSTEM_PROPERTY, DEVELOPMENT_DEFAULT));
    }

    private static String inOsgiDevMode() {
        return Boolean.toString(System.getProperty("osgi.dev") != null);
    }

    public static boolean isTest() {
        return Boolean.parseBoolean(System.getProperty(RIENA_TEST_SYSTEM_PROPERTY, TEST_DEFAULT));
    }

    public static String getStage() {
        try {
            return VariableManagerUtil.substitute("${riena.stage}");
        }
        catch (CoreException coreException) {
            return UNKNOWN_STAGE;
        }
    }

    public static String reportUnresolvedBundles() {
        Bundle coreBundle = FrameworkUtil.getBundle(RienaStatus.class);
        if (coreBundle == null) {
            return "Could not resolve Riena core bundle.";
        }
        BundleContext bundleContext = coreBundle.getBundleContext();
        if (bundleContext == null) {
            return "Could not get Riena bundle context.";
        }
        StringBuilder bob = new StringBuilder();
        Bundle[] bundleArray = bundleContext.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (bundle.getState() < 4) {
                BundleException resolutionFailureException;
                if (bob.length() == 0) {
                    bob.append("Unresolved bundles:").append("\n");
                }
                bob.append(" - ").append(bundle.getSymbolicName()).append(" is not resolved");
                if (bundle instanceof AbstractBundle && (resolutionFailureException = ((AbstractBundle)bundle).getResolutionFailureException()) != null) {
                    bob.append(" because: ").append(resolutionFailureException.getMessage());
                }
                bob.append("\n");
            }
            ++n2;
        }
        return bob.length() == 0 ? null : bob.toString();
    }
}

