/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.internal.core.Activator;
import org.osgi.framework.Bundle;

public final class ContainerModel {
    public static final String RIENA_CONTAINER_TYPE = "riena.container.type";
    public static final String ORG_ECLIPSE_EQUINOX_HTTP = "org.eclipse.equinox.http";
    private static Type containerType;

    static {
        ContainerModel.initialize();
    }

    private ContainerModel() {
    }

    public static boolean isClient() {
        return containerType == Type.CLIENT;
    }

    public static boolean isServer() {
        return containerType == Type.SERVER;
    }

    private static void initialize() {
        containerType = ContainerModel.retrieveContainerType();
        Log4r.getLogger((IRienaActivator)Activator.getDefault(), ContainerModel.class).log(3, "!!! Riena is running in " + (Object)((Object)containerType) + " mode !!!");
    }

    private static Type retrieveContainerType() {
        Bundle[] bundles;
        String s = System.getProperty(RIENA_CONTAINER_TYPE);
        if (s != null) {
            return s.equals("server") ? Type.SERVER : Type.CLIENT;
        }
        Bundle[] bundleArray = bundles = Activator.getDefault().getContext().getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (bundle.getSymbolicName().startsWith(ORG_ECLIPSE_EQUINOX_HTTP)) {
                return Type.SERVER;
            }
            ++n2;
        }
        return Type.CLIENT;
    }

    private static enum Type {
        CLIENT,
        SERVER;

    }
}

