/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.e4.launcher;

import javax.inject.Inject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.core.services.statusreporter.StatusReporter;
import org.eclipse.e4.ui.workbench.lifecycle.PostContextCreate;
import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.e4.launcher.Activator;
import org.eclipse.riena.e4.launcher.exception.E4UncaughtExceptionHandler;
import org.eclipse.riena.e4.launcher.listener.RienaNavigationObserver;
import org.eclipse.riena.e4.launcher.part.RienaPartHelper;
import org.eclipse.riena.e4.launcher.security.LoginHelper;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.ui.application.IApplicationModelCreator;
import org.eclipse.riena.navigation.ui.controllers.ApplicationController;
import org.eclipse.riena.navigation.ui.swt.application.LoginNonActivityTimer;
import org.eclipse.riena.navigation.ui.swt.application.SwtApplication;
import org.eclipse.riena.navigation.ui.swt.binding.InjectSwtViewBindingDelegate;
import org.eclipse.riena.ui.ridgets.controller.IController;

public class ApplicationLifeCycle {
    private static final String MODEL_CREATORS_EXT_POINT_SUFFIX = ".applicationModelCreators";
    @Inject
    private IExtensionRegistry extensionRegistry;
    @Inject
    private Logger logger;
    @Inject
    private IEclipseContext eclipseContext;

    @PostContextCreate
    public void initRienaApplicationNode() {
        E4UncaughtExceptionHandler exceptioHandler = new E4UncaughtExceptionHandler().install();
        Wire.instance((Object)exceptioHandler).andStart(Activator.getDefault().getBundleContext());
        this.eclipseContext.set(StatusReporter.class, (Object)exceptioHandler);
        this.eclipseContext.set(LoginNonActivityTimer.ILoginExecutor.class, ((LoginHelper)ContextInjectionFactory.make(LoginHelper.class, (IEclipseContext)this.eclipseContext)).checkLogin());
        IApplicationModelCreator applicationModelCreator = this.getApplicationModelCreatorFromExtension();
        if (applicationModelCreator == null) {
            applicationModelCreator = new SwtApplication();
        }
        IApplicationNode applicationNode = this.createModel(applicationModelCreator);
        this.eclipseContext.set(IApplicationNode.class, (Object)applicationNode);
        applicationModelCreator.initApplicationNode(applicationNode);
        this.observeRienaNavigation(applicationNode);
        new InjectSwtViewBindingDelegate().bind((IController)new ApplicationController(applicationNode));
    }

    private IApplicationNode createModel(IApplicationModelCreator creator) {
        Wire.instance((Object)creator).andStart(Activator.getDefault().getBundleContext());
        creator.configure();
        return creator.createModel();
    }

    private IApplicationModelCreator getApplicationModelCreatorFromExtension() {
        IConfigurationElement[] iConfigurationElementArray = this.extensionRegistry.getConfigurationElementsFor("org.eclipse.riena.navigation.ui.applicationModelCreators");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            try {
                return (IApplicationModelCreator)configElement.createExecutableExtension("class");
            }
            catch (CoreException coreException) {
                this.logger.error((Throwable)coreException);
                ++n2;
            }
        }
        return null;
    }

    private void observeRienaNavigation(IApplicationNode applicationNode) {
        this.eclipseContext.set(RienaPartHelper.class, (Object)((RienaPartHelper)ContextInjectionFactory.make(RienaPartHelper.class, (IEclipseContext)this.eclipseContext)));
        ((RienaNavigationObserver)ContextInjectionFactory.make(RienaNavigationObserver.class, (IEclipseContext)this.eclipseContext)).install(applicationNode);
    }
}

