/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.e4.launcher.listener;

import java.util.List;
import javax.inject.Inject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MAdvancedFactory;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MBasicFactory;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.riena.e4.launcher.Activator;
import org.eclipse.riena.e4.launcher.binder.SubApplicationBinder;
import org.eclipse.riena.e4.launcher.listener.PrepareNodeDelegate;
import org.eclipse.riena.e4.launcher.part.NavigationPart;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.listener.SubApplicationNodeListener;
import org.eclipse.riena.navigation.ui.swt.presentation.SwtViewProvider;

public class PerspectiveSubApplicationNodeListener
extends SubApplicationNodeListener {
    private static final String PERSPECTIVES_EXT_POINT = "org.eclipse.ui.perspectives";
    private final PrepareNodeDelegate<ISubApplicationNode> prepareNodeDelegate = new PrepareNodeDelegate();
    @Inject
    private IEclipseContext context;

    public void activated(ISubApplicationNode source) {
        if (source != null) {
            this.showPerspective(source);
            if (source.getNavigationNodeController() == null) {
                this.createNodeController(source);
            }
            this.prepareNodeDelegate.prepare(source);
        }
    }

    private void createNodeController(ISubApplicationNode source) {
        SubApplicationBinder binder = new SubApplicationBinder(source);
        ContextInjectionFactory.inject((Object)binder, (IEclipseContext)this.context);
        binder.bind();
    }

    private void showPerspective(ISubApplicationNode source) {
        String perspectiveId = SwtViewProvider.getInstance().getSwtViewId((INavigationNode)source).getId();
        MPerspective perspective = this.findPerspective(perspectiveId);
        if (perspective == null) {
            IExtensionRegistry extensionRegistry = (IExtensionRegistry)this.context.get(IExtensionRegistry.class);
            EModelService modelService = (EModelService)this.context.get(EModelService.class);
            MApplication searchRoot = (MApplication)this.context.get(MApplication.class);
            MElementContainer perspectiveStack = (MElementContainer)modelService.find("org.eclipse.riena.e4.launcher.perspectiveStack", (MUIElement)searchRoot);
            IConfigurationElement[] iConfigurationElementArray = extensionRegistry.getConfigurationElementsFor(PERSPECTIVES_EXT_POINT);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                if (perspectiveId.equals(e.getAttribute("id"))) {
                    MPerspective newPerspective = MAdvancedFactory.INSTANCE.createPerspective();
                    newPerspective.setElementId(e.getAttribute("id"));
                    perspectiveStack.getChildren().add(newPerspective);
                    newPerspective.setParent(perspectiveStack);
                    MPart navigationPart = MBasicFactory.INSTANCE.createPart();
                    navigationPart.setElementId("org.eclipse.riena.navigation.ui.swt.views.navigationViewPart");
                    String pluginId = Activator.getDefault().getBundleContext().getBundle().getSymbolicName();
                    navigationPart.setContributionURI("bundleclass://" + pluginId + "/" + NavigationPart.class.getName());
                    newPerspective.getChildren().add(navigationPart);
                    navigationPart.setParent((MElementContainer)newPerspective);
                    MPartStack partStack = MBasicFactory.INSTANCE.createPartStack();
                    partStack.setElementId("org.eclipse.riena.e4.launcher.contentPartStack");
                    newPerspective.getChildren().add(partStack);
                    partStack.setParent((MElementContainer)newPerspective);
                    perspective = newPerspective;
                }
                ++n2;
            }
        }
        if (perspective == null) {
            throw new IllegalStateException("Perspective not found, id: " + perspectiveId);
        }
        perspective.getParent().setSelectedElement((MUIElement)perspective);
    }

    private MPerspective findPerspective(String perspectiveId) {
        MApplication searchRoot;
        EModelService modelService = (EModelService)this.context.get(EModelService.class);
        List perspectives = modelService.findElements((MUIElement)(searchRoot = (MApplication)this.context.get(MApplication.class)), perspectiveId, MPerspective.class, null, 4);
        if (perspectives.isEmpty()) {
            return null;
        }
        return (MPerspective)perspectives.get(0);
    }

    public void disposed(ISubApplicationNode source) {
        MElementContainer perspectiveStack;
        SwtViewProvider viewProvider = SwtViewProvider.getInstance();
        String perspectiveId = viewProvider.getSwtViewId((INavigationNode)source).getId();
        MPerspective perspective = this.findPerspective(perspectiveId);
        if (perspective != null && (perspectiveStack = perspective.getParent()) != null) {
            perspectiveStack.getChildren().remove(perspective);
        }
        viewProvider.unregisterSwtViewId((INavigationNode)source);
    }
}

