/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.e4.launcher.listener;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.e4.launcher.RienaE4MenuUtils;
import org.eclipse.riena.e4.launcher.listener.PrepareNodeDelegate;
import org.eclipse.riena.e4.launcher.part.RienaPartHelper;
import org.eclipse.riena.e4.launcher.part.uielements.CoolBarComposite;
import org.eclipse.riena.internal.navigation.ui.swt.handlers.NavigationSourceProvider;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.listener.SubModuleNodeListener;
import org.eclipse.riena.navigation.ui.swt.component.MenuCoolBarComposite;
import org.eclipse.riena.navigation.ui.swt.views.RienaMenuHelper;
import org.eclipse.riena.ui.ridgets.controller.IController;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.ISourceProviderListener;

public class ShowPartSubModuleNodeListener
extends SubModuleNodeListener {
    private static final Logger LOGGER = Log4r.getLogger(ShowPartSubModuleNodeListener.class);
    private final PrepareNodeDelegate<ISubModuleNode> prepareNodeDelegate = new PrepareNodeDelegate();
    private final ISourceProviderListener menuSourceProviderListener = new MenuSourceProviderListener();
    private final RienaMenuHelper menuBindHelper = new RienaMenuHelper();
    private ISubModuleNode subModuleNode;
    @Inject
    private IEclipseContext context;
    @Inject
    private RienaPartHelper partHelper;

    public void activated(ISubModuleNode source) {
        this.subModuleNode = source;
        this.prepareNodeDelegate.prepare(source);
        this.partHelper.showPart(source);
        this.updateNavigationSourceProvider(source);
        this.updateContextWithSourceProviders();
    }

    public void afterDeactivated(ISubModuleNode source) {
        this.menuBindHelper.removeSourceProviderListener(this.menuSourceProviderListener);
        super.afterDeactivated((INavigationNode)source);
    }

    private void updateContextWithSourceProviders() {
        ISourceProvider[] sourceProviders;
        ISourceProvider[] iSourceProviderArray = sourceProviders = new RienaMenuHelper().getSourceProviders();
        int n = sourceProviders.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceProvider sourceProvider = iSourceProviderArray[n2];
            Set<Map.Entry<Object, Object>> entrySet = this.getCurrentState(sourceProvider);
            for (Map.Entry<Object, Object> entry : entrySet) {
                if (!(entry.getKey() instanceof String)) continue;
                this.context.set((String)entry.getKey(), entry.getValue());
            }
            ++n2;
        }
    }

    private Set<Map.Entry<Object, Object>> getCurrentState(ISourceProvider sourceProvider) {
        Map state = null;
        try {
            state = sourceProvider.getCurrentState();
        }
        catch (Exception exception) {
            String msg = "SourceProvider \"" + sourceProvider.getClass().getSimpleName() + "\" is not supported!";
            LOGGER.log(2, msg);
        }
        if (state != null) {
            Set<Map.Entry<Object, Object>> entrySet = state.entrySet();
            return entrySet;
        }
        return Collections.emptySet();
    }

    private void updateNavigationSourceProvider(ISubModuleNode source) {
        ISourceProvider[] sourceProviders;
        ISourceProvider[] iSourceProviderArray = sourceProviders = this.menuBindHelper.getSourceProviders();
        int n = sourceProviders.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceProvider sourceProvider = iSourceProviderArray[n2];
            if (sourceProvider instanceof NavigationSourceProvider) {
                ((NavigationSourceProvider)sourceProvider).activeNodeChanged((INavigationNode)source);
            }
            ++n2;
        }
    }

    public void parentChanged(ISubModuleNode source) {
        this.prepareNodeDelegate.prepare(source);
    }

    public void afterActivated(ISubModuleNode source) {
        this.menuBindHelper.addSourceProviderListener(this.menuSourceProviderListener);
        this.updateMenuBars();
    }

    private void updateMenuBars() {
        CoolBarComposite coolBarComposite;
        MenuCoolBarComposite menuCoolBarComposite = RienaE4MenuUtils.getMenuCoolBarComposite(this.context);
        if (menuCoolBarComposite != null) {
            menuCoolBarComposite.updateMenuItems();
        }
        if ((coolBarComposite = RienaE4MenuUtils.getCoolBarComposite(this.context)) != null) {
            coolBarComposite.updateItems();
        }
        if (this.getSubApplicationNode().getNavigationNodeController() instanceof IController) {
            RienaMenuHelper bindHelper = new RienaMenuHelper();
            bindHelper.bindMenuAndToolItems((IController)this.getSubApplicationNode().getNavigationNodeController(), (Composite)menuCoolBarComposite, (Composite)coolBarComposite);
        }
    }

    public void disposed(ISubModuleNode source) {
        this.partHelper.disposeNode(source);
    }

    private ISubApplicationNode getSubApplicationNode() {
        return (ISubApplicationNode)this.subModuleNode.getParentOfType(ISubApplicationNode.class);
    }

    private class MenuSourceProviderListener
    implements ISourceProviderListener {
        private MenuSourceProviderListener() {
        }

        private void update(int sourcePriority) {
            if ((sourcePriority & Integer.MIN_VALUE) == Integer.MIN_VALUE && ShowPartSubModuleNodeListener.this.getSubApplicationNode().isSelected()) {
                ShowPartSubModuleNodeListener.this.updateContextWithSourceProviders();
                ShowPartSubModuleNodeListener.this.updateMenuBars();
            }
        }

        public void sourceChanged(int sourcePriority, Map sourceValuesByName) {
            this.update(sourcePriority);
        }

        public void sourceChanged(int sourcePriority, String sourceName, Object sourceValue) {
            this.update(sourcePriority);
        }
    }
}

