/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.e4.launcher.part;

import javax.inject.Inject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.riena.navigation.ApplicationNodeManager;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.ApplicationController;
import org.eclipse.riena.navigation.ui.swt.binding.InjectSwtViewBindingDelegate;
import org.eclipse.riena.ui.ridgets.IStatuslineNumberRidget;
import org.eclipse.riena.ui.ridgets.IStatuslineRidget;
import org.eclipse.riena.ui.ridgets.controller.IController;
import org.eclipse.riena.ui.swt.DefaultStatuslineContentFactory;
import org.eclipse.riena.ui.swt.GrabCorner;
import org.eclipse.riena.ui.swt.IStatusLineContentFactory;
import org.eclipse.riena.ui.swt.Statusline;
import org.eclipse.riena.ui.swt.StatuslineSpacer;
import org.eclipse.riena.ui.swt.lnf.LnFUpdater;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class StatusLinePart {
    public static final int BOTTOM_OFFSET = 3;
    @Inject
    private IExtensionRegistry extensionRegistry;

    @Inject
    public void create(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new FormLayout());
        GrabCorner grabCorner = null;
        if (GrabCorner.isResizeable() && LnfManager.getLnf().getBooleanSetting("Shell.hideOsBorder").booleanValue()) {
            grabCorner = new GrabCorner(c, 0x20000000, true);
            FormData layoutData = (FormData)grabCorner.getLayoutData();
            layoutData.right.offset = 0;
            layoutData.bottom.offset = 0;
        }
        Statusline statusLine = this.createStatusLine(c, (Composite)grabCorner);
        IStatuslineRidget statusLineRidget = this.addUIControl(statusLine, "statusline");
        ISubModuleNode activeSubModuleNode = ApplicationNodeManager.locateActiveSubModuleNode();
        IStatuslineNumberRidget numberRidget = statusLineRidget.getStatuslineNumberRidget();
        if (activeSubModuleNode != null && numberRidget != null) {
            numberRidget.setNumberString(activeSubModuleNode.getLabel());
        }
    }

    private Statusline createStatusLine(Composite parent, Composite grabCorner) {
        IStatusLineContentFactory statusLineFactory = this.getStatusLineContentFactory();
        Statusline statusLine = new Statusline(parent, 0, StatuslineSpacer.class, statusLineFactory);
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = grabCorner != null ? new FormAttachment((Control)grabCorner, 0) : new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, -3);
        statusLine.setLayoutData((Object)fd);
        LnFUpdater.getInstance().updateUIControls((Composite)statusLine, true);
        return statusLine;
    }

    private IStatuslineRidget addUIControl(Statusline statusLine, String bindingId) {
        InjectSwtViewBindingDelegate binding = new InjectSwtViewBindingDelegate();
        binding.addUIControl((Object)statusLine, bindingId);
        ApplicationController applicationController = (ApplicationController)ApplicationNodeManager.getApplicationNode().getNavigationNodeController();
        binding.injectAndBind((IController)applicationController);
        return applicationController.getStatusline();
    }

    private IStatusLineContentFactory getStatusLineContentFactory() {
        IConfigurationElement[] extensions = this.extensionRegistry.getConfigurationElementsFor("org.eclipse.riena.navigation.ui.swt.statusLine");
        if (extensions.length == 0) {
            return new DefaultStatuslineContentFactory();
        }
        try {
            return (IStatusLineContentFactory)extensions[0].createExecutableExtension("factory");
        }
        catch (CoreException e) {
            e.printStackTrace();
            return new DefaultStatuslineContentFactory();
        }
    }
}

