/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.riena.beans.common.ListBean;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IFilterableContentRidget;
import org.eclipse.riena.ui.ridgets.IListRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContentFilter;
import org.eclipse.riena.ui.ridgets.ITableRidget;
import org.eclipse.riena.ui.ridgets.IToggleButtonRidget;
import org.eclipse.riena.ui.ridgets.ITreeRidget;

public class ContentFilterSubModuleController
extends SubModuleController {
    private static final List<Something> DAYS = Arrays.asList(new Something("Monday"), new Something("Tuesday"), new Something("Wednesday"), new Something("Thursday"), new Something("Friday"), new Something("Saturday"), new Something("Sunday"));
    private static final List<String> RIDGET_IDS = Arrays.asList("list", "table", "tree");
    private final IRidgetContentFilter hideWeekendFilter = new HideWeekendFilter();
    private final IRidgetContentFilter hideWeekdaysFilter = new HideWeekdaysFilter();

    public ContentFilterSubModuleController() {
        this(null);
    }

    public ContentFilterSubModuleController(ISubModuleNode navigationNode) {
        super(navigationNode);
    }

    public void configureRidgets() {
        IListRidget list = (IListRidget)this.getRidget(IListRidget.class, "list");
        list.bindToModel((Object)new ListBean(DAYS), "values", Something.class, "name");
        ITableRidget table = (ITableRidget)this.getRidget(ITableRidget.class, "table");
        table.bindToModel((Object)new ListBean(DAYS), "values", Something.class, new String[]{"name"}, new String[]{"day"});
        ITreeRidget tree = (ITreeRidget)this.getRidget(ITreeRidget.class, "tree");
        tree.bindToModel(new Object[]{new Something("Week", DAYS)}, Something.class, "children", "name", "name");
        this.updateAllRidgetsFromModel();
        final IToggleButtonRidget hideWeekdays = (IToggleButtonRidget)this.getRidget(IToggleButtonRidget.class, "hideWeekdays");
        hideWeekdays.addListener(new IActionListener(){

            public void callback() {
                if (hideWeekdays.isSelected()) {
                    ContentFilterSubModuleController.this.setFilter(ContentFilterSubModuleController.this.hideWeekdaysFilter);
                } else {
                    ContentFilterSubModuleController.this.unsetFilter(ContentFilterSubModuleController.this.hideWeekdaysFilter);
                }
            }
        });
        final IToggleButtonRidget hideWeekend = (IToggleButtonRidget)this.getRidget(IToggleButtonRidget.class, "hideWeekend");
        hideWeekend.addListener(new IActionListener(){

            public void callback() {
                if (hideWeekend.isSelected()) {
                    ContentFilterSubModuleController.this.setFilter(ContentFilterSubModuleController.this.hideWeekendFilter);
                } else {
                    ContentFilterSubModuleController.this.unsetFilter(ContentFilterSubModuleController.this.hideWeekendFilter);
                }
            }
        });
    }

    private void setFilter(IRidgetContentFilter filter) {
        for (String id : RIDGET_IDS) {
            ((IFilterableContentRidget)this.getRidget(IFilterableContentRidget.class, id)).addFilter(filter);
        }
    }

    private void unsetFilter(IRidgetContentFilter filter) {
        for (String id : RIDGET_IDS) {
            ((IFilterableContentRidget)this.getRidget(IFilterableContentRidget.class, id)).removeFilter(filter);
        }
    }

    private boolean isWeekend(Something element) {
        return "Saturday".equals(element.getName()) || "Sunday".equals(element.getName());
    }

    private class HideWeekdaysFilter
    implements IRidgetContentFilter {
        private HideWeekdaysFilter() {
        }

        public boolean isElementVisible(Object parentElement, Object element) {
            Something s = (Something)element;
            return !s.getChildren().isEmpty() || ContentFilterSubModuleController.this.isWeekend(s);
        }
    }

    private class HideWeekendFilter
    implements IRidgetContentFilter {
        private HideWeekendFilter() {
        }

        public boolean isElementVisible(Object parentElement, Object element) {
            Something s = (Something)element;
            return !s.getChildren().isEmpty() || !ContentFilterSubModuleController.this.isWeekend(s);
        }
    }

    public static class Something {
        private final String name;
        private final List<Something> children;

        Something(String name) {
            this(name, new ArrayList<Something>());
        }

        Something(String name, List<Something> children) {
            this.name = name;
            this.children = children;
        }

        public String getName() {
            return this.name;
        }

        public List<Something> getChildren() {
            return this.children;
        }
    }
}

