/*******************************************************************************
 * Copyright (c) 2007, 2013 compeople AG and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    compeople AG - initial API and implementation
 *******************************************************************************/
package org.eclipse.riena.internal.navigation.ui.filter;

import org.eclipse.riena.ui.core.marker.OutputMarker;

/**
 * Filter rule to provide a output marker for a ridget.
 */
public class UIFilterRuleRidgetOutputMarker extends AbstractUIFilterRuleRidgetMarker {

	/**
	 * Creates a new instance of {@code UIFilterRuleRidgetOutputMarker}.
	 * 
	 * @param id
	 *            ID
	 */
	public UIFilterRuleRidgetOutputMarker() {
		super(null, new OutputMarker(false));
	}

	/**
	 * Creates a new instance of {@code UIFilterRuleRidgetOutputMarker}.
	 * 
	 * @param ridgetIdPattern
	 *            ID
	 */
	public UIFilterRuleRidgetOutputMarker(final String ridgetIdPattern) {
		super(ridgetIdPattern, new OutputMarker(false));
	}

}
